/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.expression;

import com.redhat.qute.parser.CancelChecker;
import com.redhat.qute.parser.expression.MemberPart;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.parameter.ParameterParser;
import com.redhat.qute.parser.template.ASTVisitor;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.ParametersContainer;
import java.util.List;
import java.util.stream.Collectors;

public class MethodPart
extends MemberPart
implements ParametersContainer {
    private List<Parameter> parameters;
    private int openBracketOffset = -1;
    private int closeBracketOffset = -1;
    private int endName;

    public MethodPart(int start, int end) {
        super(start, end);
        this.endName = end;
    }

    @Override
    public int getEndName() {
        return this.endName;
    }

    @Override
    public Parts.PartKind getPartKind() {
        return Parts.PartKind.Method;
    }

    void setOpenBracket(int openBracketOffset) {
        this.openBracketOffset = openBracketOffset;
        super.setEnd(openBracketOffset);
    }

    public boolean hasOpenBracket() {
        return this.openBracketOffset != -1;
    }

    void setCloseBracket(int closeBracketOffset) {
        this.closeBracketOffset = closeBracketOffset;
        super.setEnd(closeBracketOffset);
    }

    public boolean hasCloseBracket() {
        return this.closeBracketOffset != -1;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.parseParameters();
        }
        return this.parameters;
    }

    public Parameter getParameterAtOffset(int offset) {
        if (!this.isInParameters(offset)) {
            return null;
        }
        List<Parameter> parameters = this.getParameters();
        return (Parameter)Node.findNodeAt(parameters.stream().map(param -> param).collect(Collectors.toList()), offset);
    }

    public boolean isInParameters(int offset) {
        return offset >= this.getStartParametersOffset() && offset <= this.getEndParametersOffset();
    }

    private synchronized List<Parameter> parseParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        List<Parameter> parameters = ParameterParser.parse(this, true, false);
        parameters.stream().forEach(p -> p.setCanHaveExpression(true));
        return parameters;
    }

    @Override
    public int getStartParametersOffset() {
        return this.openBracketOffset + 1;
    }

    @Override
    public int getEndParametersOffset() {
        if (this.isClosed()) {
            return this.closeBracketOffset;
        }
        return this.getEnd();
    }

    @Override
    public void setEnd(int end) {
        super.setEnd(end);
    }

    @Override
    public boolean isClosed() {
        return this.hasCloseBracket();
    }

    public boolean isInfixNotation() {
        return false;
    }

    public boolean isOperator() {
        return false;
    }

    public boolean isOrOperator() {
        return false;
    }

    @Override
    public String getTemplateContent() {
        return this.getOwnerTemplate().getText();
    }

    @Override
    public CancelChecker getCancelChecker() {
        return this.getOwnerTemplate().getCancelChecker();
    }

    @Override
    protected void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }
}

