/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.expression;

import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.template.ASTVisitor;
import com.redhat.qute.parser.template.JavaTypeInfoProvider;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionKind;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.template.sections.LoopSection;

public class ObjectPart
extends Part {
    private int startName = -1;

    public ObjectPart(int start, int end) {
        super(start, end);
    }

    @Override
    public Parts.PartKind getPartKind() {
        return Parts.PartKind.Object;
    }

    @Override
    public int getStartName() {
        String text;
        Section section;
        if (this.startName != -1) {
            return this.startName;
        }
        this.startName = super.getStartName();
        Parameter parameter = this.getOwnerParameter();
        if (parameter != null && (section = parameter.getOwnerSection()) != null && section.getSectionKind() == SectionKind.IF && (text = this.getOwnerTemplate().getText()).charAt(this.startName) == '!') {
            ++this.startName;
        }
        return this.startName;
    }

    public JavaTypeInfoProvider resolveJavaType() {
        boolean hasNamespace;
        Template template = super.getOwnerTemplate();
        String partName = this.getPartName();
        boolean bl = hasNamespace = this.getNamespace() != null;
        if (hasNamespace) {
            return template.findWithNamespace(this);
        }
        Parameter matchedOptionalParameter = null;
        for (Section section = super.getParentSection(); section != null; section = section.getParentSection()) {
            switch (section.getSectionKind()) {
                case EACH: 
                case FOR: {
                    String alias;
                    LoopSection iterableSection = (LoopSection)section;
                    if (iterableSection.isInElseBlock(this.getStart()) || !partName.equals(alias = iterableSection.getAlias())) break;
                    return iterableSection.getIterableParameter();
                }
                case LET: 
                case SET: {
                    Parameter parameter = section.findParameter(partName);
                    if (parameter == null) break;
                    return parameter;
                }
                case IF: {
                    Parameter parameter;
                    if (matchedOptionalParameter != null || (parameter = section.findParameter(partName)) == null || !parameter.isOptional()) break;
                    matchedOptionalParameter = parameter;
                    break;
                }
            }
            JavaTypeInfoProvider metadata = section.getMetadata(partName);
            if (metadata == null) continue;
            return metadata;
        }
        JavaTypeInfoProvider initialDataModel = template.findInInitialDataModel(this);
        if (initialDataModel != null) {
            return initialDataModel;
        }
        JavaTypeInfoProvider globalVariable = template.findGlobalVariables(this);
        if (globalVariable != null) {
            return globalVariable;
        }
        return matchedOptionalParameter;
    }

    @Override
    protected boolean canBeOptional() {
        return true;
    }

    @Override
    protected void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }
}

