/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.expression;

import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;

public abstract class Part
extends Node {
    private String partName;
    private Boolean optional;

    public Part(int start, int end) {
        super(start, end);
    }

    @Override
    public String getNodeName() {
        return "#part";
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ExpressionPart;
    }

    public int getStartName() {
        return this.getStart();
    }

    public int getEndName() {
        this.computeOptionalIfNeeded();
        return this.getEnd();
    }

    public String getPartName() {
        if (this.partName != null) {
            return this.partName;
        }
        this.partName = this.getOwnerTemplate().getText(this.getStartName(), this.getEndName());
        return this.partName;
    }

    private void computeOptionalIfNeeded() {
        if (this.canBeOptional() && this.optional == null) {
            int endName = this.getEnd();
            this.computeOptional(endName);
        }
    }

    private synchronized void computeOptional(int end) {
        String text;
        if (this.optional != null) {
            return;
        }
        if (end - this.getStart() > 2 && (text = this.getOwnerTemplate().getText()).charAt(end - 1) == '?' && text.charAt(end - 2) == '?') {
            this.setEnd(end - 2);
            this.optional = true;
            return;
        }
        this.optional = false;
    }

    public boolean isOptional() {
        this.computeOptionalIfNeeded();
        return this.optional != null ? this.optional : false;
    }

    protected boolean canBeOptional() {
        return false;
    }

    @Override
    public Parts getParent() {
        return (Parts)super.getParent();
    }

    public boolean isLast() {
        Parts parts = this.getParent();
        return parts.getPartIndex(this) == parts.getChildCount() - 1;
    }

    @Override
    public Section getParentSection() {
        Parts parts = this.getParent();
        Expression expression = parts.getParent();
        Node parent = expression.getParent();
        if (parent.getKind() == NodeKind.Parameter) {
            Node ownerSection = parent.getParent();
            parent = ownerSection.getParent();
        }
        while (parent != null) {
            if (parent.getKind() == NodeKind.Section) {
                return (Section)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public String getNamespace() {
        Parts parts = this.getParent();
        int index = parts.getPartIndex(this);
        if (index != 1) {
            return null;
        }
        Part part = parts.getChild(0);
        if (this == part) {
            return null;
        }
        return part.getPartKind() == Parts.PartKind.Namespace ? part.getPartName() : null;
    }

    public String toString() {
        return this.getPartName();
    }

    public Parameter getOwnerParameter() {
        Expression expression = this.getParent().getParent();
        return expression != null ? expression.getOwnerParameter() : null;
    }

    public abstract Parts.PartKind getPartKind();
}

