/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.expression;

import com.redhat.qute.parser.expression.MemberPart;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.template.ASTVisitor;

public class PropertyPart
extends MemberPart {
    private Boolean bracketNotationComputed;

    public PropertyPart(int start, int end) {
        super(start, end);
    }

    @Override
    public Parts.PartKind getPartKind() {
        return Parts.PartKind.Property;
    }

    @Override
    public int getStartName() {
        this.computeBracketNotationIfNeeded();
        return super.getStartName();
    }

    @Override
    public int getEndName() {
        this.computeBracketNotationIfNeeded();
        return super.getEndName();
    }

    private void computeBracketNotationIfNeeded() {
        if (this.bracketNotationComputed != null) {
            return;
        }
        this.computeBracketNotation();
    }

    private synchronized void computeBracketNotation() {
        if (this.bracketNotationComputed != null) {
            return;
        }
        String text = this.getOwnerTemplate().getText();
        int start = super.getStartName();
        int end = super.getEndName() - 1;
        if (text.charAt(start) == '[') {
            int next;
            int n = next = text.length() > start + 1 ? (int)text.charAt(start + 1) : 65535;
            if (next == 39 || next == 34) {
                super.setStart(start + 2);
            } else {
                super.setStart(start + 1);
            }
        }
        if (text.charAt(end) == ']') {
            char previous = text.charAt(end - 1);
            if (previous == '\'' || previous == '\"') {
                super.setEnd(end - 1);
            } else {
                super.setEnd(end);
            }
        }
        this.bracketNotationComputed = true;
    }

    @Override
    protected boolean canBeOptional() {
        return true;
    }

    @Override
    protected void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }
}

