/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.expression.scanner;

import com.redhat.qute.parser.expression.scanner.ScannerState;
import com.redhat.qute.parser.expression.scanner.TokenType;
import com.redhat.qute.parser.scanner.AbstractScanner;
import com.redhat.qute.parser.template.scanner.TemplateScanner;

public class ExpressionScanner
extends AbstractScanner<TokenType, ScannerState> {
    private static final int[] QUOTE_OR_PAREN = new int[]{40, 41, 34, 39};
    private static final int[] SPACE_PERIOD_LBRACKET = new int[]{32, 46, 91};
    private static final int[] SPACE_PERIOD_LBRACKET_LPAREN_COLON = new int[]{32, 46, 91, 40, 58};
    private final boolean canSupportInfixNotation;
    private boolean inMethod;
    private int bracket;
    private boolean isInInfixNotation;
    private int nbParts;

    public static ExpressionScanner createScanner(String input, boolean canSupportInfixNotation) {
        return ExpressionScanner.createScanner(input, canSupportInfixNotation, 0, input.length());
    }

    public static ExpressionScanner createScanner(String input, boolean canSupportInfixNotation, int initialOffset, int endOffset) {
        return ExpressionScanner.createScanner(input, canSupportInfixNotation, initialOffset, endOffset, ScannerState.WithinExpression);
    }

    public static ExpressionScanner createScanner(String input, boolean canSupportInfixNotation, int initialOffset, int endOffset, ScannerState initialState) {
        return new ExpressionScanner(input, canSupportInfixNotation, initialOffset, endOffset, initialState);
    }

    ExpressionScanner(String input, boolean canSupportInfixNotation, int initialOffset, int endOffset, ScannerState initialState) {
        super(input, initialOffset, endOffset, initialState, TokenType.Unknown, TokenType.EOS);
        this.canSupportInfixNotation = canSupportInfixNotation;
    }

    @Override
    protected TokenType internalScan() {
        int offset = this.stream.pos();
        if (this.stream.eos()) {
            return this.finishToken(offset, TokenType.EOS);
        }
        String errorMessage = null;
        switch ((ScannerState)((Object)this.state)) {
            case WithinExpression: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (!this.canSupportInfixNotation && (this.stream.advanceIfChar(34) || this.stream.advanceIfChar(39))) {
                    this.state = ScannerState.WithinString;
                    return this.finishToken(this.stream.pos() - 1, TokenType.StartString);
                }
                this.nextJavaIdentifierPart();
                return this.finishTokenPart(offset);
            }
            case WithinParts: 
            case AfterNamespace: {
                if (this.stream.skipWhitespace()) {
                    ++this.nbParts;
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (!this.canSupportInfixNotation && (this.stream.advanceIfChar(34) || this.stream.advanceIfChar(39))) {
                    this.state = ScannerState.WithinString;
                    return this.finishToken(this.stream.pos() - 1, TokenType.StartString);
                }
                if (this.stream.advanceIfChar(46)) {
                    return this.finishToken(offset, TokenType.Dot);
                }
                if (this.stream.advanceIfChar(91)) {
                    if (this.stream.advanceUntilChar(93)) {
                        this.stream.advance(1);
                    }
                    return this.finishToken(offset, TokenType.PropertyPart);
                }
                if (this.stream.advanceIfChar(58)) {
                    return this.finishToken(offset, TokenType.ColonSpace);
                }
                this.nextJavaIdentifierPart();
                return this.finishTokenPart(offset);
            }
            case WithinMethod: {
                if (this.stream.advanceIfChar(40)) {
                    ++this.bracket;
                    return this.finishToken(offset, TokenType.OpenBracket);
                }
                this.stream.advanceUntilChar(QUOTE_OR_PAREN);
                if (this.stream.peekChar() == 40) {
                    this.stream.advance(1);
                    ++this.bracket;
                    return this.internalScan();
                }
                if (this.stream.peekChar() == 34 || this.stream.peekChar() == 39) {
                    this.stream.advance(1);
                    this.state = ScannerState.WithinString;
                    this.inMethod = true;
                    return this.finishToken(this.stream.pos() - 1, TokenType.StartString);
                }
                if (this.stream.peekChar() == 41) {
                    this.stream.advance(1);
                    --this.bracket;
                    if (this.bracket > 0) {
                        return this.internalScan();
                    }
                    this.state = ScannerState.WithinParts;
                    this.inMethod = false;
                    return this.finishToken(this.stream.pos() - 1, TokenType.CloseBracket);
                }
                return this.internalScan();
            }
            case WithinString: {
                if (this.stream.advanceIfAnyOfChars(TemplateScanner.QUOTE_C)) {
                    this.state = this.inMethod ? ScannerState.WithinMethod : ScannerState.WithinExpression;
                    return this.finishToken(offset, TokenType.EndString);
                }
                this.stream.advanceUntilChar(TemplateScanner.QUOTE);
                return this.finishToken(offset, TokenType.String);
            }
        }
        this.inMethod = false;
        this.stream.advance(1);
        return this.finishToken(offset, TokenType.Unknown, errorMessage);
    }

    private TokenType finishTokenPart(int offset) {
        int next = this.stream.peekChar();
        if (this.state == ScannerState.WithinParts || this.state == ScannerState.AfterNamespace) {
            TokenType lastTokenType = (TokenType)((Object)this.getTokenType());
            if (lastTokenType == TokenType.Dot) {
                if (next == 40) {
                    this.state = ScannerState.WithinMethod;
                    return this.finishToken(offset, TokenType.MethodPart);
                }
                return this.finishToken(offset, TokenType.PropertyPart);
            }
            if (this.state == ScannerState.AfterNamespace) {
                if (next == 40) {
                    this.state = ScannerState.WithinMethod;
                    return this.finishToken(offset, TokenType.MethodPart);
                }
                this.state = ScannerState.WithinParts;
                return this.finishToken(offset, TokenType.ObjectPart);
            }
            if (this.canSupportInfixNotation) {
                if (next == 46) {
                    this.stream.advanceUntilChar(32);
                }
                if (this.nbParts % 2 == 0) {
                    return this.finishToken(offset, TokenType.InfixParameter);
                }
                return this.finishToken(offset, TokenType.InfixMethodPart);
            }
        }
        if (next == 58) {
            this.state = ScannerState.AfterNamespace;
            return this.finishToken(offset, TokenType.NamespacePart);
        }
        this.state = ScannerState.WithinParts;
        return this.finishToken(offset, TokenType.ObjectPart);
    }

    private void nextJavaIdentifierPart() {
        TokenType lastTokenType = (TokenType)((Object)this.getTokenType());
        if (this.canSupportInfixNotation && lastTokenType == TokenType.Whitespace) {
            int c = this.stream.peekChar();
            if (c == 34 || c == 39) {
                this.stream.advance(1);
                this.stream.advanceUntilChar(c);
            } else {
                this.stream.advanceUntilAnyOfChars(SPACE_PERIOD_LBRACKET);
            }
        }
        this.stream.advanceUntilAnyOfChars(SPACE_PERIOD_LBRACKET_LPAREN_COLON);
    }

    public boolean isInInfixNotation() {
        return this.isInInfixNotation;
    }
}

