/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.html.scanner;

import com.redhat.qute.parser.html.scanner.ScannerState;
import com.redhat.qute.parser.html.scanner.TokenType;
import com.redhat.qute.parser.scanner.AbstractScanner;
import java.util.function.Predicate;

public class HtmlScanner
extends AbstractScanner<TokenType, ScannerState> {
    private static final Predicate<Integer> PARAM_SPLITTED_BY_ONLY_SPACE = ch -> ch != 32;
    private static final int[] SPACE_ASSIGN = new int[]{32, 61};

    public static HtmlScanner createScanner(String input) {
        return HtmlScanner.createScanner(input, 0, input.length());
    }

    public static HtmlScanner createScanner(String input, int initialOffset, int endOffset) {
        return new HtmlScanner(input, initialOffset, endOffset, ScannerState.WithinElementName);
    }

    HtmlScanner(String input, int initialOffset, int endOffset, ScannerState initialState) {
        super(input, initialOffset, endOffset, initialState, TokenType.Unknown, TokenType.EOS);
    }

    @Override
    protected TokenType internalScan() {
        int offset = this.stream.pos();
        if (this.stream.eos()) {
            return this.finishToken(offset, TokenType.EOS);
        }
        String errorMessage = null;
        switch ((ScannerState)((Object)this.state)) {
            case WithinElementName: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChar(60)) {
                    return this.finishToken(offset, TokenType.Bracket);
                }
                if (this.hasNextParameterNameOrValue()) {
                    this.state = ScannerState.WithinAttributeName;
                    return this.finishToken(offset, TokenType.ElementName);
                }
                return this.finishToken(offset, TokenType.Unknown);
            }
            case WithinAttributeName: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChar(61)) {
                    this.state = ScannerState.AfterAssign;
                    return this.finishToken(offset, TokenType.Assign);
                }
                if (this.stream.advanceIfChar(62)) {
                    this.state = ScannerState.AfterAssign;
                    return this.finishToken(offset, TokenType.Bracket);
                }
                if (this.stream.advanceUntilAnyOfChars(SPACE_ASSIGN)) {
                    int c = this.stream.peekCharAtOffset(this.stream.pos() - 1);
                    this.state = ScannerState.WithinAttributeName;
                    if (c == 32) {
                        return this.finishToken(offset, TokenType.Whitespace);
                    }
                    return this.finishToken(offset, TokenType.AttributeName);
                }
                return this.finishToken(offset, TokenType.Unknown);
            }
            case AfterAssign: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                int c = this.stream.peekChar();
                if (c != 34 && c != 39) break;
                this.stream.advance(1);
                if (this.stream.advanceUntilChar(c)) {
                    this.stream.advance(1);
                }
                this.state = ScannerState.WithinAttributeName;
                return this.finishToken(offset, TokenType.AttributeValue);
            }
        }
        this.stream.advance(1);
        return this.finishToken(offset, TokenType.Unknown, errorMessage);
    }

    private boolean hasNextParameterNameOrValue() {
        return this.stream.advanceWhileChar(PARAM_SPLITTED_BY_ONLY_SPACE) > 0;
    }
}

