/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.parameter;

import com.redhat.qute.parser.CancelChecker;
import com.redhat.qute.parser.parameter.scanner.ParameterScanner;
import com.redhat.qute.parser.parameter.scanner.TokenType;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.ParametersContainer;
import java.util.ArrayList;
import java.util.List;

public class ParameterParser {
    private static CancelChecker DEFAULT_CANCEL_CHECKER = () -> {};

    public static List<Parameter> parse(ParametersContainer container, boolean methodParameters, boolean splitWithEquals) {
        int start = container.getStartParametersOffset();
        int end = container.getEndParametersOffset();
        return ParameterParser.parse(start, end, container, methodParameters, splitWithEquals);
    }

    public static List<Parameter> parse(int start, int end, ParametersContainer container, boolean methodParameters, boolean splitWithEquals) {
        CancelChecker cancelChecker = container.getCancelChecker();
        if (cancelChecker == null) {
            cancelChecker = DEFAULT_CANCEL_CHECKER;
        }
        String text = container.getTemplateContent();
        ParameterScanner scanner = ParameterScanner.createScanner(text, start, end, methodParameters, splitWithEquals);
        TokenType token = (TokenType)((Object)scanner.scan());
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter currentParameter = null;
        while (token != TokenType.EOS) {
            cancelChecker.checkCanceled();
            int tokenOffset = scanner.getTokenOffset();
            int tokenEnd = scanner.getTokenEnd();
            switch (token) {
                case Whitespace: {
                    currentParameter = null;
                    break;
                }
                case ParameterName: {
                    currentParameter = new Parameter(tokenOffset, tokenEnd);
                    currentParameter.setParameterParent(container);
                    parameters.add(currentParameter);
                    break;
                }
                case Assign: {
                    if (currentParameter == null) break;
                    currentParameter.setAssignOffset(tokenOffset);
                    break;
                }
                case ParameterValue: {
                    if (currentParameter == null) break;
                    currentParameter.setStartValue(tokenOffset);
                    currentParameter.setEndValue(tokenEnd);
                    break;
                }
            }
            token = (TokenType)((Object)scanner.scan());
        }
        return parameters;
    }
}

