/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.parameter.scanner;

import com.redhat.qute.parser.parameter.scanner.ScannerState;
import com.redhat.qute.parser.parameter.scanner.TokenType;
import com.redhat.qute.parser.scanner.AbstractScanner;
import java.util.function.Predicate;

public class ParameterScanner
extends AbstractScanner<TokenType, ScannerState> {
    private static final int[] PAREN_COMMA = new int[]{40, 41, 44};
    private static final Predicate<Integer> PARAM_SPLITTED_BY_ONLY_SPACE = ch -> ch != 32;
    private static final Predicate<Integer> PARAM_SPLITTED_BY_SPACE_OR_EQUALS = ch -> ch != 32 && ch != 61;
    private final boolean methodParameters;
    private final boolean splitWithEquals;
    private int bracket;

    public static ParameterScanner createScanner(String input) {
        return ParameterScanner.createScanner(input, false, true);
    }

    public static ParameterScanner createScanner(String input, boolean methodParameters, boolean splitWithEquals) {
        return ParameterScanner.createScanner(input, 0, input.length(), methodParameters, splitWithEquals);
    }

    public static ParameterScanner createScanner(String input, int initialOffset, int endOffset, boolean methodParameters, boolean splitWithEquals) {
        return ParameterScanner.createScanner(input, initialOffset, endOffset, methodParameters, splitWithEquals, ScannerState.WithinParameter);
    }

    public static ParameterScanner createScanner(String input, int initialOffset, int endOffset, boolean methodParameters, boolean splitWithEquals, ScannerState initialState) {
        return new ParameterScanner(input, initialOffset, endOffset, methodParameters, splitWithEquals, initialState);
    }

    ParameterScanner(String input, int initialOffset, int endOffset, boolean methodParameters, boolean splitWithEquals, ScannerState initialState) {
        super(input, initialOffset, endOffset, initialState, TokenType.Unknown, TokenType.EOS);
        this.methodParameters = methodParameters;
        this.splitWithEquals = splitWithEquals;
    }

    @Override
    protected TokenType internalScan() {
        int offset = this.stream.pos();
        if (this.stream.eos()) {
            return this.finishToken(offset, TokenType.EOS);
        }
        String errorMessage = null;
        switch ((ScannerState)((Object)this.state)) {
            case WithinParameters: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.methodParameters) {
                    return this.parseParameterName(offset);
                }
                if (this.hasNextParameterNameOrValue()) {
                    this.state = ScannerState.WithinParameter;
                    return this.finishToken(offset, TokenType.ParameterName);
                }
                return this.finishToken(offset, TokenType.Unknown);
            }
            case WithinParameter: {
                if (!this.methodParameters && this.splitWithEquals && this.stream.advanceIfChar(61)) {
                    this.state = !this.stream.eos() && (this.stream.peekChar() == 32 || this.stream.peekChar() == 61) ? ScannerState.WithinParameters : ScannerState.AfterAssign;
                    return this.finishToken(offset, TokenType.Assign);
                }
                this.state = ScannerState.WithinParameters;
                return this.internalScan();
            }
            case AfterAssign: {
                int c = this.stream.peekChar();
                if (c == 34 || c == 39) {
                    this.stream.advance(1);
                    if (this.stream.advanceUntilChar(c)) {
                        this.stream.advance(1);
                    }
                    this.state = ScannerState.WithinParameters;
                    return this.finishToken(offset, TokenType.ParameterValue);
                }
                if (!this.hasNextParameterNameOrValue()) break;
                this.state = ScannerState.WithinParameters;
                return this.finishToken(offset, TokenType.ParameterValue);
            }
        }
        this.stream.advance(1);
        return this.finishToken(offset, TokenType.Unknown, errorMessage);
    }

    private boolean hasNextParameterNameOrValue() {
        if (this.splitWithEquals) {
            return this.stream.advanceWhileChar(PARAM_SPLITTED_BY_SPACE_OR_EQUALS) > 0;
        }
        return this.stream.advanceWhileChar(PARAM_SPLITTED_BY_ONLY_SPACE) > 0;
    }

    private TokenType parseParameterName(int offset) {
        if (this.methodParameters) {
            this.stream.advanceUntilChar(PAREN_COMMA);
            if (this.stream.peekChar() == 40) {
                this.stream.advance(1);
                ++this.bracket;
                return this.parseParameterName(offset);
            }
            if (this.stream.peekChar() == 41) {
                this.stream.advance(1);
                if (this.bracket > 0) {
                    --this.bracket;
                }
                return this.parseParameterName(offset);
            }
            if (this.stream.peekChar() == 44) {
                if (this.bracket > 0) {
                    this.stream.advance(1);
                    return this.parseParameterName(offset);
                }
                if (offset == this.stream.pos()) {
                    this.stream.advance(1);
                    return this.internalScan();
                }
            }
        }
        this.state = ScannerState.WithinParameters;
        return this.finishToken(offset, TokenType.ParameterName);
    }
}

