/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.scanner;

import com.redhat.qute.parser.scanner.MultiLineStream;
import com.redhat.qute.parser.scanner.Scanner;

public abstract class AbstractScanner<T, S>
implements Scanner<T, S> {
    protected final MultiLineStream stream;
    private final T unknownTokenType;
    private final T eosTokenType;
    protected S state;
    private int tokenOffset;
    private T tokenType;
    private String tokenError;

    protected AbstractScanner(String input, int initialOffset, S initialState, T unknownTokenType, T eosTokenType) {
        this(input, initialOffset, input.length(), initialState, unknownTokenType, eosTokenType);
    }

    protected AbstractScanner(String input, int initialOffset, int endOffset, S initialState, T unknownTokenType, T eosTokenType) {
        this.stream = new MultiLineStream(input, initialOffset, endOffset);
        this.unknownTokenType = unknownTokenType;
        this.eosTokenType = eosTokenType;
        this.state = initialState;
        this.tokenOffset = 0;
        this.tokenType = unknownTokenType;
    }

    @Override
    public T scan() {
        int offset = this.stream.pos();
        S oldState = this.state;
        T token = this.internalScan();
        if (token != this.eosTokenType && offset == this.stream.pos()) {
            this.log("Scanner.scan has not advanced at offset " + offset + ", state before: " + oldState + " after: " + this.state);
            this.stream.advance(1);
            return this.finishToken(offset, this.unknownTokenType);
        }
        return token;
    }

    protected abstract T internalScan();

    protected T finishToken(int offset, T type) {
        return this.finishToken(offset, type, null);
    }

    protected T finishToken(int offset, T type, String errorMessage) {
        this.tokenType = type;
        this.tokenOffset = offset;
        this.tokenError = errorMessage;
        return type;
    }

    @Override
    public T getTokenType() {
        return this.tokenType;
    }

    @Override
    public int getTokenOffset() {
        return this.tokenOffset;
    }

    @Override
    public int getTokenLength() {
        return this.stream.pos() - this.tokenOffset;
    }

    @Override
    public int getTokenEnd() {
        return this.stream.pos();
    }

    @Override
    public String getTokenText() {
        return this.stream.getSource().substring(this.tokenOffset, this.stream.pos());
    }

    @Override
    public S getScannerState() {
        return this.state;
    }

    @Override
    public String getTokenError() {
        return this.tokenError;
    }

    private void log(String message) {
    }
}

