/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.scanner;

import com.redhat.qute.parser.scanner.Constants;
import java.util.function.Predicate;

public class MultiLineStream {
    private static final Predicate<Integer> WHITESPACE_PREDICATE = ch -> ch == Constants._WSP || ch == Constants._TAB || ch == Constants._NWL || ch == Constants._LFD || ch == Constants._CAR;
    private final String source;
    private final int len;
    private int position;

    public MultiLineStream(String source, int position, int len) {
        this.source = source;
        this.len = Math.min(len, source.length());
        this.position = position;
    }

    public boolean eos() {
        return this.len <= this.position;
    }

    public String getSource() {
        return this.source;
    }

    public int pos() {
        return this.position;
    }

    public void goBackTo(int pos) {
        this.position = pos;
    }

    public void goBack(int n) {
        this.position -= n;
    }

    public void advance(int n) {
        this.position += n;
    }

    public void goToEnd() {
        this.position = this.len;
    }

    public int peekChar() {
        return this.peekChar(0);
    }

    public int peekChar(int n) {
        int pos = this.position + n;
        if (pos >= this.len) {
            return 0;
        }
        return this.source.codePointAt(pos);
    }

    public int peekCharAtOffset(int offset) {
        if (offset >= this.len || offset < 0) {
            return 0;
        }
        return this.source.codePointAt(offset);
    }

    public boolean advanceIfChar(int ch) {
        if (ch == this.peekChar()) {
            ++this.position;
            return true;
        }
        return false;
    }

    public boolean advanceIfChars(int[] ch) {
        int i;
        if (this.position + ch.length > this.len) {
            return false;
        }
        for (i = 0; i < ch.length; ++i) {
            if (this.peekChar(i) == ch[i]) continue;
            return false;
        }
        this.advance(i);
        return true;
    }

    public boolean advanceIfAnyOfChars(char[] ch) {
        if (this.position + 1 > this.len) {
            return false;
        }
        for (int i = 0; i < ch.length; ++i) {
            if (!this.advanceIfChar(ch[i])) continue;
            return true;
        }
        return false;
    }

    public boolean advanceUntilChar(int[] ch) {
        while (this.position < this.len) {
            for (int c : ch) {
                if (this.peekChar() != c) continue;
                return true;
            }
            this.advance(1);
        }
        return false;
    }

    public boolean advanceUntilChar(int ch) {
        while (this.position < this.len) {
            if (this.peekChar() == ch) {
                return true;
            }
            this.advance(1);
        }
        return false;
    }

    public boolean advanceUntilAnyOfChars(int[] ch) {
        while (this.position < this.len) {
            for (int i = 0; i < ch.length; ++i) {
                if (this.peekChar() != ch[i]) continue;
                return true;
            }
            this.advance(1);
        }
        return false;
    }

    public boolean advanceUntilChars(int[] ch) {
        while (this.position + ch.length <= this.len) {
            int i;
            for (i = 0; i < ch.length && this.peekChar(i) == ch[i]; ++i) {
            }
            if (i == ch.length) {
                return true;
            }
            this.advance(1);
        }
        this.goToEnd();
        return false;
    }

    public boolean skipWhitespace() {
        int n = this.advanceWhileChar(WHITESPACE_PREDICATE);
        return n > 0;
    }

    public int advanceWhileChar(Predicate<Integer> condition) {
        int posNow = this.position;
        while (this.position < this.len && condition.test(this.peekChar())) {
            ++this.position;
        }
        return this.position - posNow;
    }

    public boolean advanceUntilCharOrNewTag(int ch) {
        while (this.position < this.len) {
            if (this.peekChar() == ch || this.peekChar() == 123) {
                return true;
            }
            this.advance(1);
        }
        return false;
    }
}

