/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.template;

import com.redhat.qute.parser.expression.ExpressionParser;
import com.redhat.qute.parser.expression.MethodPart;
import com.redhat.qute.parser.expression.NamespacePart;
import com.redhat.qute.parser.expression.ObjectPart;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.template.ASTVisitor;
import com.redhat.qute.parser.template.LiteralSupport;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import java.util.List;

public class Expression
extends Node {
    private List<Node> expressionContent = null;
    private String literalJavaType;
    private String content;

    Expression(int start, int end) {
        super(start, end);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.Expression;
    }

    @Override
    public String getNodeName() {
        return "#expression";
    }

    public int getStartContentOffset() {
        return this.getStart() + 1;
    }

    public int getEndContentOffset() {
        return this.isClosed() ? this.getEnd() - 1 : this.getEnd();
    }

    public Node findNodeExpressionAt(int offset) {
        Node node = Expression.findNodeAt(this.getExpressionContent(), offset);
        if (node != null) {
            return node;
        }
        return null;
    }

    private synchronized void parseExpressionIfNeeded() {
        if (this.expressionContent != null) {
            return;
        }
        this.expressionContent = ExpressionParser.parse(this, this.canSupportInfixNotation(), this.getOwnerTemplate().getCancelChecker());
    }

    public List<Node> getExpressionContent() {
        this.parseExpressionIfNeeded();
        return this.expressionContent;
    }

    public NamespacePart getNamespacePart() {
        Parts parts = this.getParts();
        return parts != null ? parts.getNamespacePart() : null;
    }

    public ObjectPart getObjectPart() {
        Parts parts = this.getParts();
        return parts != null ? parts.getObjectPart() : null;
    }

    public MethodPart getMethodPart() {
        Parts parts = this.getParts();
        return parts != null ? parts.getMethodPart() : null;
    }

    public Part getLastPart() {
        Parts parts = this.getParts();
        return parts != null ? (Part)parts.getLastChild() : null;
    }

    private Parts getParts() {
        List<Node> nodes = this.getExpressionContent();
        if (nodes.isEmpty()) {
            return null;
        }
        return (Parts)nodes.get(0);
    }

    public String getLiteralJavaType() {
        if (this.literalJavaType == null) {
            this.literalJavaType = LiteralSupport.getLiteralJavaType(this.getContent());
            if (this.literalJavaType == null) {
                this.literalJavaType = "";
            }
        }
        return this.literalJavaType.isEmpty() ? null : this.literalJavaType;
    }

    public String getContent() {
        if (this.content == null) {
            this.content = this.getOwnerTemplate().getText(this.getStartContentOffset(), this.getEndContentOffset());
        }
        return this.content;
    }

    @Override
    protected void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChildren(visitor, this.getExpressionContent());
        }
        visitor.endVisit(this);
    }

    public boolean canSupportInfixNotation() {
        return true;
    }

    public boolean isOptional() {
        Part lastPart = this.getLastPart();
        return lastPart != null ? lastPart.isOptional() : false;
    }

    public Parameter getOwnerParameter() {
        return null;
    }

    public Section getOwnerSection() {
        return null;
    }
}

