/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.template;

import java.util.regex.Pattern;

public class LiteralSupport {
    private static final String BOOLEAN_PRIMITIVE_TYPE = "boolean";
    private static final String BYTE_PRIMITIVE_TYPE = "byte";
    private static final String CHAR_PRIMITIVE_TYPE = "char";
    private static final String DOUBLE_PRIMITIVE_TYPE = "double";
    private static final String FLOAT_PRIMITIVE_TYPE = "float";
    private static final String INT_PRIMITIVE_TYPE = "int";
    private static final String LONG_PRIMITIVE_TYPE = "long";
    private static final String NULL_TYPE = "null";
    private static final String STRING_TYPE = "java.lang.String";
    private static final String BOOLEAN_TYPE = "java.lang.Boolean";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String BYTE_TYPE = "java.lang.Byte";
    private static final String CHARACTER_TYPE = "java.lang.Character";
    private static final String DOUBLE_TYPE = "java.lang.Double";
    private static final String FLOAT_TYPE = "java.lang.Float";
    private static final String INTEGER_TYPE = "java.lang.Integer";
    private static final String LONG_TYPE = "java.lang.Long";
    private static final Pattern INTEGER_LITERAL_PATTERN = Pattern.compile("[-+]?\\d{1,10}");
    private static final Pattern LONG_LITERAL_PATTERN = Pattern.compile("[-+]?\\d{1,19}(L|l)");
    private static final Pattern DOUBLE_LITERAL_PATTERN = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+(d|D)");
    private static final Pattern FLOAT_LITERAL_PATTERN = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+(f|F)");

    public static String getLiteralJavaType(String literal) {
        if (literal == null || literal.isEmpty()) {
            return null;
        }
        if (LiteralSupport.isStringLiteralSeparator(literal.charAt(0))) {
            return STRING_TYPE;
        }
        if (literal.equals(TRUE)) {
            return BOOLEAN_TYPE;
        }
        if (literal.equals(FALSE)) {
            return BOOLEAN_TYPE;
        }
        if (literal.equals(NULL_TYPE)) {
            return NULL_TYPE;
        }
        char firstChar = literal.charAt(0);
        if (Character.isDigit(firstChar) || firstChar == '-' || firstChar == '+') {
            if (INTEGER_LITERAL_PATTERN.matcher(literal).matches()) {
                return INTEGER_TYPE;
            }
            if (LONG_LITERAL_PATTERN.matcher(literal).matches()) {
                return LONG_TYPE;
            }
            if (DOUBLE_LITERAL_PATTERN.matcher(literal).matches()) {
                return DOUBLE_TYPE;
            }
            if (FLOAT_LITERAL_PATTERN.matcher(literal).matches()) {
                return FLOAT_TYPE;
            }
        }
        return null;
    }

    private static boolean isStringLiteralSeparator(char character) {
        return character == '\"' || character == '\'';
    }

    public static String getPrimitiveObjectType(String primitiveType) {
        switch (primitiveType) {
            case "boolean": {
                return BOOLEAN_TYPE;
            }
            case "byte": {
                return BYTE_TYPE;
            }
            case "char": {
                return CHARACTER_TYPE;
            }
            case "double": {
                return DOUBLE_TYPE;
            }
            case "float": {
                return FLOAT_TYPE;
            }
            case "int": {
                return INTEGER_TYPE;
            }
            case "long": {
                return LONG_TYPE;
            }
        }
        return null;
    }

    public static boolean isNull(String javaType) {
        return NULL_TYPE.equals(javaType);
    }
}

