/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.template;

import com.redhat.qute.parser.template.ASTVisitor;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.Template;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public abstract class Node {
    protected static final int NULL_VALUE = -1;
    private int start;
    private int end;
    private boolean closed;
    private Node parent;
    private List<Node> children;

    public Node(int start, int end) {
        this.start = start;
        this.end = end;
        this.closed = false;
    }

    public Template getOwnerTemplate() {
        for (Node node = this.parent; node != null; node = node.getParent()) {
            if (node.getKind() != NodeKind.Template) continue;
            return (Template)node;
        }
        return null;
    }

    public int getStart() {
        return this.start;
    }

    protected void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    protected void setEnd(int end) {
        this.end = end;
    }

    void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void addChild(Node child) {
        child.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList<Node>();
        }
        this.children.add(child);
    }

    protected void setParent(Node parent) {
        this.parent = parent;
    }

    public Node getParent() {
        return this.parent;
    }

    public List<Node> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public Node getChild(int index) {
        return this.getChildren().get(index);
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    public abstract String getNodeName();

    public Node findNodeAt(int offset) {
        List<Node> children = this.getChildren();
        Node node = Node.findNodeAt(children, offset);
        return node != null ? node : this;
    }

    public static Node findNodeAt(List<Node> children, int offset) {
        Node child;
        int idx = Node.findFirst(children, c -> offset <= c.start) - 1;
        if (idx >= 0 && Node.isIncluded(child = children.get(idx), offset)) {
            return child.findNodeAt(offset);
        }
        return null;
    }

    public Node findNodeBefore(int offset) {
        List<Node> children = this.getChildren();
        int idx = Node.findFirst(children, c -> offset <= c.start) - 1;
        if (idx >= 0) {
            Node child = children.get(idx);
            if (offset > child.start) {
                if (offset < child.end) {
                    return child.findNodeBefore(offset);
                }
                Node lastChild = child.getLastChild();
                if (lastChild != null && lastChild.end == child.end) {
                    return child.findNodeBefore(offset);
                }
                return child;
            }
        }
        return this;
    }

    public Node getLastChild() {
        return this.children != null && this.children.size() > 0 ? this.children.get(this.children.size() - 1) : null;
    }

    public Node getNextSibling() {
        Node parentNode = this.getParent();
        if (parentNode == null) {
            return null;
        }
        List<Node> children = parentNode.getChildren();
        int nextIndex = children.indexOf(this) + 1;
        return nextIndex < children.size() ? children.get(nextIndex) : null;
    }

    public Section getNextSiblingSection() {
        Node parentNode = this.getParent();
        if (parentNode == null) {
            return null;
        }
        List<Node> children = parentNode.getChildren();
        int nextIndex = children.indexOf(this) + 1;
        if (nextIndex >= children.size()) {
            return null;
        }
        for (int i = nextIndex; i < children.size(); ++i) {
            Node node = children.get(i);
            if (node.getKind() != NodeKind.Section) continue;
            return (Section)node;
        }
        return null;
    }

    public Section getOrphanEndSection(int offset, String tagName) {
        return this.getOrphanEndSection(offset, tagName, false);
    }

    public Section getOrphanEndSection(int offset, String tagName, boolean anyOrphan) {
        Section nextSection = this.getNextSiblingSection();
        if (nextSection == null) {
            return null;
        }
        if (anyOrphan && nextSection.isOrphanEndTag() || nextSection.isOrphanEndTagOf(tagName)) {
            return nextSection;
        }
        return null;
    }

    public Section getParentSection() {
        return this.getParentSection(false);
    }

    public Section getParentSection(boolean excludeSupportUnterminatedSection) {
        for (Node parent = this.getParent(); parent != null && parent.getKind() != NodeKind.Template; parent = parent.getParent()) {
            if (parent == null || parent.getKind() != NodeKind.Section) continue;
            Section parentSection = (Section)parent;
            if (!excludeSupportUnterminatedSection) {
                return parentSection;
            }
            if (parentSection.hasEndTag()) {
                return parentSection;
            }
            if (parentSection.canSupportUnterminatedSection()) continue;
            return parentSection;
        }
        return null;
    }

    public static boolean isIncluded(Node node, int offset) {
        if (node == null) {
            return false;
        }
        return Node.isIncluded(node.getStart(), node.getEnd(), offset);
    }

    public static boolean isIncluded(int start, int end, int offset) {
        return offset >= start && offset <= end;
    }

    private static <T> int findFirst(List<T> array, Function<T, Boolean> p) {
        int low = 0;
        int high = array.size();
        if (high == 0) {
            return 0;
        }
        while (low < high) {
            int mid = (int)Math.floor((low + high) / 2);
            if (p.apply(array.get(mid)).booleanValue()) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }

    public final void accept(ASTVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException();
        }
        if (visitor.preVisit2(this)) {
            this.accept0(visitor);
        }
        visitor.postVisit(this);
    }

    protected abstract void accept0(ASTVisitor var1);

    protected final void acceptChild(ASTVisitor visitor, Node child) {
        if (child == null) {
            return;
        }
        child.accept(visitor);
    }

    protected final void acceptChildren(ASTVisitor visitor, List<Node> children) {
        for (Node child : children) {
            child.accept(visitor);
        }
    }

    public abstract NodeKind getKind();
}

