/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.template;

import com.redhat.qute.parser.expression.ObjectPart;
import com.redhat.qute.parser.template.ASTVisitor;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.ExpressionParameter;
import com.redhat.qute.parser.template.JavaTypeInfoProvider;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.ParametersContainer;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionKind;
import com.redhat.qute.parser.template.Template;

public class Parameter
extends Node
implements JavaTypeInfoProvider {
    private String name = null;
    private String value = null;
    private int startName;
    private int endName;
    private int startValue = -1;
    private int endValue = -1;
    private ExpressionParameter expression;
    private boolean canHaveExpression;
    private int assignOffset = -1;
    private ParametersContainer container;
    private boolean hasDefaultValue;

    public Parameter(int start, int end) {
        super(start, end);
        this.startName = start;
        this.endName = end;
    }

    public int getStartName() {
        return this.startName;
    }

    public int getEndName() {
        return this.endName;
    }

    public int getStartValue() {
        return this.startValue;
    }

    public void setStartValue(int startValue) {
        this.startValue = startValue;
    }

    public int getEndValue() {
        return this.endValue;
    }

    public void setEndValue(int endValue) {
        this.endValue = endValue;
        super.setEnd(endValue);
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.Parameter;
    }

    public void setParameterParent(ParametersContainer container) {
        if (container instanceof Node) {
            super.setParent((Node)((Object)container));
        } else {
            this.container = container;
        }
    }

    public String toString() {
        return this.getName() + "=" + this.getValue();
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (!this.hasValueAssigned()) {
            ObjectPart objectPart;
            Expression expression = this.getJavaTypeExpression();
            ObjectPart objectPart2 = objectPart = expression != null ? expression.getObjectPart() : null;
            if (objectPart != null) {
                return objectPart.getPartName();
            }
        }
        if (this.name == null) {
            String text;
            int endName = this.getEndName();
            Section section = this.getOwnerSection();
            if (section != null && (section.getSectionKind() == SectionKind.LET || section.getSectionKind() == SectionKind.SET) && (text = this.getOwnerTemplate().getText()).charAt(endName - 1) == '?') {
                this.hasDefaultValue = true;
                --endName;
            }
            this.name = this.getText(this.getStartName(), endName);
        }
        return this.name;
    }

    public String getValue() {
        if (this.value == null) {
            this.value = this.hasValueAssigned() ? this.getText(this.getStartValue(), this.getEndValue()) : this.getName();
        }
        return this.value;
    }

    private String getText(int start, int end) {
        Template template = this.getOwnerTemplate();
        if (template != null) {
            return template.getText(start, end);
        }
        return this.container.getTemplateContent().substring(start, end);
    }

    public boolean hasValueAssigned() {
        return this.startValue != -1;
    }

    @Override
    public Expression getJavaTypeExpression() {
        if (!this.canHaveExpression()) {
            return null;
        }
        if (this.expression != null) {
            return this.expression;
        }
        int startExpression = this.getStartName();
        int endExpression = this.getEndName();
        if (this.hasValueAssigned()) {
            startExpression = this.getStartValue();
            endExpression = this.getEndValue();
        }
        this.expression = new ExpressionParameter(startExpression, endExpression, this.getOwnerSection());
        this.expression.setParent(this);
        this.expression.setClosed(true);
        return this.expression;
    }

    public Section getOwnerSection() {
        Node parent = super.getParent();
        if (parent != null && parent.getKind() == NodeKind.Section) {
            return (Section)parent;
        }
        return null;
    }

    @Override
    public Node getJavaTypeOwnerNode() {
        return this;
    }

    public void setCanHaveExpression(boolean canHaveExpression) {
        this.canHaveExpression = canHaveExpression;
    }

    public boolean canHaveExpression() {
        return this.canHaveExpression;
    }

    public boolean isInName(int offset) {
        return Node.isIncluded(this.getStartName(), this.getEndName(), offset);
    }

    public boolean isInValue(int offset) {
        if (this.isAfterAssign(offset)) {
            return true;
        }
        if (!this.hasValueAssigned()) {
            return false;
        }
        return Node.isIncluded(this.getStartValue(), this.getEndValue(), offset);
    }

    public boolean isAfterAssign(int offset) {
        return offset == this.assignOffset + 1;
    }

    @Override
    protected void accept0(ASTVisitor visitor) {
        Expression expression;
        boolean visitChildren = visitor.visit(this);
        if (visitChildren && (expression = this.getJavaTypeExpression()) != null) {
            this.acceptChild(visitor, expression);
        }
        visitor.endVisit(this);
    }

    public void setAssignOffset(int assignOffset) {
        this.assignOffset = assignOffset;
        super.setEnd(assignOffset);
    }

    public boolean isOptional() {
        Expression expression = this.getJavaTypeExpression();
        return expression != null ? expression.isOptional() : false;
    }

    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }
}

