/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.template;

import com.redhat.qute.parser.CancelChecker;
import com.redhat.qute.parser.template.ASTVisitor;
import com.redhat.qute.parser.template.JavaTypeInfoProvider;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.ParametersContainer;
import com.redhat.qute.parser.template.RangeOffset;
import com.redhat.qute.parser.template.Template;
import java.util.ArrayList;
import java.util.List;

public class ParameterDeclaration
extends Node
implements ParametersContainer,
JavaTypeInfoProvider {
    ParameterDeclaration(int start, int end) {
        super(start, end);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ParameterDeclaration;
    }

    public int getStartContent() {
        return super.getStart() + 2;
    }

    public int getEndContent() {
        int index = super.getEnd() - 1;
        if (this.isClosed()) {
            return index;
        }
        String text = super.getOwnerTemplate().getText();
        char c = text.charAt(index);
        while (c == '\r' || c == '\n') {
            c = text.charAt(--index);
        }
        return index + 1;
    }

    @Override
    public String getNodeName() {
        return "#parameter-declaration";
    }

    @Override
    public String getJavaType() {
        Template template = this.getOwnerTemplate();
        int classNameStart = this.getClassNameStart();
        int classNameEnd = this.getClassNameEnd();
        return template.getText(classNameStart, classNameEnd);
    }

    public int getClassNameStart() {
        return this.getStartContent();
    }

    public int getClassNameEnd() {
        Template template = this.getOwnerTemplate();
        String text = template.getText();
        for (int i = this.getStartContent(); i < this.getEndContent(); ++i) {
            char c = text.charAt(i);
            if (c != ' ') continue;
            return i;
        }
        return this.getEndContent();
    }

    public boolean isInJavaTypeName(int offset) {
        int classNameStart = this.getClassNameStart();
        int classNameEnd = this.getClassNameEnd();
        return offset >= classNameStart && offset <= classNameEnd;
    }

    public String getAlias() {
        int aliasStart = this.getAliasStart();
        if (aliasStart == -1) {
            return null;
        }
        int aliasEnd = this.getAliasEnd();
        Template template = this.getOwnerTemplate();
        return template.getText(aliasStart, aliasEnd);
    }

    public int getAliasStart() {
        Template template = this.getOwnerTemplate();
        String text = template.getText();
        for (int i = this.getStartContent(); i < this.getEndContent(); ++i) {
            char c = text.charAt(i);
            if (c != ' ' || i + 1 >= this.getEndContent()) continue;
            return i + 1;
        }
        return -1;
    }

    public int getAliasEnd() {
        return this.getEndContent();
    }

    public boolean isInAlias(int offset) {
        int aliasStart = this.getAliasStart();
        if (aliasStart == -1) {
            return false;
        }
        int aliasEnd = this.getAliasEnd();
        return offset >= aliasStart && offset <= aliasEnd;
    }

    public boolean hasAlias() {
        return this.getAliasStart() != -1;
    }

    @Override
    public Node getJavaTypeOwnerNode() {
        return this;
    }

    @Override
    public int getStartParametersOffset() {
        return this.getStartContent();
    }

    @Override
    public int getEndParametersOffset() {
        return this.getEndContent();
    }

    public List<JavaTypeRangeOffset> getJavaTypeNameRanges() {
        int startType;
        char c;
        int endType;
        ArrayList<JavaTypeRangeOffset> ranges = new ArrayList<JavaTypeRangeOffset>();
        Template template = this.getOwnerTemplate();
        String text = template.getText();
        int end = this.getEndContent();
        boolean diamon = false;
        for (endType = startType = this.getStartContent(); endType < end && !ParameterDeclaration.isSpace(c = text.charAt(endType)) && c != '['; ++endType) {
            if (c != '<') continue;
            diamon = true;
            break;
        }
        ranges.add(new JavaTypeRangeOffset(startType, endType));
        if (diamon) {
            boolean genericClosed = false;
            startType = ++endType;
            while (endType < end) {
                char c2 = text.charAt(endType);
                if (ParameterDeclaration.isSpace(c2) || c2 == '>') {
                    genericClosed = c2 == '>';
                    break;
                }
                if (c2 == ',') {
                    ranges.add(new JavaTypeRangeOffset(startType, endType, true, true));
                    startType = endType + 1;
                }
                ++endType;
            }
            ranges.add(new JavaTypeRangeOffset(startType, endType, true, genericClosed));
        }
        return ranges;
    }

    private static boolean isSpace(char c) {
        return c == '\r' || c == '\n' || c == ' ';
    }

    public JavaTypeRangeOffset getJavaTypeNameRange(int offset) {
        List<JavaTypeRangeOffset> ranges = this.getJavaTypeNameRanges();
        for (JavaTypeRangeOffset range : ranges) {
            if (!Node.isIncluded(range.getStart(), range.getEnd(), offset)) continue;
            return range;
        }
        return null;
    }

    @Override
    protected void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public String getTemplateContent() {
        return this.getOwnerTemplate().getText();
    }

    @Override
    public CancelChecker getCancelChecker() {
        return this.getOwnerTemplate().getCancelChecker();
    }

    public static class JavaTypeRangeOffset
    extends RangeOffset {
        private final boolean inGeneric;
        private final boolean genericClosed;

        public JavaTypeRangeOffset(int start, int end) {
            this(start, end, false, false);
        }

        public JavaTypeRangeOffset(int start, int end, boolean inGeneric, boolean genericClosed) {
            super(start, end);
            this.inGeneric = inGeneric;
            this.genericClosed = genericClosed;
        }

        public boolean isInGeneric() {
            return this.inGeneric;
        }

        public boolean isGenericClosed() {
            return this.genericClosed;
        }
    }
}

