/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.template;

import com.redhat.qute.parser.template.ParameterInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ParametersInfo
implements Iterable<List<ParameterInfo>> {
    public static final String MAIN_BLOCK_NAME = "$main";
    public static final ParametersInfo EMPTY = ParametersInfo.builder().build();
    private final Map<String, List<ParameterInfo>> parameters;

    public static Builder builder() {
        return new Builder();
    }

    private ParametersInfo(Map<String, List<ParameterInfo>> parameters) {
        this.parameters = new HashMap<String, List<ParameterInfo>>(parameters);
    }

    public List<ParameterInfo> get(String sectionPart) {
        return this.parameters.getOrDefault(sectionPart, Collections.emptyList());
    }

    @Override
    public Iterator<List<ParameterInfo>> iterator() {
        return this.parameters.values().iterator();
    }

    public int size() {
        return this.parameters.size();
    }

    public static class Builder {
        private final Map<String, List<ParameterInfo>> parameters = new HashMap<String, List<ParameterInfo>>();

        Builder() {
        }

        public Builder addParameter(String name) {
            return this.addParameter(ParametersInfo.MAIN_BLOCK_NAME, name, null);
        }

        public Builder addParameter(String name, String defaultValue) {
            return this.addParameter(ParametersInfo.MAIN_BLOCK_NAME, name, defaultValue);
        }

        public Builder addParameter(ParameterInfo param) {
            return this.addParameter(ParametersInfo.MAIN_BLOCK_NAME, param);
        }

        public Builder addParameter(String blockLabel, String name, String defaultValue) {
            return this.addParameter(blockLabel, new ParameterInfo(name, defaultValue, false));
        }

        public Builder addParameter(String blockLabel, ParameterInfo parameter) {
            this.parameters.computeIfAbsent(blockLabel, c -> new ArrayList()).add(parameter);
            return this;
        }

        public ParametersInfo build() {
            return new ParametersInfo(this.parameters);
        }
    }
}

