/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.template;

import com.redhat.qute.parser.CancelChecker;
import com.redhat.qute.parser.parameter.ParameterParser;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.ExpressionParameter;
import com.redhat.qute.parser.template.JavaTypeInfoProvider;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Operator;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.ParameterInfo;
import com.redhat.qute.parser.template.ParametersContainer;
import com.redhat.qute.parser.template.ParametersInfo;
import com.redhat.qute.parser.template.SectionKind;
import com.redhat.qute.parser.template.SectionMetadata;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class Section
extends Node
implements ParametersContainer {
    private static final SectionKind[] INCLUDE_SECTION_KIND = new SectionKind[]{SectionKind.INCLUDE};
    private static final SectionKind[] INSERT_SECTION_KIND = new SectionKind[]{SectionKind.INSERT};
    private static final SectionKind[] WHEN_SECTION_KIND = new SectionKind[]{SectionKind.WHEN, SectionKind.SWITCH};
    private static final SectionKind[] CASE_SECTION_KIND = new SectionKind[]{SectionKind.CASE, SectionKind.IS};
    private final String tag;
    private int startTagOpenOffset;
    private int startTagCloseOffset;
    private int endTagOpenOffset;
    private int endTagCloseOffset;
    private boolean selfClosed;
    private List<Parameter> parameters;

    public Section(String tag, int start, int end) {
        super(start, end);
        this.tag = tag;
        this.startTagOpenOffset = -1;
        this.startTagCloseOffset = -1;
        this.endTagOpenOffset = -1;
        this.endTagCloseOffset = -1;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.Section;
    }

    public int getStartTagOpenOffset() {
        return this.startTagOpenOffset;
    }

    public int getStartTagNameOpenOffset() {
        return this.getStartTagOpenOffset() + 1;
    }

    void setStartTagOpenOffset(int startTagOpenOffset) {
        this.startTagOpenOffset = startTagOpenOffset;
    }

    public int getStartTagNameCloseOffset() {
        if (!this.hasTag()) {
            return this.getStartTagNameOpenOffset() + 1;
        }
        return this.getStartTagNameOpenOffset() + 1 + this.tag.length();
    }

    public int getStartTagCloseOffset() {
        return this.startTagCloseOffset;
    }

    void setStartTagCloseOffset(int startTagCloseOffset) {
        this.startTagCloseOffset = startTagCloseOffset;
    }

    public boolean isStartTagClosed() {
        return this.startTagCloseOffset != -1;
    }

    public boolean isInStartTagName(int offset) {
        if (!this.hasStartTag()) {
            return false;
        }
        if (!this.isStartTagClosed()) {
            return true;
        }
        return offset > this.getStartTagOpenOffset() && offset <= this.getStartTagNameCloseOffset();
    }

    public boolean hasStartTag() {
        return this.getStartTagOpenOffset() != -1;
    }

    public int getEndTagOpenOffset() {
        return this.endTagOpenOffset;
    }

    public int getEndTagNameOpenOffset() {
        return this.getEndTagOpenOffset() + 1;
    }

    void setEndTagOpenOffset(int endTagOpenOffset) {
        this.endTagOpenOffset = endTagOpenOffset;
    }

    public int getEndTagCloseOffset() {
        return this.endTagCloseOffset;
    }

    void setEndTagCloseOffset(int endTagCloseOffset) {
        this.endTagCloseOffset = endTagCloseOffset;
    }

    public boolean isEndTagClosed() {
        return this.endTagCloseOffset != -1;
    }

    public boolean isInEndTagName(int offset) {
        return this.isInEndTagName(offset, false);
    }

    private boolean isInEndTagName(int offset, boolean afterBackSlash) {
        if (!this.hasEndTag()) {
            return false;
        }
        return offset > this.getEndTagOpenOffset() + (afterBackSlash ? 1 : 0) && offset < this.getEnd();
    }

    public boolean hasEndTag() {
        return this.getEndTagOpenOffset() != -1;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.parseParameters();
        }
        return this.parameters;
    }

    public Parameter getParameterAtIndex(int index) {
        List<Parameter> parameters = this.getParameters();
        if (parameters.size() > index) {
            return parameters.get(index);
        }
        return null;
    }

    public Parameter getParameterAtOffset(int offset) {
        if (!this.isInParameters(offset)) {
            return null;
        }
        List<Parameter> parameters = this.getParameters();
        for (Parameter parameter : parameters) {
            if (!parameter.isInName(offset) && !parameter.isInValue(offset)) continue;
            return parameter;
        }
        return (Parameter)Node.findNodeAt(parameters.stream().map(param -> param).collect(Collectors.toList()), offset);
    }

    public Parameter findParameter(String parameterName) {
        for (Parameter parameter : this.getParameters()) {
            if (!parameterName.equals(parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    public boolean hasParameter(String parameterName) {
        return this.findParameter(parameterName) != null;
    }

    private synchronized List<Parameter> parseParameters() {
        int end;
        if (this.parameters != null) {
            return this.parameters;
        }
        if (!this.hasStartTag()) {
            return Collections.emptyList();
        }
        int start = this.getStartParametersOffset();
        if (start >= (end = this.getEndParametersOffset())) {
            return Collections.emptyList();
        }
        List<Parameter> parameters = this.collectParameters();
        this.initializeParameters(parameters);
        return parameters;
    }

    protected List<Parameter> collectParameters() {
        return ParameterParser.parse(this, false, true);
    }

    protected void initializeParameters(List<Parameter> parameters) {
        List<ParameterInfo> infos = this.getParametersInfo().get("$main");
        if (parameters.size() == infos.size()) {
            for (int j = 0; j < infos.size(); ++j) {
                ParameterInfo info = infos.get(j);
                if (info.hasDefaultValue()) continue;
                parameters.get(j).setCanHaveExpression(true);
            }
        } else {
            int i = 0;
            for (int j = 0; j < infos.size(); ++j) {
                ParameterInfo info = infos.get(j);
                if (info.getDefaultValue() != null) continue;
                if (parameters.size() > i) {
                    parameters.get(i).setCanHaveExpression(true);
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public int getStartParametersOffset() {
        return this.getStartTagNameCloseOffset() + 1;
    }

    @Override
    public int getEndParametersOffset() {
        if (!this.isStartTagClosed()) {
            if (this.getChildCount() > 0) {
                return this.getChild(0).getStart() - 1;
            }
            return this.getEnd();
        }
        return this.getStartTagCloseOffset();
    }

    public boolean isInParameters(int offset) {
        return offset >= this.getStartParametersOffset() && offset <= this.getEndParametersOffset();
    }

    @Deprecated
    public Expression getExpressionParameter() {
        return new ExpressionParameter(this.getStartParametersOffset(), this.getEndParametersOffset(), this);
    }

    public String getExpressionContent() {
        String text = this.getTemplateContent();
        return text.substring(this.getStartParametersOffset(), this.getEndParametersOffset());
    }

    public ParametersInfo getParametersInfo() {
        return ParametersInfo.EMPTY;
    }

    public boolean isOrphanEndTag() {
        return this.hasEndTag() && !this.hasStartTag();
    }

    public boolean isOrphanEndTagOf(String tagName) {
        return this.isSameTag(tagName) && this.isOrphanEndTag();
    }

    public boolean isSameTag(String tag) {
        return Objects.equals(this.tag, tag);
    }

    @Override
    public Section getOrphanEndSection(int offset, String tagName, boolean anyOrphan) {
        if (this.getEnd() <= offset) {
            return super.getOrphanEndSection(offset, tagName, anyOrphan);
        }
        if (this.isSameTag(tagName) && this.isInStartTagName(offset)) {
            if (anyOrphan) {
                if (this.hasEndTag()) {
                    return this;
                }
            } else {
                return this.hasEndTag() ? this : null;
            }
        }
        Section orphanEndSection = null;
        List<Node> children = this.getChildren();
        for (Node child : children) {
            if (child.getKind() != NodeKind.Section) continue;
            Section childSection = (Section)child;
            if (childSection.isOrphanEndTagOf(tagName)) {
                return childSection;
            }
            if (orphanEndSection != null || !childSection.isOrphanEndTag() || childSection.canSupportUnterminatedSection()) continue;
            orphanEndSection = childSection;
        }
        return anyOrphan ? orphanEndSection : null;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public boolean isSelfClosed() {
        return this.selfClosed;
    }

    void setSelfClosed(boolean selfClosed) {
        this.selfClosed = selfClosed;
    }

    @Override
    public String getNodeName() {
        return "#" + this.getTag();
    }

    public abstract SectionKind getSectionKind();

    public List<SectionMetadata> getMetadata() {
        return Collections.emptyList();
    }

    public JavaTypeInfoProvider getMetadata(String name) {
        Optional<SectionMetadata> metadata = this.getMetadata().stream().filter(m -> name.equals(m.getName())).findFirst();
        return metadata.isPresent() ? (JavaTypeInfoProvider)metadata.get() : null;
    }

    public boolean isMetadata(String name) {
        return this.getMetadata(name) != null;
    }

    public boolean isIterable() {
        return false;
    }

    public List<SectionKind> getBlockLabels() {
        return Collections.emptyList();
    }

    public boolean isSectionBlock() {
        Section parentSection = this.getParentSection(true);
        return parentSection != null && parentSection.getBlockLabels().contains((Object)this.getSectionKind());
    }

    @Override
    public String getTemplateContent() {
        return this.getOwnerTemplate().getText();
    }

    @Override
    public CancelChecker getCancelChecker() {
        return this.getOwnerTemplate().getCancelChecker();
    }

    public boolean isValidOperator(String partName) {
        return false;
    }

    public <T extends Operator> Collection<T> getAllowedOperators() {
        return Collections.emptySet();
    }

    public static boolean isCaseSection(Section section) {
        return Section.isSectionKind(section, CASE_SECTION_KIND);
    }

    public static boolean isWhenSection(Section section) {
        return Section.isSectionKind(section, WHEN_SECTION_KIND);
    }

    public static boolean isIncludeSection(Section section) {
        return Section.isSectionKind(section, INCLUDE_SECTION_KIND);
    }

    public static boolean isInsertSection(Section section) {
        return Section.isSectionKind(section, INSERT_SECTION_KIND);
    }

    private static boolean isSectionKind(Section section, SectionKind[] expectedKinds) {
        if (section == null) {
            return false;
        }
        SectionKind actualKind = section.getSectionKind();
        for (SectionKind expectedKind : expectedKinds) {
            if (actualKind != expectedKind) continue;
            return true;
        }
        return false;
    }

    public boolean hasEmptyEndTag() {
        if (!this.hasEndTag()) {
            return false;
        }
        return this.getEndTagCloseOffset() - this.getEndTagOpenOffset() == 2;
    }

    public boolean canSupportUnterminatedSection() {
        return false;
    }
}

