/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.template;

import com.redhat.qute.commons.ProjectInfo;
import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.ls.commons.LineIndentInfo;
import com.redhat.qute.ls.commons.TextDocument;
import com.redhat.qute.parser.CancelChecker;
import com.redhat.qute.parser.expression.ObjectPart;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.template.ASTVisitor;
import com.redhat.qute.parser.template.JavaTypeInfoProvider;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.ParameterDeclaration;
import com.redhat.qute.parser.template.RangeOffset;
import com.redhat.qute.parser.template.TemplateConfiguration;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.project.QuteTextDocument;
import com.redhat.qute.project.datamodel.ExtendedDataModelParameter;
import com.redhat.qute.project.datamodel.ExtendedDataModelTemplate;
import com.redhat.qute.utils.FileUtils;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.Position;

public class Template
extends Node {
    private String projectUri;
    private final TextDocument textDocument;
    private CancelChecker cancelChecker;
    private QuteProjectRegistry projectRegistry;
    private String templateId;
    private QuteTextDocument templateInfoProvider;

    public Template(TextDocument textDocument) {
        super(0, textDocument.getText().length());
        this.textDocument = textDocument;
        super.setClosed(true);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.Template;
    }

    @Override
    public String getNodeName() {
        return "#template";
    }

    @Override
    public Template getOwnerTemplate() {
        return this;
    }

    public void setCancelChecker(CancelChecker cancelChecker) {
        this.cancelChecker = cancelChecker;
    }

    public CancelChecker getCancelChecker() {
        return this.cancelChecker;
    }

    public Position positionAt(int offset) throws BadLocationException {
        this.checkCanceled();
        return this.textDocument.positionAt(offset);
    }

    public int offsetAt(Position position) throws BadLocationException {
        this.checkCanceled();
        return this.textDocument.offsetAt(position);
    }

    public String lineText(int lineNumber) throws BadLocationException {
        this.checkCanceled();
        return this.textDocument.lineText(lineNumber);
    }

    public String getTemplateId() {
        if (this.templateId == null) {
            QuteProject project = this.getProject();
            if (project == null) {
                return null;
            }
            Path path = FileUtils.createPath(this.getUri());
            this.templateId = project.getTemplateId(path);
        }
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String lineDelimiter(int lineNumber) throws BadLocationException {
        this.checkCanceled();
        return this.textDocument.lineDelimiter(lineNumber);
    }

    public LineIndentInfo lineIndentInfo(int lineNumber) throws BadLocationException {
        this.checkCanceled();
        return this.textDocument.lineIndentInfo(lineNumber);
    }

    public void checkCanceled() {
        if (this.cancelChecker != null) {
            this.cancelChecker.checkCanceled();
        }
    }

    public String getUri() {
        return this.textDocument.getUri();
    }

    public String getText() {
        return this.textDocument.getText();
    }

    public TextDocument getTextDocument() {
        return this.textDocument;
    }

    public String getText(RangeOffset range) {
        return this.getText(range.getStart(), range.getEnd());
    }

    public String getText(int start, int end) {
        String text = this.getText();
        return text.substring(start, end);
    }

    public void setProjectUri(String projectUri) {
        this.projectUri = projectUri;
    }

    public String getProjectUri() {
        return this.projectUri;
    }

    public Path getTemplateBaseDir() {
        QuteProject project = this.getProject();
        if (project == null) {
            return null;
        }
        return project.getTemplateBaseDir();
    }

    public QuteProject getProject() {
        return this.projectRegistry != null ? this.projectRegistry.getProject(this.projectUri) : null;
    }

    public void setProjectRegistry(QuteProjectRegistry projectRegistry) {
        this.projectRegistry = projectRegistry;
    }

    public JavaTypeInfoProvider findInInitialDataModel(Part part) {
        if (part.getPartKind() == Parts.PartKind.Object) {
            String partName = part.getPartName();
            ParameterDeclaration parameter = this.findInParameterDeclarationByAlias(partName);
            if (parameter != null) {
                return parameter;
            }
            return this.getParameterDataModel(partName).getNow(null);
        }
        return null;
    }

    public ParameterDeclaration findInParameterDeclarationByAlias(String alias) {
        Optional<ParameterDeclaration> result = super.getChildren().stream().filter(n -> n.getKind() == NodeKind.ParameterDeclaration).filter(parameter -> alias.equals(((ParameterDeclaration)parameter).getAlias())).map(n -> (ParameterDeclaration)n).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        return null;
    }

    public CompletableFuture<ExtendedDataModelParameter> getParameterDataModel(String parameterName) {
        return this.getDataModelTemplate().thenApply(dataModel -> dataModel != null ? (ExtendedDataModelParameter)dataModel.getParameter(parameterName) : null);
    }

    public CompletableFuture<ExtendedDataModelTemplate> getDataModelTemplate() {
        if (this.projectRegistry == null || this.getProjectUri() == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.projectRegistry.getDataModelTemplate(this);
    }

    public TemplateConfiguration getConfiguration() {
        TemplateConfiguration configuration = null;
        QuteProject project = this.getProject();
        if (project != null) {
            configuration = project.getTemplateConfiguration();
        }
        return configuration != null ? configuration : TemplateConfiguration.DEFAULT;
    }

    public JavaTypeInfoProvider findWithNamespace(ObjectPart objectPart) {
        String namespace = objectPart.getNamespace();
        if (namespace == null) {
            return null;
        }
        if ("data".equals(namespace)) {
            return this.findInInitialDataModel(objectPart);
        }
        QuteProject project = this.getProject();
        if (project == null) {
            return null;
        }
        return project.findJavaElementWithNamespace(namespace, objectPart.getPartName()).getNow(null);
    }

    public Set<String> getJavaTypesSupportedInNativeMode() {
        HashSet<String> javaTypesSupportedInNativeMode = new HashSet<String>();
        for (Node node : super.getChildren()) {
            if (node.getKind() != NodeKind.ParameterDeclaration) continue;
            ParameterDeclaration parameter = (ParameterDeclaration)node;
            List<ParameterDeclaration.JavaTypeRangeOffset> classNameRanges = parameter.getJavaTypeNameRanges();
            for (RangeOffset rangeOffset : classNameRanges) {
                String className = this.getText(rangeOffset);
                javaTypesSupportedInNativeMode.add(className);
            }
        }
        return javaTypesSupportedInNativeMode;
    }

    public JavaTypeInfoProvider findGlobalVariables(ObjectPart objectPart) {
        String namespace = objectPart.getNamespace();
        if (namespace != null) {
            return null;
        }
        QuteProject project = this.getProject();
        if (project == null) {
            return null;
        }
        return project.findGlobalVariableJavaElement(objectPart.getPartName()).getNow(null);
    }

    @Override
    protected void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChildren(visitor, this.getChildren());
        }
        visitor.endVisit(this);
    }

    public void setTemplateInfoProvider(QuteTextDocument templateInfoProvider) {
        this.templateInfoProvider = templateInfoProvider;
    }

    public CompletableFuture<ProjectInfo> getProjectFuture() {
        if (this.templateInfoProvider == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.templateInfoProvider.getProjectInfoFuture();
    }
}

