/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.template.scanner;

import com.redhat.qute.parser.scanner.AbstractScanner;
import com.redhat.qute.parser.scanner.Scanner;
import com.redhat.qute.parser.template.scanner.ScannerState;
import com.redhat.qute.parser.template.scanner.TokenType;
import java.util.function.Predicate;

public class TemplateScanner
extends AbstractScanner<TokenType, ScannerState> {
    public static final int[] QUOTE = new int[]{34, 39};
    public static final char[] QUOTE_C = new char[]{'\"', '\''};
    private static final int[] EXCLAMATION_RBRACKET = new int[]{33, 125};
    private static final int[] RBRACKETS = new int[]{93, 125};
    private static final int[] PIPE_RBRACKET = new int[]{124, 125};
    private static final int[] CURLY_BRACKETS = new int[]{125, 123};
    private static final int[] CURLY_SLASH_QUOTE_SPACE = new int[]{125, 123, 47, 34, 39, 32};
    private static final int[] RCURLY_QUOTE = new int[]{125, 34, 39};
    private static final Predicate<Integer> TAG_NAME_PREDICATE = ch -> Character.isLetter(ch);

    public static Scanner<TokenType, ScannerState> createScanner(String input) {
        return TemplateScanner.createScanner(input, 0);
    }

    public static Scanner<TokenType, ScannerState> createScanner(String input, int initialOffset) {
        return TemplateScanner.createScanner(input, initialOffset, ScannerState.WithinContent);
    }

    public static Scanner<TokenType, ScannerState> createScanner(String input, int initialOffset, ScannerState initialState) {
        return new TemplateScanner(input, initialOffset, initialState);
    }

    TemplateScanner(String input, int initialOffset, ScannerState initialState) {
        super(input, initialOffset, initialState, TokenType.Unknown, TokenType.EOS);
    }

    @Override
    protected TokenType internalScan() {
        int offset = this.stream.pos();
        if (this.stream.eos()) {
            return this.finishToken(offset, TokenType.EOS);
        }
        String errorMessage = null;
        switch ((ScannerState)((Object)this.state)) {
            case WithinContent: {
                if (this.stream.advanceIfChar(123)) {
                    if (this.stream.advanceIfChar(33)) {
                        this.state = ScannerState.WithinComment;
                        return this.finishToken(offset, TokenType.StartComment);
                    }
                    if (this.stream.advanceIfChar(124)) {
                        this.state = ScannerState.WithinCDATA;
                        return this.finishToken(offset, TokenType.CDATATagOpen);
                    }
                    if (this.stream.advanceIfChar(91)) {
                        this.state = ScannerState.WithinCDATAOld;
                        return this.finishToken(offset, TokenType.CDATAOldTagOpen);
                    }
                    if (this.stream.advanceIfChar(35)) {
                        this.state = ScannerState.AfterOpeningStartTag;
                        return this.finishToken(offset, TokenType.StartTagOpen);
                    }
                    if (this.stream.advanceIfChar(47)) {
                        if (this.stream.advanceIfChar(125)) {
                            this.state = ScannerState.WithinContent;
                            return this.finishToken(offset, TokenType.EndTagSelfClose);
                        }
                        this.state = ScannerState.AfterOpeningEndTag;
                        return this.finishToken(offset, TokenType.EndTagOpen);
                    }
                    if (this.stream.advanceIfChar(64)) {
                        this.state = ScannerState.WithinParameterDeclaration;
                        return this.finishToken(offset, TokenType.StartParameterDeclaration);
                    }
                    int ch = this.stream.peekChar();
                    if (TemplateScanner.isValidIdentifierStart(ch)) {
                        this.state = ScannerState.WithinExpression;
                        return this.finishToken(offset, TokenType.StartExpression);
                    }
                    if (!this.stream.eos()) {
                        this.stream.advance(1);
                    }
                }
                this.stream.advanceUntilChar(123);
                return this.finishToken(offset, TokenType.Content);
            }
            case WithinComment: {
                if (this.stream.advanceIfChars(EXCLAMATION_RBRACKET)) {
                    this.state = ScannerState.WithinContent;
                    return this.finishToken(offset, TokenType.EndComment);
                }
                this.stream.advanceUntilChars(EXCLAMATION_RBRACKET);
                return this.finishToken(offset, TokenType.Comment);
            }
            case WithinCDATA: {
                if (this.stream.advanceIfChars(PIPE_RBRACKET)) {
                    this.state = ScannerState.WithinContent;
                    return this.finishToken(offset, TokenType.CDATATagClose);
                }
                this.stream.advanceUntilChars(PIPE_RBRACKET);
                return this.finishToken(offset, TokenType.CDATAContent);
            }
            case WithinCDATAOld: {
                if (this.stream.advanceIfChars(RBRACKETS)) {
                    this.state = ScannerState.WithinContent;
                    return this.finishToken(offset, TokenType.CDATAOldTagClose);
                }
                this.stream.advanceUntilChars(RBRACKETS);
                return this.finishToken(offset, TokenType.CDATAContent);
            }
            case WithinParameterDeclaration: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                this.stream.advanceUntilChar(CURLY_BRACKETS);
                if (this.stream.advanceIfChar(125)) {
                    this.state = ScannerState.WithinContent;
                    return this.finishToken(offset, TokenType.EndParameterDeclaration);
                }
                if (this.stream.peekChar() == 123) {
                    this.state = ScannerState.WithinContent;
                    return this.internalScan();
                }
                return this.finishToken(offset, TokenType.ParameterDeclaration);
            }
            case WithinExpression: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChar(125)) {
                    this.state = ScannerState.WithinContent;
                    return this.finishToken(offset, TokenType.EndExpression);
                }
                this.stream.advanceUntilChar(RCURLY_QUOTE);
                if (this.stream.peekChar() == 34 || this.stream.peekChar() == 39) {
                    this.stream.advance(1);
                    this.state = ScannerState.WithinString;
                    return this.finishToken(this.stream.pos() - 1, TokenType.StartString);
                }
                return this.internalScan();
            }
            case WithinString: {
                if (this.stream.advanceIfAnyOfChars(QUOTE_C)) {
                    this.state = ScannerState.WithinExpression;
                    return this.finishToken(offset, TokenType.EndString);
                }
                this.stream.advanceUntilChar(QUOTE);
                return this.finishToken(offset, TokenType.String);
            }
            case AfterOpeningStartTag: {
                if (this.hasNextTagName()) {
                    this.state = ScannerState.WithinTag;
                    return this.finishToken(offset, TokenType.StartTag);
                }
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace, "Tag name must directly follow the open bracket.");
                }
                this.state = ScannerState.WithinTag;
                if (this.stream.advanceUntilCharOrNewTag(125)) {
                    if (this.stream.peekChar() == 123) {
                        this.state = ScannerState.WithinContent;
                    }
                    return this.internalScan();
                }
                return this.finishToken(offset, TokenType.Unknown);
            }
            case AfterOpeningEndTag: {
                if (this.hasNextTagName()) {
                    this.state = ScannerState.WithinEndTag;
                    return this.finishToken(offset, TokenType.EndTag);
                }
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace, "Tag name must directly follow the open bracket.");
                }
                this.state = ScannerState.WithinEndTag;
                if (this.stream.advanceUntilCharOrNewTag(125)) {
                    if (this.stream.peekChar() == 123) {
                        this.state = ScannerState.WithinContent;
                    }
                    return this.internalScan();
                }
                return this.finishToken(offset, TokenType.Unknown);
            }
            case WithinEndTag: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChar(125)) {
                    this.state = ScannerState.WithinContent;
                    return this.finishToken(offset, TokenType.EndTagClose);
                }
                if (this.stream.advanceUntilChar(123)) {
                    this.state = ScannerState.WithinContent;
                    return this.internalScan();
                }
                return this.finishToken(offset, TokenType.Whitespace);
            }
            case WithinTag: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChar(47)) {
                    this.state = ScannerState.WithinTag;
                    if (this.stream.advanceIfChar(125)) {
                        this.state = ScannerState.WithinContent;
                        return this.finishToken(offset, TokenType.StartTagSelfClose);
                    }
                    return this.finishToken(offset, TokenType.Unknown);
                }
                if (this.stream.advanceIfChar(125)) {
                    this.state = ScannerState.WithinContent;
                    return this.finishToken(offset, TokenType.StartTagClose);
                }
                this.stream.advanceUntilChar(CURLY_SLASH_QUOTE_SPACE);
                int c = this.stream.peekChar();
                if (c == 34 || c == 39) {
                    this.stream.advance(1);
                    this.stream.advanceUntilChar(c);
                    if (this.stream.peekChar() == c) {
                        this.stream.advance(1);
                    }
                } else if (c == 123) {
                    this.state = ScannerState.WithinContent;
                    return this.internalScan();
                }
                return this.finishToken(offset, TokenType.ParameterTag);
            }
        }
        this.stream.advance(1);
        return this.finishToken(offset, TokenType.Unknown, errorMessage);
    }

    private static boolean isValidIdentifierStart(int ch) {
        return Character.isDigit(ch) || Character.isAlphabetic(ch) || ch == 95;
    }

    private boolean hasNextTagName() {
        return this.stream.advanceWhileChar(TAG_NAME_PREDICATE) > 0;
    }
}

