/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.template.sections;

import com.redhat.qute.parser.parameter.ParameterParser;
import com.redhat.qute.parser.template.ASTVisitor;
import com.redhat.qute.parser.template.CaseOperator;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionKind;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CaseSection
extends Section {
    public static final String TAG = "case";
    private static final Map<String, CaseOperator> caseOperators = new LinkedHashMap<String, CaseOperator>();

    private static void registerOperator(String name, String documentation, List<String> sample, boolean isMulti, String ... aliases) {
        CaseOperator operator = new CaseOperator(name, documentation, null, isMulti);
        caseOperators.put(operator.getName(), operator);
        operator.setUrl("https://quarkus.io/guides/qute-reference#when_operators");
        operator.setSample(sample);
        if (aliases != null) {
            for (String alias : aliases) {
                CaseOperator aliasOperator = operator = new CaseOperator(alias, documentation, name, isMulti);
                aliasOperator.setUrl("https://quarkus.io/guides/qute-reference#when_operators");
                aliasOperator.setSample(sample);
                caseOperators.put(alias, aliasOperator);
            }
        }
    }

    public CaseSection(int start, int end) {
        super(TAG, start, end);
    }

    CaseSection(String tag, int start, int end) {
        super(tag, start, end);
    }

    @Override
    protected void initializeParameters(List<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            parameter.setStartValue(parameter.getEnd());
            parameter.getName();
            parameter.setStartValue(-1);
            parameter.setCanHaveExpression(true);
        }
    }

    @Override
    protected List<Parameter> collectParameters() {
        boolean splitWithEquals = false;
        return ParameterParser.parse(this, false, splitWithEquals);
    }

    @Override
    public SectionKind getSectionKind() {
        return SectionKind.CASE;
    }

    @Override
    public List<SectionKind> getBlockLabels() {
        return List.of(SectionKind.IS, SectionKind.CASE, SectionKind.ELSE);
    }

    @Override
    protected void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            List<Parameter> parameters = this.getParameters();
            for (Parameter parameter : parameters) {
                this.acceptChild(visitor, parameter);
            }
            this.acceptChildren(visitor, this.getChildren());
        }
        visitor.endVisit(this);
    }

    public Collection<CaseOperator> getAllowedOperators() {
        return caseOperators.values();
    }

    public CompletionCaseResult getCompletionCaseResultAt(int offset, Parameter triggeredParameter) {
        int increment;
        List<Parameter> parameters = super.getParameters();
        Parameter firstParameter = this.getParameterAtIndex(0);
        int n = increment = triggeredParameter != null ? 1 : 0;
        if (parameters.size() == 0 + increment) {
            return CompletionCaseResult.ALL_OPERATOR_AND_FIELD;
        }
        boolean beforeFirstParam = offset < firstParameter.getStart() + increment;
        CaseOperator operator = this.getCaseOperator();
        if (parameters.size() == 1 + increment) {
            if (beforeFirstParam) {
                return CompletionCaseResult.ALL_OPERATOR;
            }
            if (operator == null) {
                return CompletionCaseResult.NONE;
            }
            return CompletionCaseResult.FIELD_ONLY;
        }
        if (parameters.size() >= 2 + increment) {
            if (operator == null && beforeFirstParam) {
                return CompletionCaseResult.MULTI_OPERATOR_ONLY;
            }
            if (operator == null || !operator.isMulti() || beforeFirstParam) {
                return CompletionCaseResult.NONE;
            }
            return CompletionCaseResult.FIELD_ONLY;
        }
        return CompletionCaseResult.NONE;
    }

    public Parameter getValidParameterOperator() {
        int paramCount = this.getParameters().size();
        if (paramCount == 0) {
            return null;
        }
        Parameter parameter = this.getParameterAtIndex(0);
        return caseOperators.containsKey(parameter.getName()) ? parameter : null;
    }

    @Override
    public boolean isValidOperator(String partName) {
        return caseOperators.containsKey(partName);
    }

    public CaseOperator getCaseOperator() {
        Parameter parameter = this.getValidParameterOperator();
        return parameter != null ? caseOperators.get(parameter.getName()) : null;
    }

    public boolean isCaseOperator(Parameter parameter) {
        return parameter == this.getValidParameterOperator();
    }

    static {
        CaseSection.registerOperator("gt", "Greater than.", Arrays.asList("{#case gt 10}"), false, ">");
        CaseSection.registerOperator("ge", "Greater than or equal to.", Arrays.asList("{#case >= 10}"), false, ">=");
        CaseSection.registerOperator("lt", "Less than.", Arrays.asList("{#case < 10}"), false, "<");
        CaseSection.registerOperator("le", "Less than or equal to.", Arrays.asList("{#case le 10}"), false, "<=");
        CaseSection.registerOperator("not", "Not equal.", Arrays.asList("{#is not 10}", "{#case != 10}"), false, "ne", "!=");
        CaseSection.registerOperator("in", "Is in.", Arrays.asList("{#is in 'foo' 'bar' 'baz'}"), true, new String[0]);
        CaseSection.registerOperator("ni", "Is not in.", Arrays.asList("{#is !in 1 2 3}"), true, "!in");
    }

    public static enum CompletionCaseResult {
        ALL_OPERATOR_AND_FIELD,
        ALL_OPERATOR,
        MULTI_OPERATOR_ONLY,
        FIELD_ONLY,
        NONE;

    }
}

