/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.template.sections;

import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.sections.CaseSection;
import com.redhat.qute.parser.template.sections.CustomSection;
import com.redhat.qute.parser.template.sections.EachSection;
import com.redhat.qute.parser.template.sections.ElseSection;
import com.redhat.qute.parser.template.sections.ForSection;
import com.redhat.qute.parser.template.sections.FragmentSection;
import com.redhat.qute.parser.template.sections.IfSection;
import com.redhat.qute.parser.template.sections.IncludeSection;
import com.redhat.qute.parser.template.sections.InsertSection;
import com.redhat.qute.parser.template.sections.IsSection;
import com.redhat.qute.parser.template.sections.LetSection;
import com.redhat.qute.parser.template.sections.SectionFactory;
import com.redhat.qute.parser.template.sections.SetSection;
import com.redhat.qute.parser.template.sections.SwitchSection;
import com.redhat.qute.parser.template.sections.WhenSection;
import com.redhat.qute.parser.template.sections.WithSection;
import java.util.HashMap;
import java.util.Map;

public class DefaultSectionFactory
implements SectionFactory {
    private static final Map<String, SectionFactory> factoryByTag = new HashMap<String, SectionFactory>();

    @Override
    public Section createSection(String tag, int start, int end) {
        SectionFactory factory = factoryByTag.get(tag);
        return factory != null ? factory.createSection(tag, start, end) : new CustomSection(tag, start, end);
    }

    static {
        factoryByTag.put("each", (tag, start, end) -> new EachSection(start, end));
        factoryByTag.put("for", (tag, start, end) -> new ForSection(start, end));
        factoryByTag.put("fragment", (tag, start, end) -> new FragmentSection(start, end));
        factoryByTag.put("if", (tag, start, end) -> new IfSection(start, end));
        factoryByTag.put("else", (tag, start, end) -> new ElseSection(start, end));
        factoryByTag.put("include", (tag, start, end) -> new IncludeSection(start, end));
        factoryByTag.put("insert", (tag, start, end) -> new InsertSection(start, end));
        factoryByTag.put("set", (tag, start, end) -> new SetSection(start, end));
        factoryByTag.put("let", (tag, start, end) -> new LetSection(start, end));
        factoryByTag.put("with", (tag, start, end) -> new WithSection(start, end));
        factoryByTag.put("when", (tag, start, end) -> new WhenSection(start, end));
        factoryByTag.put("switch", (tag, start, end) -> new SwitchSection(start, end));
        factoryByTag.put("is", (tag, start, end) -> new IsSection(start, end));
        factoryByTag.put("case", (tag, start, end) -> new CaseSection(start, end));
    }
}

