/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.template.sections;

import com.redhat.qute.parser.condition.ConditionExpression;
import com.redhat.qute.parser.condition.ConditionParser;
import com.redhat.qute.parser.template.ASTVisitor;
import com.redhat.qute.parser.template.Operator;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionKind;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class IfSection
extends Section {
    public static final String TAG = "if";
    private static final Map<String, Operator> operators = new LinkedHashMap<String, Operator>();

    public IfSection(int start, int end) {
        super(TAG, start, end);
    }

    private static void registerOperator(String name, String documentation, String ... aliases) {
        Operator operator = new Operator(name, documentation, null);
        operators.put(operator.getName(), operator);
        if (aliases != null) {
            for (String alias : aliases) {
                Operator aliasOperator = new Operator(alias, documentation, name);
                operators.put(alias, aliasOperator);
            }
        }
    }

    @Override
    public SectionKind getSectionKind() {
        return SectionKind.IF;
    }

    @Override
    public List<SectionKind> getBlockLabels() {
        return Collections.singletonList(SectionKind.ELSE);
    }

    @Override
    protected List<Parameter> collectParameters() {
        ConditionExpression conditionExpression = ConditionParser.parse(this, this.getOwnerTemplate().getCancelChecker());
        return conditionExpression.getAllParameters();
    }

    @Override
    protected void initializeParameters(List<Parameter> parameters) {
        boolean shouldBeAnOperator = false;
        for (Parameter parameter : parameters) {
            parameter.setCanHaveExpression(!shouldBeAnOperator);
            shouldBeAnOperator = !shouldBeAnOperator;
        }
    }

    @Override
    protected void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            List<Parameter> parameters = this.getParameters();
            for (Parameter parameter : parameters) {
                this.acceptChild(visitor, parameter);
            }
            this.acceptChildren(visitor, this.getChildren());
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean isValidOperator(String partName) {
        return operators.containsKey(partName);
    }

    public Collection<Operator> getAllowedOperators() {
        return operators.values();
    }

    static {
        IfSection.registerOperator("!", "Logical complement.", new String[0]);
        IfSection.registerOperator("gt", "Greater than.", ">");
        IfSection.registerOperator("ge", "Greater than or equal to.", ">=");
        IfSection.registerOperator("lt", "Less than.", "<");
        IfSection.registerOperator("le", "Less than or equal to.", "<=");
        IfSection.registerOperator("eq", "Equals.", "==", "is");
        IfSection.registerOperator("ne", "Not equals.", "!=");
        IfSection.registerOperator("&&", "Logical AND (short-circuiting).", "and");
        IfSection.registerOperator("||", "Logical OR (short-circuiting)", "or");
    }
}

