/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.template.sections;

import com.redhat.qute.parser.template.ASTVisitor;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionKind;
import com.redhat.qute.project.QuteProject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

public class IncludeSection
extends Section {
    public static final String TAG = "include";

    public IncludeSection(int start, int end) {
        super(TAG, start, end);
    }

    @Override
    public SectionKind getSectionKind() {
        return SectionKind.INCLUDE;
    }

    public Path getReferencedTemplateFile() {
        String referencedTemplateId = this.getReferencedTemplateId();
        if (referencedTemplateId == null) {
            return null;
        }
        QuteProject project = this.getOwnerTemplate().getProject();
        if (project == null) {
            return null;
        }
        Path templatePath = IncludeSection.getReferencedTemplateFile(referencedTemplateId, project);
        if (templatePath != null && Files.exists(templatePath, new LinkOption[0])) {
            return templatePath;
        }
        if (!project.getProjectDependencies().isEmpty()) {
            for (QuteProject projectDependency : project.getProjectDependencies()) {
                Path dependencyTemplatePath;
                if (projectDependency == null || (dependencyTemplatePath = IncludeSection.getReferencedTemplateFile(referencedTemplateId, projectDependency)) == null || !Files.exists(dependencyTemplatePath, new LinkOption[0])) continue;
                return dependencyTemplatePath;
            }
        }
        return templatePath;
    }

    private static Path getReferencedTemplateFile(String referencedTemplateId, QuteProject project) {
        Path templateBaseDir = project.getTemplateBaseDir();
        if (templateBaseDir == null) {
            return null;
        }
        for (String suffix : project.getTemplateVariants()) {
            Path referencedTemplateFile = templateBaseDir.resolve(referencedTemplateId + suffix);
            if (!Files.exists(referencedTemplateFile, new LinkOption[0])) continue;
            return referencedTemplateFile;
        }
        return templateBaseDir.resolve(referencedTemplateId + ".html");
    }

    public String getReferencedTemplateId() {
        Parameter templateParameter = this.getTemplateParameter();
        if (templateParameter == null) {
            return null;
        }
        return templateParameter.getValue();
    }

    public Parameter getTemplateParameter() {
        return super.getParameterAtIndex(0);
    }

    @Override
    protected void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            List<Parameter> parameters = this.getParameters();
            for (Parameter parameter : parameters) {
                this.acceptChild(visitor, parameter);
            }
            this.acceptChildren(visitor, this.getChildren());
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean canSupportUnterminatedSection() {
        return true;
    }
}

