/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.template.sections;

import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.ParameterInfo;
import com.redhat.qute.parser.template.ParametersInfo;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionKind;
import com.redhat.qute.parser.template.SectionMetadata;
import com.redhat.qute.parser.template.sections.ElseSection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class LoopSection
extends Section {
    public static final String ITERATION_METADATA_PREFIX_ALIAS_QM = "<alias?>";
    public static final String ITERATION_METADATA_PREFIX_ALIAS_UNDERSCORE = "<alias_>";
    public static final String ITERATION_METADATA_PREFIX_NONE = "<none>";
    private static final String DEFAULT_ALIAS = "it";
    private static final String ALIAS = "alias";
    private static final String IN = "in";
    private static final String ITERABLE = "iterable";
    private static final int ALIAS_PARAMETER_INDEX = 0;
    private static final int ITERABLE_PARAMETER_INDEX = 2;
    private List<SectionMetadata> metadata;
    private static final List<SectionMetadata> METADATA = Arrays.asList(new SectionMetadata("count", Integer.class.getName(), "`count` - 1-based index"), new SectionMetadata("index", Integer.class.getName(), "`index` - zero-based index"), new SectionMetadata("indexParity", String.class.getName(), "`indexParity` - outputs `odd` or `even` based on the zero-based index value"), new SectionMetadata("hasNext", Boolean.class.getName(), "`hasNext` - true if the iteration has more elements"), new SectionMetadata("isLast", Boolean.class.getName(), "`isLast` - true if hasNext == false"), new SectionMetadata("isFirst", Boolean.class.getName(), "`isFirst` - true if count == 1"), new SectionMetadata("odd", Boolean.class.getName(), "`odd` - true if the zero-based index is odd"), new SectionMetadata("even", Boolean.class.getName(), "`even` - true if the zero-based index is even"));
    private static final ParametersInfo PARAMETER_INFOS = ParametersInfo.builder().addParameter("alias", "$empty$").addParameter("in", "$empty$").addParameter(new ParameterInfo("iterable", null, true)).build();

    public LoopSection(String tag, int start, int end) {
        super(tag, start, end);
    }

    @Override
    public List<SectionMetadata> getMetadata() {
        if (this.metadata == null) {
            this.metadata = this.loadMetadata();
        }
        return this.metadata;
    }

    private synchronized List<SectionMetadata> loadMetadata() {
        if (this.metadata != null) {
            return this.metadata;
        }
        String metadataPrefix = this.getOwnerTemplate().getConfiguration().getIterationMetadataPrefix();
        String prefix = LoopSection.prefixValue(this.getAlias(), metadataPrefix);
        this.metadata = prefix == null ? METADATA : METADATA.stream().map(m -> new SectionMetadata(prefix + m.getName(), m.getJavaType(), m.getDescription())).collect(Collectors.toList());
        return this.metadata;
    }

    public String getAlias() {
        Parameter alias = this.getAliasParameter();
        if (alias != null) {
            return alias.getValue();
        }
        return DEFAULT_ALIAS;
    }

    public Parameter getAliasParameter() {
        int nbParameters = this.getParameters().size();
        if (nbParameters >= 3) {
            return this.getParameterAtIndex(0);
        }
        return null;
    }

    public Parameter getIterableParameter() {
        int nbParameters = this.getParameters().size();
        if (nbParameters >= 2) {
            Parameter iterable = this.getParameterAtIndex(2);
            if (iterable != null) {
                return iterable;
            }
        } else {
            Parameter iterable = this.getParameterAtIndex(0);
            if (iterable != null) {
                return iterable;
            }
        }
        return null;
    }

    public boolean isInAlias(int offset) {
        Parameter parameter = this.getAliasParameter();
        if (parameter == null) {
            return false;
        }
        return Node.isIncluded(parameter, offset);
    }

    @Override
    public boolean isIterable() {
        return true;
    }

    @Override
    public ParametersInfo getParametersInfo() {
        return PARAMETER_INFOS;
    }

    private static String prefixValue(String alias, String metadataPrefix) {
        if (metadataPrefix == null || ITERATION_METADATA_PREFIX_NONE.equals(metadataPrefix)) {
            return null;
        }
        if (ITERATION_METADATA_PREFIX_ALIAS_UNDERSCORE.equals(metadataPrefix)) {
            return alias + "_";
        }
        if (ITERATION_METADATA_PREFIX_ALIAS_QM.equals(metadataPrefix)) {
            return alias + "?";
        }
        return metadataPrefix;
    }

    public ElseSection getElseSection() {
        for (Node child : this.getChildren()) {
            if (child.getKind() != NodeKind.Section || ((Section)child).getSectionKind() != SectionKind.ELSE) continue;
            return (ElseSection)child;
        }
        return null;
    }

    public boolean isInElseBlock(int offset) {
        ElseSection elseSection = this.getElseSection();
        if (elseSection == null) {
            return false;
        }
        return offset > elseSection.getEnd();
    }

    @Override
    public List<SectionKind> getBlockLabels() {
        return Collections.singletonList(SectionKind.ELSE);
    }
}

