/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.validator;

import com.redhat.qute.ls.commons.CodeActionFactory;
import com.redhat.qute.parser.validator.IQuteErrorCode;
import io.quarkus.qute.ErrorCode;
import io.quarkus.qute.ParserError;
import io.quarkus.qute.TemplateException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public enum QuteSyntaxErrorCode implements IQuteErrorCode
{
    NO_SECTION_NAME("Parser error: no section name declared for {0}", (ErrorCode)ParserError.NO_SECTION_NAME),
    SECTION_END_DOES_NOT_MATCH_START("Parser error: section end tag [{0}] does not match the start tag [{1}]", (ErrorCode)ParserError.SECTION_END_DOES_NOT_MATCH_START),
    SECTION_BLOCK_END_DOES_NOT_MATCH_START("Parser error: section block end tag [{0}] does not match the start tag [{1}]", (ErrorCode)ParserError.SECTION_BLOCK_END_DOES_NOT_MATCH_START),
    SECTION_START_NOT_FOUND("Parser error: section start tag not found for {0}", (ErrorCode)ParserError.SECTION_START_NOT_FOUND),
    UNTERMINATED_SECTION("Parser error: unterminated section [{0}] detected", (ErrorCode)ParserError.UNTERMINATED_SECTION),
    UNEXPECTED_TOKEN("Syntax error: `Unexpected ''{0}'' token`.", null);

    private static List<ErrorCode> supportedErrorCodes;
    private final String rawMessage;
    private final ErrorCode override;

    private QuteSyntaxErrorCode(String rawMessage, ErrorCode override) {
        this.rawMessage = rawMessage;
        this.override = override;
    }

    @Override
    public String getCode() {
        return this.name();
    }

    public String toString() {
        return this.getCode();
    }

    @Override
    public String getRawMessage() {
        return this.rawMessage;
    }

    public boolean isQuteErrorCode(Either<String, Integer> code) {
        return CodeActionFactory.isDiagnosticCode(code, this.name());
    }

    public static QuteSyntaxErrorCode getErrorCode(Either<String, Integer> diagnosticCode) {
        if (diagnosticCode == null || diagnosticCode.isRight()) {
            return null;
        }
        String code = (String)diagnosticCode.getLeft();
        try {
            return QuteSyntaxErrorCode.valueOf(code);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isSupported(TemplateException e) {
        ErrorCode errorCode = e.getCode();
        if (supportedErrorCodes == null) {
            QuteSyntaxErrorCode[] codes;
            supportedErrorCodes = new ArrayList<ErrorCode>();
            supportedErrorCodes.add((ErrorCode)ParserError.NO_SECTION_HELPER_FOUND);
            for (QuteSyntaxErrorCode code : codes = QuteSyntaxErrorCode.values()) {
                if (code.override == null) continue;
                supportedErrorCodes.add(code.override);
            }
        }
        return supportedErrorCodes.contains(errorCode);
    }
}

