/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.validator;

import com.redhat.qute.parser.expression.MethodPart;
import com.redhat.qute.parser.expression.ObjectPart;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.expression.PropertyPart;
import com.redhat.qute.parser.template.ASTVisitor;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.template.sections.CaseSection;
import com.redhat.qute.parser.template.sections.CustomSection;
import com.redhat.qute.parser.template.sections.EachSection;
import com.redhat.qute.parser.template.sections.ElseSection;
import com.redhat.qute.parser.template.sections.ForSection;
import com.redhat.qute.parser.template.sections.FragmentSection;
import com.redhat.qute.parser.template.sections.IfSection;
import com.redhat.qute.parser.template.sections.IncludeSection;
import com.redhat.qute.parser.template.sections.InsertSection;
import com.redhat.qute.parser.template.sections.IsSection;
import com.redhat.qute.parser.template.sections.LetSection;
import com.redhat.qute.parser.template.sections.SetSection;
import com.redhat.qute.parser.template.sections.SwitchSection;
import com.redhat.qute.parser.template.sections.WhenSection;
import com.redhat.qute.parser.template.sections.WithSection;
import com.redhat.qute.parser.validator.IQuteSyntaxValidatorReporter;
import com.redhat.qute.parser.validator.QuteSyntaxErrorCode;
import com.redhat.qute.utils.QutePositionUtility;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lsp4j.Range;

public class QuteSyntaxValidator
extends ASTVisitor {
    private final IQuteSyntaxValidatorReporter reporter;
    private Set<Section> sectionStartNotFoundToIgnore;

    public QuteSyntaxValidator(IQuteSyntaxValidatorReporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public boolean visit(CaseSection node) {
        return super.visit(node);
    }

    @Override
    public boolean visit(CustomSection node) {
        this.validateSectionSyntax(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(EachSection node) {
        this.validateSectionSyntax(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(ElseSection node) {
        this.validateSectionSyntax(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(ForSection node) {
        this.validateSectionSyntax(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(FragmentSection node) {
        this.validateSectionSyntax(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(IfSection node) {
        this.validateSectionSyntax(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(IncludeSection node) {
        this.validateSectionSyntax(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(InsertSection node) {
        this.validateSectionSyntax(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(IsSection node) {
        return super.visit(node);
    }

    @Override
    public boolean visit(LetSection node) {
        this.validateSectionSyntax(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(SetSection node) {
        this.validateSectionSyntax(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(SwitchSection node) {
        this.validateSectionSyntax(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(WhenSection node) {
        this.validateSectionSyntax(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(WithSection node) {
        this.validateSectionSyntax(node);
        return super.visit(node);
    }

    private void validateSectionSyntax(Section section) {
        if (!section.hasTag()) {
            Range startSectionRange = QutePositionUtility.selectStartTagName(section);
            this.reporter.reportError(startSectionRange, section, QuteSyntaxErrorCode.NO_SECTION_NAME, "{#}");
        } else if (section.hasStartTag()) {
            boolean sectionBlock = section.isSectionBlock();
            if (!section.hasEndTag() && !section.isSelfClosed()) {
                Section orphanEndSection = section.getOrphanEndSection(sectionBlock ? section.getEnd() : section.getStart(), section.getTag(), true);
                if (orphanEndSection != null) {
                    if (this.sectionStartNotFoundToIgnore == null) {
                        this.sectionStartNotFoundToIgnore = new HashSet<Section>();
                    }
                    this.sectionStartNotFoundToIgnore.add(orphanEndSection);
                    if (sectionBlock) {
                        Range endSectionRange = QutePositionUtility.selectEndTagName(orphanEndSection);
                        this.reporter.reportError(endSectionRange, orphanEndSection, QuteSyntaxErrorCode.SECTION_BLOCK_END_DOES_NOT_MATCH_START, orphanEndSection.getTag(), section.getTag());
                    } else {
                        Range endSectionRange = QutePositionUtility.selectEndTagName(orphanEndSection);
                        this.reporter.reportError(endSectionRange, orphanEndSection, QuteSyntaxErrorCode.SECTION_END_DOES_NOT_MATCH_START, orphanEndSection.getTag(), section.getTag());
                    }
                } else if (!sectionBlock && !section.canSupportUnterminatedSection()) {
                    Range startSectionRange = QutePositionUtility.selectStartTagName(section);
                    this.reporter.reportError(startSectionRange, section, QuteSyntaxErrorCode.UNTERMINATED_SECTION, section.getTag());
                }
            }
        } else if (this.sectionStartNotFoundToIgnore == null || !this.sectionStartNotFoundToIgnore.contains(section)) {
            Range endSectionRange = QutePositionUtility.selectEndTagName(section);
            this.reporter.reportError(endSectionRange, section, QuteSyntaxErrorCode.SECTION_START_NOT_FOUND, "{/" + section.getTag() + "}");
        }
    }

    @Override
    public boolean visit(ObjectPart node) {
        this.validateEndWithDotSyntax(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(PropertyPart node) {
        this.validateEndWithDotSyntax(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(MethodPart node) {
        for (Parameter parameter : node.getParameters()) {
            Expression expression = parameter.getJavaTypeExpression();
            if (expression == null) continue;
            expression.accept(this);
        }
        this.validateEndWithDotSyntax(node);
        return super.visit(node);
    }

    private void validateEndWithDotSyntax(Part node) {
        if (!this.hasFollowingPart(node)) {
            char c;
            String text;
            Template template = node.getOwnerTemplate();
            int end = node.getPartKind() == Parts.PartKind.Method ? node.getEnd() + 1 : node.getEnd();
            if (end < (text = template.getText()).length() && (c = text.charAt(end)) == '.') {
                Range range = QutePositionUtility.createRange(end, end + 1, template);
                this.reporter.reportError(range, node, QuteSyntaxErrorCode.UNEXPECTED_TOKEN, Character.valueOf(c));
            }
        }
    }

    private boolean hasFollowingPart(Part node) {
        Part nextPart;
        Node next = node.getNextSibling();
        if (next == null) {
            return false;
        }
        if (next.getKind() == NodeKind.ExpressionPart && (nextPart = (Part)next).getPartKind() == Parts.PartKind.Method) {
            MethodPart methodPart = (MethodPart)nextPart;
            return !methodPart.isInfixNotation();
        }
        return true;
    }
}

