/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project;

import com.redhat.qute.commons.JavaFieldInfo;
import com.redhat.qute.commons.JavaMemberInfo;
import com.redhat.qute.commons.JavaMethodInfo;
import com.redhat.qute.commons.JavaParameterInfo;
import com.redhat.qute.commons.JavaTypeInfo;
import com.redhat.qute.commons.QuteResolvedJavaTypeParams;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverKind;
import com.redhat.qute.parser.expression.ObjectPart;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.ExpressionParameter;
import com.redhat.qute.parser.template.JavaTypeInfoProvider;
import com.redhat.qute.parser.template.LiteralSupport;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.ResolvedGenericJavaTypeInfo;
import com.redhat.qute.project.datamodel.resolvers.ValueResolver;
import com.redhat.qute.services.QuteCompletableFutures;
import com.redhat.qute.utils.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public class JavaDataModelCache {
    private static final Map<String, String> autoboxing;
    private static final Map<String, CompletableFuture<ResolvedJavaTypeInfo>> javaPrimitiveTypes;
    private final QuteProject project;

    private static void registerPrimitiveType(String type) {
        ResolvedJavaTypeInfo primitiveType = new ResolvedJavaTypeInfo();
        primitiveType.setSignature(type);
        javaPrimitiveTypes.put(primitiveType.getSignature(), CompletableFuture.completedFuture(primitiveType));
        ResolvedJavaTypeInfo primitiveTypeArray = new ResolvedJavaTypeInfo();
        primitiveTypeArray.setSignature(type + "[]");
        primitiveTypeArray.setIterableOf(type);
        javaPrimitiveTypes.put(primitiveTypeArray.getSignature(), CompletableFuture.completedFuture(primitiveTypeArray));
        String objectType = LiteralSupport.getPrimitiveObjectType(type);
        if (objectType != null) {
            autoboxing.put(type, type);
            autoboxing.put(objectType, type);
        }
    }

    public JavaDataModelCache(QuteProject project) {
        this.project = project;
    }

    public CompletableFuture<ResolvedJavaTypeInfo> resolveJavaType(Parameter parameter) {
        Part lastPart;
        ExpressionParameter expressionParameter;
        Expression expression = parameter.getJavaTypeExpression();
        if (expression instanceof ExpressionParameter && !StringUtils.isEmpty((expressionParameter = (ExpressionParameter)expression).getLiteralJavaType())) {
            return this.resolveJavaType(expressionParameter.getLiteralJavaType());
        }
        if (expression != null && (lastPart = expression.getLastPart()) != null) {
            return this.resolveJavaType(lastPart);
        }
        return QuteCompletableFutures.RESOLVED_JAVA_TYPE_INFO_NULL_FUTURE;
    }

    public CompletableFuture<ResolvedJavaTypeInfo> resolveJavaType(Part part) {
        Parts parts = part.getParent();
        int partIndex = parts.getPartIndex(part);
        return this.resolveJavaType(parts, partIndex);
    }

    public CompletableFuture<ResolvedJavaTypeInfo> resolveJavaType(String className) {
        return this.resolveJavaType(className, false);
    }

    public CompletableFuture<ResolvedJavaTypeInfo> resolveJavaType(String className, boolean wrap) {
        CompletableFuture<ResolvedJavaTypeInfo> result = this.resolveJavaType(className, null);
        if (wrap) {
            return this.wrapObject(result);
        }
        return result;
    }

    public CompletableFuture<ResolvedJavaTypeInfo> resolveJavaType(String className, JavaTypeInfoProvider javaTypeInfo) {
        CompletableFuture<ResolvedJavaTypeInfo> future = this.getValidResolvedJavaTypeInCache(className);
        if (future != null) {
            return future;
        }
        return this.resolveJavaType(className, javaTypeInfo, new HashSet<String>());
    }

    private CompletableFuture<ResolvedJavaTypeInfo> resolveJavaType(String javaTypeName, JavaTypeInfoProvider javaTypeInfo, Set<String> visited) {
        if (StringUtils.isEmpty(javaTypeName)) {
            return QuteCompletableFutures.RESOLVED_JAVA_TYPE_INFO_NULL_FUTURE;
        }
        if (visited.contains(javaTypeName)) {
            return QuteCompletableFutures.RESOLVED_JAVA_TYPE_INFO_NULL_FUTURE;
        }
        visited.add(javaTypeName);
        CompletableFuture<ResolvedJavaTypeInfo> primitiveType = javaPrimitiveTypes.get(javaTypeName);
        if (primitiveType != null) {
            return primitiveType;
        }
        CompletionStage<ResolvedJavaTypeInfo> future = this.getValidResolvedJavaTypeInCache(javaTypeName);
        if (future == null) {
            if (javaTypeName.endsWith("[]")) {
                future = this.resolveJavaType(javaTypeName.substring(0, javaTypeName.length() - 2), javaTypeInfo).thenApply(item -> {
                    ResolvedJavaTypeInfo array = new ResolvedJavaTypeInfo();
                    array.setSignature(javaTypeName);
                    return array;
                });
            } else {
                CompletableFuture<ResolvedJavaTypeInfo> loadResolveJavaTypeFuture = this.resolveJavaTypeWithoutGeneric(javaTypeName, javaTypeInfo);
                future = loadResolveJavaTypeFuture.thenCompose(resolvedJavaType -> {
                    if (resolvedJavaType != null) {
                        Map<String, String> generics = resolvedJavaType.createGenericMap(javaTypeName);
                        resolvedJavaType = JavaDataModelCache.updateJavaType(resolvedJavaType, generics);
                        visited.add(resolvedJavaType.getSignature());
                        ResolvedJavaTypeInfo resolvedJavaTypeWithLoadedDeps = resolvedJavaType;
                        if (resolvedJavaType.getExtendedTypes() != null) {
                            HashSet<CompletableFuture<ResolvedJavaTypeInfo>> resolvingExtendedFutures = new HashSet<CompletableFuture<ResolvedJavaTypeInfo>>();
                            for (String extendedType : resolvedJavaType.getExtendedTypes()) {
                                resolvingExtendedFutures.add(this.resolveJavaType(extendedType, javaTypeInfo, visited));
                            }
                            if (!resolvingExtendedFutures.isEmpty()) {
                                CompletableFuture<Void> allFutures = CompletableFuture.allOf(resolvingExtendedFutures.toArray(new CompletableFuture[resolvingExtendedFutures.size()]));
                                return allFutures.thenApply(all -> {
                                    this.updateIterableAndWrappedObject(resolvedJavaTypeWithLoadedDeps, resolvingExtendedFutures);
                                    return resolvedJavaTypeWithLoadedDeps;
                                });
                            }
                        }
                    }
                    return CompletableFuture.completedFuture(resolvedJavaType);
                });
            }
            this.project.registerResolvedJavaType(javaTypeName, (CompletableFuture<ResolvedJavaTypeInfo>)future);
        }
        return future;
    }

    public static ResolvedJavaTypeInfo updateJavaType(ResolvedJavaTypeInfo simpleOrGenericType, Map<String, String> genericMap) {
        boolean hasGeneric = genericMap != null;
        ResolvedJavaTypeInfo javaType = simpleOrGenericType;
        if (hasGeneric) {
            javaType = new ResolvedGenericJavaTypeInfo(simpleOrGenericType, genericMap);
        } else {
            for (JavaFieldInfo field : simpleOrGenericType.getFields()) {
                field.setJavaType(javaType);
            }
            for (JavaMethodInfo method : simpleOrGenericType.getMethods()) {
                method.setJavaType(javaType);
            }
        }
        return javaType;
    }

    private void updateIterableAndWrappedObject(ResolvedJavaTypeInfo resolvedJavaType, Set<CompletableFuture<ResolvedJavaTypeInfo>> resolvingExtendedFutures) {
        Set<ResolvedJavaTypeInfo> extendedTypes = resolvingExtendedFutures.stream().map(r -> r.getNow(null)).filter(r -> r != null).collect(Collectors.toSet());
        this.updateIterableAndWrappedObjectSync(resolvedJavaType, extendedTypes);
    }

    private void updateIterableAndWrappedObjectSync(ResolvedJavaTypeInfo resolvedJavaType, Set<ResolvedJavaTypeInfo> extendedTypes) {
        String iterableOf = null;
        boolean wrappedObject = false;
        for (ResolvedJavaTypeInfo extendedType : extendedTypes) {
            if (ResolvedJavaTypeInfo.isIterable(extendedType.getName())) {
                extendedType.isIterable();
                iterableOf = extendedType.getIterableOf();
                break;
            }
            if (extendedType.getIterableOf() == null) continue;
            iterableOf = extendedType.getIterableOf();
            break;
        }
        for (ResolvedJavaTypeInfo extendedType : extendedTypes) {
            if (!ResolvedJavaTypeInfo.isWrapperType(extendedType.getName())) continue;
            wrappedObject = true;
            break;
        }
        if (wrappedObject) {
            resolvedJavaType.setWrapperType(true);
        }
        if (iterableOf != null) {
            resolvedJavaType.setIterableOf(iterableOf);
        }
    }

    private CompletableFuture<ResolvedJavaTypeInfo> resolveJavaTypeWithoutGeneric(String javaTypeName, JavaTypeInfoProvider javaTypeInfo) {
        CompletableFuture<ResolvedJavaTypeInfo> future;
        String javaTypeWithoutGeneric = javaTypeName;
        int genericIndex = javaTypeName.indexOf(60);
        if (genericIndex != -1 && (future = this.getValidResolvedJavaTypeInCache(javaTypeWithoutGeneric = javaTypeName.substring(0, genericIndex))) != null) {
            return future;
        }
        String projectUri = this.project.getUri();
        ValueResolverKind kind = null;
        if (javaTypeInfo != null && javaTypeInfo instanceof ValueResolver) {
            kind = ((ValueResolver)((Object)javaTypeInfo)).getKind();
        }
        QuteResolvedJavaTypeParams params = new QuteResolvedJavaTypeParams(javaTypeWithoutGeneric, kind, projectUri);
        return this.project.getProjectRegistry().getResolvedJavaType(params);
    }

    private CompletableFuture<ResolvedJavaTypeInfo> getValidResolvedJavaTypeInCache(String javaTypeName) {
        CompletableFuture<ResolvedJavaTypeInfo> primitiveType = javaPrimitiveTypes.get(javaTypeName);
        if (primitiveType != null) {
            return primitiveType;
        }
        if (StringUtils.isEmpty(javaTypeName)) {
            return QuteCompletableFutures.RESOLVED_JAVA_TYPE_INFO_NULL_FUTURE;
        }
        CompletableFuture<ResolvedJavaTypeInfo> future = this.project.getResolvedJavaType(javaTypeName);
        if (future == null || future.isCancelled() || future.isCompletedExceptionally()) {
            return null;
        }
        return future;
    }

    private CompletableFuture<ResolvedJavaTypeInfo> resolveJavaType(Parts parts, int partIndex) {
        CompletionStage<ResolvedJavaTypeInfo> future = null;
        block4: for (int i = 0; i < partIndex + 1; ++i) {
            Part current = parts.getChild(i);
            switch (current.getPartKind()) {
                case Object: {
                    ObjectPart objectPart = (ObjectPart)current;
                    future = this.resolveJavaType(objectPart);
                    future = this.wrapGeneric(this.wrapObject((CompletableFuture<ResolvedJavaTypeInfo>)future));
                    continue block4;
                }
                case Property: 
                case Method: {
                    if (future != null) {
                        ResolvedJavaTypeInfo actualResolvedType = ((CompletableFuture)future).getNow(null);
                        future = actualResolvedType != null ? this.resolveJavaType(current, actualResolvedType) : ((CompletableFuture)future).thenCompose(resolvedType -> {
                            if (resolvedType == null) {
                                return QuteCompletableFutures.RESOLVED_JAVA_TYPE_INFO_NULL_FUTURE;
                            }
                            return this.resolveJavaType(current, (ResolvedJavaTypeInfo)resolvedType);
                        });
                    }
                    future = this.wrapGeneric(this.wrapObject((CompletableFuture<ResolvedJavaTypeInfo>)future));
                    continue block4;
                }
            }
        }
        return future != null ? future : QuteCompletableFutures.RESOLVED_JAVA_TYPE_INFO_NULL_FUTURE;
    }

    private CompletableFuture<ResolvedJavaTypeInfo> wrapGeneric(CompletableFuture<ResolvedJavaTypeInfo> future) {
        if (future == null) {
            return null;
        }
        if (future.isDone()) {
            ResolvedJavaTypeInfo resolvedJavaType2 = future.getNow(null);
            return this.wrapGeneric(resolvedJavaType2, future);
        }
        return future.thenCompose(resolvedJavaType -> this.wrapGeneric((ResolvedJavaTypeInfo)resolvedJavaType, future));
    }

    private CompletableFuture<ResolvedJavaTypeInfo> wrapGeneric(ResolvedJavaTypeInfo resolvedJavaType, CompletableFuture<ResolvedJavaTypeInfo> defaultFuture) {
        if (resolvedJavaType != null && resolvedJavaType != QuteCompletableFutures.NOT_ITERABLE_JAVA_TYPE && !(resolvedJavaType instanceof ResolvedGenericJavaTypeInfo) && resolvedJavaType.isGenericType()) {
            String key = resolvedJavaType.getName() + "@generic";
            CompletableFuture<ResolvedJavaTypeInfo> future = this.getValidResolvedJavaTypeInCache(key);
            if (future != null) {
                return future;
            }
            LinkedHashMap<String, String> generics = new LinkedHashMap<String, String>();
            List<JavaParameterInfo> typeParameters = resolvedJavaType.getTypeParameters();
            for (JavaParameterInfo typeParameter : typeParameters) {
                generics.put(typeParameter.getType(), "java.lang.Object");
            }
            resolvedJavaType = JavaDataModelCache.updateJavaType(resolvedJavaType, generics);
            future = CompletableFuture.completedFuture(resolvedJavaType);
            this.project.registerResolvedJavaType(key, future);
            return future;
        }
        return defaultFuture;
    }

    CompletableFuture<ResolvedJavaTypeInfo> wrapObject(CompletableFuture<ResolvedJavaTypeInfo> future) {
        if (future == null) {
            return null;
        }
        if (future.isDone()) {
            ResolvedJavaTypeInfo resolvedJavaType2 = future.getNow(null);
            return this.wrapObject(resolvedJavaType2, future);
        }
        return future.thenCompose(resolvedJavaType -> this.wrapObject((ResolvedJavaTypeInfo)resolvedJavaType, future));
    }

    CompletableFuture<ResolvedJavaTypeInfo> wrapObject(ResolvedJavaTypeInfo resolvedJavaType, CompletableFuture<ResolvedJavaTypeInfo> future) {
        List<JavaParameterInfo> types;
        if (resolvedJavaType != null && resolvedJavaType != QuteCompletableFutures.NOT_ITERABLE_JAVA_TYPE && resolvedJavaType.isWrapperType() && (types = resolvedJavaType.getTypeParameters()) != null && !types.isEmpty()) {
            JavaParameterInfo type = types.get(0);
            String javaTypeToResolve = type.getType();
            return this.resolveJavaType(javaTypeToResolve);
        }
        return future;
    }

    private CompletableFuture<ResolvedJavaTypeInfo> resolveJavaType(Part part, ResolvedJavaTypeInfo resolvedType) {
        JavaMemberInfo member = this.project.findMember(resolvedType, part.getPartName());
        if (member == null) {
            return QuteCompletableFutures.RESOLVED_JAVA_TYPE_INFO_NULL_FUTURE;
        }
        String memberType = member.resolveJavaElementType(resolvedType);
        return this.resolveJavaType(memberType);
    }

    private CompletableFuture<ResolvedJavaTypeInfo> resolveJavaType(ObjectPart objectPart) {
        Node node;
        Section section;
        Expression expression;
        CompletionStage<ResolvedJavaTypeInfo> future = null;
        JavaTypeInfoProvider javaTypeInfo = objectPart.resolveJavaType();
        if (javaTypeInfo == null) {
            return QuteCompletableFutures.RESOLVED_JAVA_TYPE_INFO_NULL_FUTURE;
        }
        String javaType = javaTypeInfo.getJavaType();
        if (StringUtils.isEmpty(javaType) && (expression = javaTypeInfo.getJavaTypeExpression()) != null) {
            String literalJavaType = expression.getLiteralJavaType();
            if (literalJavaType != null) {
                future = this.resolveJavaType(literalJavaType);
            } else {
                Part lastPart = expression.getLastPart();
                if (lastPart == null) {
                    return QuteCompletableFutures.RESOLVED_JAVA_TYPE_INFO_NULL_FUTURE;
                }
                future = this.resolveJavaType(lastPart);
            }
        }
        if (future == null) {
            future = this.resolveJavaType(javaType, javaTypeInfo);
        }
        if ((section = JavaDataModelCache.getOwnerSection(node = javaTypeInfo.getJavaTypeOwnerNode())) != null && section.isIterable()) {
            future = future.thenCompose(resolvedType -> {
                if (resolvedType == null) {
                    return QuteCompletableFutures.RESOLVED_JAVA_TYPE_INFO_NULL_FUTURE;
                }
                if (!resolvedType.isIterable()) {
                    if (resolvedType.isInteger()) {
                        return this.resolveJavaType(resolvedType.getName());
                    }
                    return QuteCompletableFutures.RESOLVED_JAVA_TYPE_NOT_ITERABLE_FUTURE;
                }
                String iterTypeName = resolvedType.getIterableOf();
                return this.resolveJavaType(iterTypeName);
            });
        }
        return future;
    }

    private static Section getOwnerSection(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getKind() == NodeKind.Parameter) {
            return ((Parameter)node).getOwnerSection();
        }
        return null;
    }

    public static boolean isSameType(String type1, String type2) {
        if (type1.equals(type2)) {
            return true;
        }
        String primitiveType = autoboxing.get(type1);
        if (primitiveType != null) {
            return primitiveType.equals(autoboxing.get(type2));
        }
        return false;
    }

    static {
        javaPrimitiveTypes = new HashMap<String, CompletableFuture<ResolvedJavaTypeInfo>>();
        autoboxing = new HashMap<String, String>();
        JavaTypeInfo.PRIMITIVE_TYPES.forEach(type -> JavaDataModelCache.registerPrimitiveType(type));
    }
}

