/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project;

import com.redhat.qute.commons.DocumentFormat;
import com.redhat.qute.commons.InvalidMethodReason;
import com.redhat.qute.commons.JavaElementInfo;
import com.redhat.qute.commons.JavaFieldInfo;
import com.redhat.qute.commons.JavaMemberInfo;
import com.redhat.qute.commons.JavaMethodInfo;
import com.redhat.qute.commons.JavaParameterInfo;
import com.redhat.qute.commons.JavaTypeInfo;
import com.redhat.qute.commons.ProjectInfo;
import com.redhat.qute.commons.QuteJavadocParams;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.commons.annotations.TemplateDataAnnotation;
import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.commons.datamodel.DataModelProject;
import com.redhat.qute.commons.datamodel.DataModelTemplate;
import com.redhat.qute.commons.datamodel.QuteDataModelProjectParams;
import com.redhat.qute.commons.datamodel.resolvers.NamespaceResolverInfo;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverKind;
import com.redhat.qute.commons.jaxrs.JaxRsParamKind;
import com.redhat.qute.commons.jaxrs.RestParam;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.template.LiteralSupport;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.template.TemplateConfiguration;
import com.redhat.qute.project.JavaDataModelCache;
import com.redhat.qute.project.JavaMemberResult;
import com.redhat.qute.project.QuteProjectFilesWatcher;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.project.QuteTextDocument;
import com.redhat.qute.project.datamodel.ExtendedDataModelProject;
import com.redhat.qute.project.datamodel.ExtendedDataModelTemplate;
import com.redhat.qute.project.datamodel.resolvers.FieldValueResolver;
import com.redhat.qute.project.datamodel.resolvers.MessageValueResolver;
import com.redhat.qute.project.datamodel.resolvers.MethodValueResolver;
import com.redhat.qute.project.datamodel.resolvers.TypeValueResolver;
import com.redhat.qute.project.datamodel.resolvers.ValueResolver;
import com.redhat.qute.project.documents.QuteClosedTextDocuments;
import com.redhat.qute.project.documents.TemplateValidator;
import com.redhat.qute.project.tags.UserTag;
import com.redhat.qute.project.tags.UserTagRegistry;
import com.redhat.qute.services.QuteCompletableFutures;
import com.redhat.qute.services.completions.CompletionRequest;
import com.redhat.qute.services.nativemode.JavaTypeAccessibiltyRule;
import com.redhat.qute.services.nativemode.JavaTypeFilter;
import com.redhat.qute.services.nativemode.NativeModeJavaTypeFilter;
import com.redhat.qute.utils.FileUtils;
import com.redhat.qute.utils.StringUtils;
import com.redhat.qute.utils.UserTagUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CompletionItem;

public class QuteProject {
    private static String[] TEMPLATE_VARIANTS = new String[]{"", ".html", ".qute.html", ".json", ".qute.json", ".txt", ".qute.txt", ".yaml", ".qute.yaml", ".yml", ".qute.yml"};
    private final String uri;
    private final Path templateBaseDir;
    private final QuteClosedTextDocuments closedDocuments;
    private final Map<String, QuteTextDocument> documents;
    private final Map<String, CompletableFuture<ResolvedJavaTypeInfo>> resolvedJavaTypes;
    private Map<String, JavaTypeAccessibiltyRule> targetAnnotations;
    private CompletableFuture<ExtendedDataModelProject> dataModelProjectFuture;
    private final QuteProjectRegistry projectRegistry;
    private final UserTagRegistry tagRegistry;
    private final NativeModeJavaTypeFilter filterInNativeMode;
    private final TemplateValidator validator;
    private final QuteProjectFilesWatcher watcher;
    private final JavaDataModelCache javaCache;
    private List<QuteProject> projectDependencies;

    public QuteProject(ProjectInfo projectInfo, QuteProjectRegistry projectRegistry, TemplateValidator validator) {
        this.uri = projectInfo.getUri();
        this.templateBaseDir = FileUtils.createPath(projectInfo.getTemplateBaseDir());
        this.documents = new HashMap<String, QuteTextDocument>();
        this.closedDocuments = new QuteClosedTextDocuments(this, this.documents);
        this.projectRegistry = projectRegistry;
        this.resolvedJavaTypes = new HashMap<String, CompletableFuture<ResolvedJavaTypeInfo>>();
        this.tagRegistry = new UserTagRegistry(this, this.templateBaseDir, projectRegistry);
        this.filterInNativeMode = new NativeModeJavaTypeFilter(this);
        this.validator = validator;
        this.watcher = !projectRegistry.isDidChangeWatchedFilesSupported() ? QuteProject.createFilesWatcher(this) : null;
        this.javaCache = new JavaDataModelCache(this);
        this.projectDependencies = new ArrayList<QuteProject>();
    }

    private static QuteProjectFilesWatcher createFilesWatcher(QuteProject project) {
        try {
            return new QuteProjectFilesWatcher(project);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void validateClosedTemplates() {
        if (this.validator != null) {
            this.closedDocuments.loadClosedTemplatesIfNeeded();
            for (QuteTextDocument document : this.documents.values()) {
                if (document.isOpened()) continue;
                this.validator.triggerValidationFor(document);
            }
        }
    }

    public QuteProjectRegistry getProjectRegistry() {
        return this.projectRegistry;
    }

    public Path getTemplateBaseDir() {
        return this.templateBaseDir;
    }

    public String getTemplateId(Path templateFilePath) {
        if (templateFilePath == null || this.templateBaseDir == null) {
            return null;
        }
        try {
            return this.templateBaseDir.relativize(templateFilePath).toString().replace('\\', '/');
        }
        catch (Exception e) {
            return templateFilePath.getFileName().toString();
        }
    }

    public boolean isTemplateOpened(String templateId) {
        QuteTextDocument document = this.findDocumentByTemplateId(templateId);
        return document != null && document.isOpened();
    }

    public String getUri() {
        return this.uri;
    }

    public List<QuteProject> getProjectDependencies() {
        return this.projectDependencies;
    }

    public List<Parameter> findInsertTagParameter(String templateId, String insertParamater) {
        this.closedDocuments.loadClosedTemplatesIfNeeded();
        QuteTextDocument document = this.findDocumentByTemplateId(templateId);
        if (document != null) {
            return document.findInsertTagParameter(insertParamater);
        }
        return null;
    }

    public List<Section> findSectionsByTag(String tag) {
        this.closedDocuments.loadClosedTemplatesIfNeeded();
        ArrayList<Section> allSections = new ArrayList<Section>();
        for (QuteTextDocument document : this.documents.values()) {
            List<Section> sections = document.findSectionsByTag(tag);
            if (sections == null || sections.isEmpty()) continue;
            allSections.addAll(sections);
        }
        return allSections;
    }

    private QuteTextDocument findDocumentByTemplateId(String templateId) {
        if (templateId.indexOf(46) != -1) {
            return this.documents.get(templateId);
        }
        for (String variant : this.getTemplateVariants()) {
            String id = templateId + variant;
            QuteTextDocument document = this.documents.get(id);
            if (document == null) continue;
            return document;
        }
        return null;
    }

    public void onDidOpenTextDocument(QuteTextDocument document) {
        this.documents.put(document.getTemplateId(), document);
    }

    public void onDidCloseTextDocument(QuteTextDocument document) {
        Path path = FileUtils.createPath(document.getUri());
        this.closedDocuments.onDidCloseTemplate(path);
    }

    public void onDidSaveTextDocument(QuteTextDocument document) {
        UserTag userTag = this.getUserTag(document.getTemplate());
        if (userTag != null) {
            userTag.clear();
        }
    }

    public QuteTextDocument onDidDeleteTemplate(Path templateFilePath) {
        return this.closedDocuments.onDidDeleteTemplate(templateFilePath);
    }

    public QuteTextDocument onDidCreateTemplate(Path templateFilePath) {
        return this.closedDocuments.onDidCreateTemplate(templateFilePath);
    }

    public Collection<QuteTextDocument> getDocuments() {
        this.closedDocuments.loadClosedTemplatesIfNeeded();
        return this.documents.values();
    }

    public CompletableFuture<ResolvedJavaTypeInfo> getResolvedJavaType(String typeName) {
        return this.resolvedJavaTypes.get(typeName);
    }

    void registerResolvedJavaType(String typeName, CompletableFuture<ResolvedJavaTypeInfo> future) {
        this.resolvedJavaTypes.put(typeName, future);
        future.thenApply(c -> {
            if (this.targetAnnotations != null) {
                this.updateTargetAnnotation((ResolvedJavaTypeInfo)c, this.targetAnnotations);
            }
            return c;
        });
    }

    public CompletableFuture<ExtendedDataModelProject> getDataModelProject() {
        if (this.dataModelProjectFuture == null || this.dataModelProjectFuture.isCancelled() || this.dataModelProjectFuture.isCompletedExceptionally()) {
            this.dataModelProjectFuture = null;
            this.dataModelProjectFuture = this.loadDataModelProject();
        }
        return this.dataModelProjectFuture;
    }

    protected synchronized CompletableFuture<ExtendedDataModelProject> loadDataModelProject() {
        if (this.dataModelProjectFuture != null) {
            return this.dataModelProjectFuture;
        }
        QuteDataModelProjectParams params = new QuteDataModelProjectParams();
        params.setProjectUri(this.getUri());
        return ((CompletableFuture)this.getDataModelProject(params).thenApply(project -> {
            if (project == null) {
                return null;
            }
            return new ExtendedDataModelProject((DataModelProject<DataModelTemplate<DataModelParameter>>)project);
        })).thenApply(p -> {
            this.tagRegistry.refreshDataModel();
            return p;
        });
    }

    protected CompletableFuture<DataModelProject<DataModelTemplate<DataModelParameter>>> getDataModelProject(QuteDataModelProjectParams params) {
        return this.projectRegistry.getDataModelProject(params);
    }

    public void resetJavaTypes() {
        if (this.dataModelProjectFuture != null) {
            this.dataModelProjectFuture.cancel(true);
            this.dataModelProjectFuture = null;
        }
        this.resolvedJavaTypes.clear();
        this.targetAnnotations = null;
    }

    public TemplateConfiguration getTemplateConfiguration() {
        return null;
    }

    public Collection<UserTag> getSourceUserTags() {
        return this.tagRegistry.getSourceUserTags();
    }

    public CompletableFuture<List<UserTag>> getBinaryUserTags() {
        return this.tagRegistry.getBinaryUserTags();
    }

    public UserTag findUserTag(String tagName) {
        Collection tags = this.getSourceUserTags();
        for (UserTag userTag : tags) {
            if (!tagName.equals(userTag.getName())) continue;
            return userTag;
        }
        tags = this.getBinaryUserTags().getNow(Collections.emptyList());
        for (UserTag userTag : tags) {
            if (!tagName.equals(userTag.getName())) continue;
            return userTag;
        }
        return null;
    }

    public UserTag getUserTag(Template template) {
        if (!UserTagUtils.isUserTag(template)) {
            return null;
        }
        String templateId = template.getTemplateId();
        int index = templateId.indexOf(46);
        if (index != -1) {
            templateId = templateId.substring(0, index);
        }
        for (UserTag userTag : this.getSourceUserTags()) {
            if (!userTag.getTemplateId().equals(templateId)) continue;
            return userTag;
        }
        return null;
    }

    public void collectUserTagSuggestions(CompletionRequest completionRequest, String prefixFilter, String suffixToFind, Set<CompletionItem> completionItems) {
        this.tagRegistry.collectUserTagSuggestions(completionRequest, prefixFilter, suffixToFind, completionItems);
    }

    public Path getTagsDir() {
        return this.tagRegistry.getTagsDir();
    }

    public JavaTypeAccessibiltyRule getJavaTypeAccessibiltyInNativeMode(String javaTypeName) {
        if (this.getJavaTypesSupportedInNativeMode().contains(javaTypeName)) {
            return JavaTypeAccessibiltyRule.ALLOWED_WITHOUT_RESTRICTION;
        }
        if (this.targetAnnotations == null) {
            this.targetAnnotations = this.loadTargetAnnotations();
        }
        return this.targetAnnotations.get(javaTypeName);
    }

    private synchronized Map<String, JavaTypeAccessibiltyRule> loadTargetAnnotations() {
        if (this.targetAnnotations != null) {
            return this.targetAnnotations;
        }
        HashMap<String, JavaTypeAccessibiltyRule> targetAnnotations = new HashMap<String, JavaTypeAccessibiltyRule>();
        this.resolvedJavaTypes.values().forEach(future -> this.updateTargetAnnotation(future.getNow(null), targetAnnotations));
        return targetAnnotations;
    }

    private void updateTargetAnnotation(ResolvedJavaTypeInfo baseType, Map<String, JavaTypeAccessibiltyRule> targetAnnotations) {
        JavaTypeAccessibiltyRule result;
        if (baseType == null) {
            return;
        }
        if (baseType.getTemplateDataAnnotations() != null && !baseType.getTemplateDataAnnotations().isEmpty()) {
            for (TemplateDataAnnotation templateDataAnnotation : baseType.getTemplateDataAnnotations()) {
                String target = StringUtils.isEmpty(templateDataAnnotation.getTarget()) ? baseType.getName() : templateDataAnnotation.getTarget();
                result = QuteProject.getJavaTypeAccessibiltyRule(target, targetAnnotations);
                result.merge(templateDataAnnotation);
            }
        }
        if (baseType.getRegisterForReflectionAnnotation() != null) {
            List<String> targets = baseType.getRegisterForReflectionAnnotation().getTargets();
            if (targets != null && !targets.isEmpty()) {
                for (String target : targets) {
                    result = QuteProject.getJavaTypeAccessibiltyRule(target, targetAnnotations);
                    result.merge(baseType.getRegisterForReflectionAnnotation());
                }
            } else {
                String string = baseType.getName();
                JavaTypeAccessibiltyRule result2 = QuteProject.getJavaTypeAccessibiltyRule(string, targetAnnotations);
                result2.merge(baseType.getRegisterForReflectionAnnotation());
            }
        }
    }

    private static JavaTypeAccessibiltyRule getJavaTypeAccessibiltyRule(String target, Map<String, JavaTypeAccessibiltyRule> targetAnnotations) {
        return targetAnnotations.computeIfAbsent(target, x -> new JavaTypeAccessibiltyRule());
    }

    public JavaTypeFilter getJavaTypeFilterInNativeMode() {
        return this.filterInNativeMode;
    }

    public Collection<? extends String> getJavaTypesSupportedInNativeMode() {
        ExtendedDataModelProject dataModel = this.getDataModelProject().getNow(null);
        if (dataModel == null) {
            return Collections.emptySet();
        }
        return dataModel.getJavaTypesSupportedInNativeMode();
    }

    public void dispose() {
        if (this.watcher != null) {
            this.watcher.stop();
        }
    }

    public String[] getTemplateVariants() {
        return TEMPLATE_VARIANTS;
    }

    public CompletableFuture<ResolvedJavaTypeInfo> resolveJavaType(Part part) {
        return this.javaCache.resolveJavaType(part);
    }

    CompletableFuture<ResolvedJavaTypeInfo> wrap2(CompletableFuture<ResolvedJavaTypeInfo> future) {
        if (future.isDone()) {
            ResolvedJavaTypeInfo resolvedJavaType2 = future.getNow(null);
            return this.wrap(resolvedJavaType2);
        }
        return future.thenCompose(resolvedJavaType -> this.wrap((ResolvedJavaTypeInfo)resolvedJavaType));
    }

    CompletableFuture<ResolvedJavaTypeInfo> wrap(ResolvedJavaTypeInfo resolvedJavaType) {
        List<JavaParameterInfo> types;
        if (resolvedJavaType != null && resolvedJavaType.isWrapperType() && (types = resolvedJavaType.getTypeParameters()) != null && !types.isEmpty()) {
            JavaParameterInfo type = types.get(0);
            String javaTypeToResolve = type.getType();
            return this.resolveJavaType(javaTypeToResolve);
        }
        return CompletableFuture.completedFuture(resolvedJavaType);
    }

    public ResolvedJavaTypeInfo resolveJavaTypeSync(String className) {
        return this.resolveJavaType(className).getNow(QuteCompletableFutures.RESOLVING_JAVA_TYPE);
    }

    public CompletableFuture<ResolvedJavaTypeInfo> resolveJavaType(String className) {
        return this.javaCache.resolveJavaType(className);
    }

    public CompletableFuture<ResolvedJavaTypeInfo> resolveJavaType(String className, boolean wrap) {
        return this.javaCache.resolveJavaType(className, wrap);
    }

    public ResolvedJavaTypeInfo resolveJavaTypeSync(Parameter parameter) {
        return this.resolveJavaType(parameter).getNow(QuteCompletableFutures.RESOLVING_JAVA_TYPE);
    }

    public CompletableFuture<ResolvedJavaTypeInfo> resolveJavaType(Parameter parameter) {
        return this.javaCache.resolveJavaType(parameter);
    }

    public InvalidMethodReason getInvalidMethodReason(String property, ResolvedJavaTypeInfo resolvedType) {
        if (resolvedType == null) {
            return InvalidMethodReason.Unknown;
        }
        InvalidMethodReason reason = resolvedType.getInvalidMethodReason(property);
        if (reason != null) {
            return reason;
        }
        if (resolvedType.getExtendedTypes() != null) {
            for (String extendedType : resolvedType.getExtendedTypes()) {
                ResolvedJavaTypeInfo resolvedExtendedType = this.resolveJavaTypeSync(extendedType);
                if (QuteCompletableFutures.isResolvingJavaTypeOrNull(resolvedExtendedType) || (reason = resolvedExtendedType.getInvalidMethodReason(property)) == null) continue;
                return reason;
            }
        }
        return null;
    }

    public JavaMemberResult findProperty(Part part, ResolvedJavaTypeInfo baseType, boolean nativeMode) {
        return this.findProperty(baseType, part.getPartName(), nativeMode);
    }

    private JavaMemberResult findProperty(ResolvedJavaTypeInfo baseType, String property, boolean nativeMode) {
        JavaMemberResult result = new JavaMemberResult();
        if (!nativeMode) {
            JavaMemberInfo member = this.findPropertyWithJavaReflection(baseType, property);
            if (member != null) {
                result.setMember(member);
                return result;
            }
            member = this.findValueResolver(baseType, property);
            if (member != null) {
                result.setMember(member);
            }
            return result;
        }
        JavaMemberInfo member = this.findValueResolver(baseType, property);
        if (member != null) {
            result.setMember(member);
            return result;
        }
        member = this.findPropertyWithJavaReflection(baseType, property);
        if (member != null) {
            result.setMember(member);
            return result;
        }
        return result;
    }

    private JavaMemberInfo findPropertyWithJavaReflection(ResolvedJavaTypeInfo baseType, String property) {
        return this.findPropertyWithJavaReflection(baseType, property, new HashSet<ResolvedJavaTypeInfo>());
    }

    private JavaMemberInfo findPropertyWithJavaReflection(ResolvedJavaTypeInfo baseType, String property, Set<ResolvedJavaTypeInfo> visited) {
        if (visited.contains(baseType)) {
            return null;
        }
        visited.add(baseType);
        String getterMethodName = QuteProject.computeGetterName(property);
        String booleanGetterName = QuteProject.computeBooleanGetterName(property);
        JavaMemberInfo memberInfo = this.findMember(baseType, property, getterMethodName, booleanGetterName);
        if (memberInfo != null) {
            return memberInfo;
        }
        if (baseType.getExtendedTypes() != null) {
            for (String superType : baseType.getExtendedTypes()) {
                JavaMemberInfo superMemberInfo;
                ResolvedJavaTypeInfo resolvedSuperType = this.resolveJavaTypeSync(superType);
                if (QuteCompletableFutures.isResolvingJavaTypeOrNull(resolvedSuperType) || (superMemberInfo = this.findPropertyWithJavaReflection(resolvedSuperType, property, visited)) == null) continue;
                return superMemberInfo;
            }
        }
        return null;
    }

    private JavaMemberInfo findMember(ResolvedJavaTypeInfo resolvedType, String propertyOrMethodName, String getterMethodName, String booleanGetterName) {
        JavaFieldInfo fieldInfo = QuteProject.findField(resolvedType, propertyOrMethodName);
        if (fieldInfo != null) {
            return fieldInfo;
        }
        return QuteProject.findMethod(resolvedType, propertyOrMethodName, getterMethodName, booleanGetterName);
    }

    protected static JavaFieldInfo findField(ResolvedJavaTypeInfo baseType, String fieldName) {
        List<JavaFieldInfo> fields = baseType.getFields();
        if (fields == null || fields.isEmpty() || QuteProject.isEmpty(fieldName)) {
            return null;
        }
        for (JavaFieldInfo field : fields) {
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    protected static JavaMethodInfo findMethod(ResolvedJavaTypeInfo baseType, String methodName, String getterMethodName, String booleanGetterName) {
        List<JavaMethodInfo> methods = baseType.getMethods();
        if (methods == null || methods.isEmpty() || QuteProject.isEmpty(methodName)) {
            return null;
        }
        for (JavaMethodInfo method : methods) {
            if (!QuteProject.isMatchMethod(method, methodName, getterMethodName, booleanGetterName)) continue;
            return method;
        }
        return null;
    }

    public JavaMemberResult findMethod(ResolvedJavaTypeInfo baseType, String namespace, String methodName, List<ResolvedJavaTypeInfo> parameterTypes, boolean nativeMode) {
        JavaMemberResult result = new JavaMemberResult();
        if (!nativeMode && baseType != null && this.findMethod(baseType, methodName, parameterTypes, result)) {
            return result;
        }
        List dynamicResolvers = this.getMethodValueResolvers().getNow(null);
        if (this.findMethodResolver(baseType, namespace, methodName, parameterTypes, dynamicResolvers, result)) {
            return result;
        }
        if (baseType != null) {
            List<MethodValueResolver> staticResolvers = this.projectRegistry.getCommmonsResolvers();
            if (this.findMethodResolver(baseType, null, methodName, parameterTypes, staticResolvers, result)) {
                return result;
            }
            if (nativeMode && this.findMethod(baseType, methodName, parameterTypes, result)) {
                return result;
            }
        }
        return result;
    }

    private boolean findMethod(ResolvedJavaTypeInfo baseType, String methodName, List<ResolvedJavaTypeInfo> parameterTypes, JavaMemberResult result) {
        return this.findMethod(baseType, methodName, parameterTypes, result, new HashSet<ResolvedJavaTypeInfo>());
    }

    private boolean findMethod(ResolvedJavaTypeInfo baseType, String methodName, List<ResolvedJavaTypeInfo> parameterTypes, JavaMemberResult result, Set<ResolvedJavaTypeInfo> visited) {
        if (visited.contains(baseType)) {
            return false;
        }
        visited.add(baseType);
        if (QuteProject.isEmpty(methodName)) {
            return false;
        }
        List<JavaMethodInfo> methods = baseType.getMethods();
        if (methods != null && !methods.isEmpty()) {
            for (JavaMethodInfo method : methods) {
                if (!QuteProject.isMatchMethod(method, methodName, null, null)) continue;
                boolean matchParameters = this.isMatchParameters(method, parameterTypes);
                if (result.getMember() == null || matchParameters) {
                    result.setMember(method);
                    result.setMatchParameters(matchParameters);
                    result.setMatchVirtualMethod(true);
                }
                if (!matchParameters) continue;
                return true;
            }
        }
        if (baseType.getExtendedTypes() != null) {
            for (String superType : baseType.getExtendedTypes()) {
                ResolvedJavaTypeInfo resolvedSuperType = this.resolveJavaTypeSync(superType);
                if (QuteCompletableFutures.isResolvingJavaTypeOrNull(resolvedSuperType) || !this.findMethod(resolvedSuperType, methodName, parameterTypes, result, visited)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean findMethodResolver(ResolvedJavaTypeInfo baseType, String namespace, String methodName, List<ResolvedJavaTypeInfo> parameterTypes, List<MethodValueResolver> resolvers, JavaMemberResult result) {
        if (resolvers == null) {
            return false;
        }
        for (MethodValueResolver resolver : resolvers) {
            if (!QuteProject.isMatchMethod(resolver, methodName, null, null)) continue;
            if (namespace != null) {
                if (!namespace.equals(resolver.getNamespace())) continue;
                result.setMember(resolver);
                result.setMatchVirtualMethod(true);
                boolean matchParameters = this.isMatchParameters(resolver, parameterTypes);
                result.setMatchParameters(matchParameters);
                return true;
            }
            if (baseType == null) {
                return false;
            }
            boolean matchVirtualMethod = this.matchResolver(baseType, resolver);
            boolean matchParameters = false;
            if (matchVirtualMethod) {
                matchParameters = this.isMatchParameters(resolver, parameterTypes);
            }
            if (result.getMember() == null || matchParameters && matchVirtualMethod) {
                result.setMember(resolver);
                result.setMatchParameters(matchParameters);
                result.setMatchVirtualMethod(matchVirtualMethod);
            }
            if (!matchParameters || !matchVirtualMethod) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchParameters(JavaMethodInfo method, List<ResolvedJavaTypeInfo> parameterTypes) {
        int i;
        boolean varargs;
        boolean virtualMethod = method.isVirtual();
        int nbParameters = method.getParameterslength();
        int declaredNbParameters = parameterTypes.size();
        JavaParameterInfo lastParameter = method.hasParameters() ? method.getParameterAt(method.getParameters().size() - 1) : null;
        boolean bl = varargs = lastParameter != null && lastParameter.isVarargs();
        if (varargs) {
            if (declaredNbParameters == 0 && parameterTypes.isEmpty()) {
                return true;
            }
            if (declaredNbParameters < nbParameters) {
                return false;
            }
        } else if (declaredNbParameters != nbParameters) {
            boolean valid = false;
            if (method.getJaxRsMethodKind() != null) {
                int nbRequiredParameters = 0;
                int nbOptionalParameters = 0;
                for (int i2 = 0; i2 < nbParameters - (varargs ? 1 : 0); ++i2) {
                    JavaParameterInfo parameterInfo = method.getParameters().get(i2);
                    RestParam restParam = method.getRestParameter(parameterInfo.getName());
                    if (restParam == null) continue;
                    if (restParam.getParameterKind() == JaxRsParamKind.PATH) {
                        ++nbRequiredParameters;
                        continue;
                    }
                    if (restParam.getParameterKind() != JaxRsParamKind.QUERY) continue;
                    ++nbOptionalParameters;
                }
                if (declaredNbParameters < nbRequiredParameters) {
                    return false;
                }
                if (declaredNbParameters > nbRequiredParameters + nbOptionalParameters) {
                    return false;
                }
                nbParameters = declaredNbParameters;
                valid = true;
            }
            if (!valid) {
                return false;
            }
        }
        for (i = 0; i < nbParameters - (varargs ? 1 : 0); ++i) {
            String parameterType;
            JavaParameterInfo parameterInfo = method.getParameters().get(i + (virtualMethod ? 1 : 0));
            ResolvedJavaTypeInfo result = parameterTypes.get(i);
            if (result == null || this.isMatchType(result, parameterType = parameterInfo.getType())) continue;
            return false;
        }
        if (varargs) {
            for (i = nbParameters - 1; i < declaredNbParameters; ++i) {
                String parameterType = lastParameter.getVarArgType();
                ResolvedJavaTypeInfo result = parameterTypes.get(i);
                if (result == null || this.isMatchType(result, parameterType)) continue;
                return false;
            }
        }
        return true;
    }

    protected static String computeGetterName(String propertyOrMethodName) {
        return "get" + ("" + propertyOrMethodName.charAt(0)).toUpperCase() + propertyOrMethodName.substring(1, propertyOrMethodName.length());
    }

    protected static String computeBooleanGetterName(String propertyOrMethodName) {
        return "is" + ("" + propertyOrMethodName.charAt(0)).toUpperCase() + propertyOrMethodName.substring(1, propertyOrMethodName.length());
    }

    private static boolean isMatchMethod(JavaMethodInfo method, String propertyOrMethodName) {
        String getterMethodName = QuteProject.computeGetterName(propertyOrMethodName);
        String booleanGetterName = QuteProject.computeBooleanGetterName(propertyOrMethodName);
        return QuteProject.isMatchMethod(method, propertyOrMethodName, getterMethodName, booleanGetterName);
    }

    private static boolean isMatchMethod(JavaMethodInfo method, String propertyOrMethodName, String getterMethodName, String booleanGetterName) {
        String methodName = method.getMethodName();
        return propertyOrMethodName.equals(methodName) || getterMethodName != null && getterMethodName.equals(methodName) || booleanGetterName != null && booleanGetterName.equals(methodName);
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public MethodValueResolver findValueResolver(ResolvedJavaTypeInfo baseType, String property) {
        String literalType = LiteralSupport.getLiteralJavaType((String)property);
        if (literalType != null) {
            property = "@" + literalType;
        }
        List<MethodValueResolver> resolvers = this.getResolversFor(baseType);
        for (MethodValueResolver resolver : resolvers) {
            if (!QuteProject.isMatchMethod(resolver, (String)property)) continue;
            return resolver;
        }
        return null;
    }

    public List<MethodValueResolver> getResolversFor(ResolvedJavaTypeInfo javaType) {
        ArrayList<MethodValueResolver> matches = new ArrayList<MethodValueResolver>();
        for (MethodValueResolver resolver : this.projectRegistry.getCommmonsResolvers()) {
            if (!this.matchResolver(javaType, resolver)) continue;
            matches.add(resolver);
        }
        List allResolvers = this.getMethodValueResolvers().getNow(null);
        if (allResolvers != null) {
            for (MethodValueResolver resolver : allResolvers) {
                if (resolver.getNamespace() != null || !this.matchResolver(javaType, resolver)) continue;
                matches.add(resolver);
            }
        }
        return matches;
    }

    private boolean matchResolver(ResolvedJavaTypeInfo javaType, MethodValueResolver resolver) {
        JavaParameterInfo parameter = resolver.getParameterAt(0);
        if (parameter == null) {
            return false;
        }
        if (parameter.getJavaType().isSingleGenericType()) {
            return javaType.isArray() == parameter.getJavaType().isArray();
        }
        String parameterType = parameter.getJavaType().getName();
        return this.isMatchType(javaType, parameterType);
    }

    private boolean isMatchType(ResolvedJavaTypeInfo javaType, String parameterType) {
        return this.isMatchType(javaType, parameterType, new HashSet<ResolvedJavaTypeInfo>());
    }

    private boolean isMatchType(ResolvedJavaTypeInfo javaType, String parameterType, Set<ResolvedJavaTypeInfo> visited) {
        ResolvedJavaTypeInfo result;
        if (visited.contains(javaType)) {
            return false;
        }
        visited.add(javaType);
        String resolvedTypeName = javaType.getName();
        if ("java.lang.Object".equals(parameterType)) {
            return true;
        }
        if (JavaDataModelCache.isSameType(parameterType, resolvedTypeName)) {
            return true;
        }
        if (javaType.getExtendedTypes() != null) {
            for (String superType : javaType.getExtendedTypes()) {
                if (JavaDataModelCache.isSameType(parameterType, superType)) {
                    return true;
                }
                ResolvedJavaTypeInfo resolvedSuperType = this.resolveJavaTypeSync(superType);
                if (QuteCompletableFutures.isResolvingJavaTypeOrNull(resolvedSuperType) || !this.isMatchType(resolvedSuperType, parameterType, visited)) continue;
                return true;
            }
        }
        if (!javaType.getTypeParameters().isEmpty() && !QuteCompletableFutures.isResolvingJavaTypeOrNull(result = this.resolveJavaTypeSync(resolvedTypeName)) && result.getExtendedTypes() != null) {
            for (String superType : result.getExtendedTypes()) {
                if (!JavaDataModelCache.isSameType(parameterType, superType)) continue;
                return true;
            }
        }
        return false;
    }

    private CompletableFuture<List<MethodValueResolver>> getMethodValueResolvers() {
        return this.getDataModelProject().thenApply(dataModel -> {
            if (dataModel == null) {
                return null;
            }
            return dataModel.getMethodValueResolvers();
        });
    }

    public JavaMemberInfo findMember(ResolvedJavaTypeInfo baseType, String property) {
        if (baseType == null) {
            return null;
        }
        JavaMemberInfo member = this.findPropertyWithJavaReflection(baseType, property);
        if (member != null) {
            return member;
        }
        return this.findValueResolver(baseType, property);
    }

    public boolean hasNamespace(String namespace) {
        return this.getAllNamespaces().contains(namespace);
    }

    public Set<String> getAllNamespaces() {
        ExtendedDataModelProject dataModel = this.getDataModelProject().getNow(null);
        return dataModel != null ? dataModel.getAllNamespaces() : Collections.emptySet();
    }

    public CompletableFuture<JavaElementInfo> findJavaElementWithNamespace(String namespace, String partName) {
        return this.getDataModelProject().thenApply(dataModel -> {
            if (dataModel == null) {
                return null;
            }
            List<TypeValueResolver> typeResolvers = dataModel.getTypeValueResolvers();
            for (TypeValueResolver typeValueResolver : typeResolvers) {
                if (!QuteProject.isMatchNamespaceResolver(namespace, partName, typeValueResolver, dataModel)) continue;
                return typeValueResolver;
            }
            List<MethodValueResolver> methodResolvers = dataModel.getMethodValueResolvers();
            for (MethodValueResolver resolver : methodResolvers) {
                if (!QuteProject.isMatchNamespaceResolver(namespace, partName, resolver, dataModel)) continue;
                return resolver;
            }
            List<FieldValueResolver> list = dataModel.getFieldValueResolvers();
            for (FieldValueResolver resolver : list) {
                if (!QuteProject.isMatchNamespaceResolver(namespace, partName, resolver, dataModel)) continue;
                return resolver;
            }
            return null;
        });
    }

    public CompletableFuture<JavaElementInfo> findGlobalVariableJavaElement(String partName) {
        return this.getDataModelProject().thenApply(dataModel -> {
            if (dataModel == null) {
                return null;
            }
            List<TypeValueResolver> typeResolvers = dataModel.getTypeValueResolvers();
            for (TypeValueResolver typeValueResolver : typeResolvers) {
                if (!QuteProject.isMatchGlobalVariableResolver(partName, typeValueResolver, dataModel)) continue;
                return typeValueResolver;
            }
            List<MethodValueResolver> methodResolvers = dataModel.getMethodValueResolvers();
            for (MethodValueResolver resolver : methodResolvers) {
                if (!QuteProject.isMatchGlobalVariableResolver(partName, resolver, dataModel)) continue;
                return resolver;
            }
            List<FieldValueResolver> list = dataModel.getFieldValueResolvers();
            for (FieldValueResolver resolver : list) {
                if (!QuteProject.isMatchGlobalVariableResolver(partName, resolver, dataModel)) continue;
                return resolver;
            }
            return null;
        });
    }

    public CompletableFuture<MessageValueResolver> findMessageValueResolver(String namespace, String methodName) {
        return this.getDataModelProject().thenApply(dataModel -> {
            if (dataModel == null) {
                return null;
            }
            List<MethodValueResolver> methodResolvers = dataModel.getMethodValueResolvers();
            for (MethodValueResolver resolver : methodResolvers) {
                if (resolver.getKind() != ValueResolverKind.Message || !QuteProject.isMatchNamespaceResolver(namespace, methodName, resolver, dataModel)) continue;
                return (MessageValueResolver)resolver;
            }
            return null;
        });
    }

    private static boolean isMatchNamespaceResolver(String namespace, String partName, ValueResolver resolver, ExtendedDataModelProject dataModel) {
        String name = QuteProject.getResolverName(resolver);
        return dataModel.getSimilarNamespace(namespace).equals(resolver.getNamespace()) && ("*".equals(name) || partName.equals(name));
    }

    private static boolean isMatchGlobalVariableResolver(String partName, ValueResolver resolver, ExtendedDataModelProject dataModel) {
        String name = QuteProject.getResolverName(resolver);
        return resolver.isGlobalVariable() && partName.equals(name);
    }

    private static String getResolverName(ValueResolver resolver) {
        if (resolver.getNamed() != null) {
            return resolver.getNamed();
        }
        if (resolver.getMatchName() != null) {
            return resolver.getMatchName();
        }
        return resolver.getName();
    }

    public CompletableFuture<NamespaceResolverInfo> getNamespaceResolverInfo(String namespace) {
        return this.getDataModelProject().thenApply(dataModel -> {
            if (dataModel == null) {
                return null;
            }
            return dataModel.getNamespaceResolver(namespace);
        });
    }

    public CompletableFuture<List<ValueResolver>> getGlobalVariables() {
        return this.getDataModelProject().thenApply(dataModel -> {
            if (dataModel == null) {
                return null;
            }
            ArrayList<ValueResolver> globalVariables = new ArrayList<ValueResolver>();
            for (ValueResolver valueResolver : dataModel.getTypeValueResolvers()) {
                if (!valueResolver.isGlobalVariable()) continue;
                globalVariables.add(valueResolver);
            }
            for (ValueResolver valueResolver : dataModel.getMethodValueResolvers()) {
                if (!valueResolver.isGlobalVariable()) continue;
                globalVariables.add(valueResolver);
            }
            for (ValueResolver valueResolver : dataModel.getFieldValueResolvers()) {
                if (!valueResolver.isGlobalVariable()) continue;
                globalVariables.add(valueResolver);
            }
            return globalVariables;
        });
    }

    public CompletableFuture<List<MessageValueResolver>> getMessageValueResolvers() {
        return this.getDataModelProject().thenApply(dataModel -> {
            if (dataModel == null) {
                return null;
            }
            ArrayList<MessageValueResolver> messages = new ArrayList<MessageValueResolver>();
            for (ValueResolver valueResolver : dataModel.getMethodValueResolvers()) {
                if (valueResolver.getKind() != ValueResolverKind.Message) continue;
                messages.add((MessageValueResolver)valueResolver);
            }
            return messages;
        });
    }

    public CompletableFuture<ExtendedDataModelTemplate> getDataModelTemplate(Template template) {
        String templateUri = template.getUri();
        return this.getDataModelProject().thenApply(dataModel -> {
            if (dataModel == null) {
                return null;
            }
            return (ExtendedDataModelTemplate)dataModel.findDataModelTemplate(templateUri);
        });
    }

    public List<ValueResolver> getNamespaceResolvers(String namespace) {
        List<FieldValueResolver> list;
        List<MethodValueResolver> allMethodResolvers;
        ExtendedDataModelProject dataModel = this.getDataModelProject().getNow(null);
        if (dataModel == null) {
            return Collections.emptyList();
        }
        ArrayList<ValueResolver> namespaceResolvers = new ArrayList<ValueResolver>();
        List<TypeValueResolver> allTypeResolvers = dataModel.getTypeValueResolvers();
        if (allTypeResolvers != null) {
            for (ValueResolver valueResolver : allTypeResolvers) {
                if (!QuteProject.isMatchNamespace(valueResolver, namespace, dataModel)) continue;
                namespaceResolvers.add(valueResolver);
            }
        }
        if ((allMethodResolvers = dataModel.getMethodValueResolvers()) != null) {
            for (ValueResolver valueResolver : allMethodResolvers) {
                if (!QuteProject.isMatchNamespace(valueResolver, namespace, dataModel)) continue;
                namespaceResolvers.add(valueResolver);
            }
        }
        if ((list = dataModel.getFieldValueResolvers()) != null) {
            for (ValueResolver valueResolver : list) {
                if (!QuteProject.isMatchNamespace(valueResolver, namespace, dataModel)) continue;
                namespaceResolvers.add(valueResolver);
            }
        }
        return namespaceResolvers;
    }

    private static boolean isMatchNamespace(ValueResolver resolver, String namespace, ExtendedDataModelProject dataModel) {
        if (resolver.getNamespace() == null) {
            return false;
        }
        return namespace == null || dataModel.getSimilarNamespace(namespace).equals(resolver.getNamespace());
    }

    public Set<String> getAllTemplateExtensionsClasses() {
        ExtendedDataModelProject dataModel = this.getDataModelProject().getNow(null);
        return dataModel != null ? dataModel.getAllTemplateExtensionsClasses() : Collections.emptySet();
    }

    public CompletableFuture<String> getJavadoc(JavaMemberInfo javaMemberInfo, JavaTypeInfo javaTypeInfo, boolean hasMarkdown) {
        String typeName = javaMemberInfo.getJavaTypeInfo() != null ? javaMemberInfo.getJavaTypeInfo().getName() : javaTypeInfo.getName();
        String signature = javaMemberInfo.getGenericMember() == null ? javaMemberInfo.getSignature() : javaMemberInfo.getGenericMember().getSignature();
        return this.projectRegistry.getJavadoc(new QuteJavadocParams(typeName, this.getUri(), javaMemberInfo.getName(), signature, hasMarkdown ? DocumentFormat.Markdown : DocumentFormat.PlainText));
    }
}

