/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project;

import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.WatchDir;
import com.redhat.qute.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.Arrays;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;

public class QuteProjectFilesWatcher
extends WatchDir {
    private QuteProject project;
    private final Thread thread;

    public QuteProjectFilesWatcher(QuteProject project) throws IOException {
        super(project.getTemplateBaseDir(), true);
        this.project = project;
        this.thread = new Thread(this);
        this.thread.setName("Watch Qute templates for '" + project.getUri() + "'");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    protected void notifyListeners(WatchEvent<?> event, Path child) {
        if (Files.isDirectory(child, new LinkOption[0])) {
            return;
        }
        FileEvent fileEvent = null;
        String fileUri = FileUtils.toUri(child);
        if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
            fileEvent = new FileEvent(fileUri, FileChangeType.Created);
        } else if (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
            fileEvent = new FileEvent(fileUri, FileChangeType.Changed);
        } else if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
            fileEvent = new FileEvent(fileUri, FileChangeType.Deleted);
        }
        if (fileEvent != null) {
            DidChangeWatchedFilesParams params = new DidChangeWatchedFilesParams(Arrays.asList(fileEvent));
            this.project.getProjectRegistry().didChangeWatchedFiles(params);
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.thread.interrupt();
    }
}

