/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project;

import com.redhat.qute.commons.JavaTypeInfo;
import com.redhat.qute.commons.ProjectInfo;
import com.redhat.qute.commons.QuteJavaDefinitionParams;
import com.redhat.qute.commons.QuteJavaTypesParams;
import com.redhat.qute.commons.QuteJavadocParams;
import com.redhat.qute.commons.QuteProjectParams;
import com.redhat.qute.commons.QuteResolvedJavaTypeParams;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.commons.datamodel.DataModelProject;
import com.redhat.qute.commons.datamodel.DataModelTemplate;
import com.redhat.qute.commons.datamodel.JavaDataModelChangeEvent;
import com.redhat.qute.commons.datamodel.QuteDataModelProjectParams;
import com.redhat.qute.commons.usertags.QuteUserTagParams;
import com.redhat.qute.commons.usertags.UserTagInfo;
import com.redhat.qute.ls.api.QuteDataModelProjectProvider;
import com.redhat.qute.ls.api.QuteJavaDefinitionProvider;
import com.redhat.qute.ls.api.QuteJavaTypesProvider;
import com.redhat.qute.ls.api.QuteJavadocProvider;
import com.redhat.qute.ls.api.QuteProjectInfoProvider;
import com.redhat.qute.ls.api.QuteResolvedJavaTypeProvider;
import com.redhat.qute.ls.api.QuteUserTagProvider;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.ProgressSupport;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteTextDocument;
import com.redhat.qute.project.datamodel.ExtendedDataModelTemplate;
import com.redhat.qute.project.datamodel.resolvers.MethodValueResolver;
import com.redhat.qute.project.datamodel.resolvers.ValueResolversRegistry;
import com.redhat.qute.project.documents.QuteOpenedTextDocument;
import com.redhat.qute.project.documents.TemplateValidator;
import com.redhat.qute.services.QuteCompletableFutures;
import com.redhat.qute.services.nativemode.JavaTypeFilter;
import com.redhat.qute.services.nativemode.ReflectionJavaTypeFilter;
import com.redhat.qute.settings.QuteNativeSettings;
import com.redhat.qute.utils.FileUtils;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.WorkDoneProgressBegin;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkDoneProgressEnd;
import org.eclipse.lsp4j.WorkDoneProgressNotification;
import org.eclipse.lsp4j.WorkDoneProgressReport;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class QuteProjectRegistry
implements QuteDataModelProjectProvider,
QuteUserTagProvider,
QuteJavadocProvider {
    private final ValueResolversRegistry valueResolversRegistry;
    private final Map<String, QuteProject> projects;
    private final QuteProjectInfoProvider projectInfoProvider;
    private final QuteResolvedJavaTypeProvider resolvedTypeProvider;
    private final QuteDataModelProjectProvider dataModelProvider;
    private final QuteUserTagProvider userTagProvider;
    private final QuteJavaTypesProvider javaTypeProvider;
    private final QuteJavaDefinitionProvider definitionProvider;
    private final QuteJavadocProvider javadocProvider;
    private final TemplateValidator validator;
    private final Supplier<ProgressSupport> progressSupportProvider;
    private boolean didChangeWatchedFilesSupported;

    public QuteProjectRegistry(QuteProjectInfoProvider projectInfoProvider, QuteJavaTypesProvider javaTypeProvider, QuteJavaDefinitionProvider definitionProvider, QuteResolvedJavaTypeProvider resolvedClassProvider, QuteDataModelProjectProvider dataModelProvider, QuteUserTagProvider userTagsProvider, QuteJavadocProvider javadocProvider, TemplateValidator validator, Supplier<ProgressSupport> progressSupportProvider) {
        this.projectInfoProvider = projectInfoProvider;
        this.javaTypeProvider = javaTypeProvider;
        this.definitionProvider = definitionProvider;
        this.projects = new HashMap<String, QuteProject>();
        this.resolvedTypeProvider = resolvedClassProvider;
        this.dataModelProvider = dataModelProvider;
        this.userTagProvider = userTagsProvider;
        this.javadocProvider = javadocProvider;
        this.valueResolversRegistry = new ValueResolversRegistry();
        this.validator = validator;
        this.progressSupportProvider = progressSupportProvider;
    }

    public void setDidChangeWatchedFilesSupported(boolean didChangeWatchedFilesSupported) {
        this.didChangeWatchedFilesSupported = didChangeWatchedFilesSupported;
    }

    public boolean isDidChangeWatchedFilesSupported() {
        return this.didChangeWatchedFilesSupported;
    }

    public QuteProject getProject(String projectUri) {
        return this.projects.get(projectUri);
    }

    public QuteProject getProject(ProjectInfo projectInfo) {
        return this.getProject(projectInfo, true);
    }

    private QuteProject getProject(ProjectInfo projectInfo, boolean validateOnLoad) {
        String projectUri = projectInfo.getUri();
        QuteProject project = this.getProject(projectUri);
        if (project == null) {
            project = this.registerProjectSync(projectInfo);
            if (this.validator != null && validateOnLoad) {
                QuteProject newProject = project;
                CompletableFuture.runAsync(() -> newProject.validateClosedTemplates());
            }
        }
        return project;
    }

    private synchronized QuteProject registerProjectSync(ProjectInfo projectInfo) {
        String projectUri = projectInfo.getUri();
        QuteProject project = this.getProject(projectUri);
        if (project != null) {
            return project;
        }
        project = this.createProject(projectInfo);
        this.registerProject(project);
        return project;
    }

    protected QuteProject createProject(ProjectInfo projectInfo) {
        return new QuteProject(projectInfo, this, this.validator);
    }

    protected void registerProject(QuteProject project) {
        this.projects.put(project.getUri(), project);
    }

    public void onDidOpenTextDocument(QuteTextDocument document) {
        QuteProject project = document.getProject();
        if (project != null) {
            project.onDidOpenTextDocument(document);
        }
    }

    public void onDidCloseTextDocument(QuteTextDocument document) {
        QuteProject project = document.getProject();
        if (project != null) {
            project.onDidCloseTextDocument(document);
        }
    }

    public void onDidSaveTextDocument(QuteOpenedTextDocument document) {
        QuteProject project = document.getProject();
        if (project != null) {
            project.onDidSaveTextDocument(document);
        }
    }

    protected CompletableFuture<ResolvedJavaTypeInfo> getResolvedJavaType(QuteResolvedJavaTypeParams params) {
        return this.resolvedTypeProvider.getResolvedJavaType(params);
    }

    public void dataModelChanged(JavaDataModelChangeEvent event) {
        Set<String> projectUris = event.getProjectURIs();
        for (String projectUri : projectUris) {
            QuteProject project = this.getProject(projectUri);
            if (project == null) continue;
            project.resetJavaTypes();
        }
    }

    public CompletableFuture<ExtendedDataModelTemplate> getDataModelTemplate(Template template) {
        QuteProject existingProject = template.getProject();
        if (existingProject == null) {
            return template.getProjectFuture().thenCompose(projectInfo -> {
                if (projectInfo == null) {
                    return QuteCompletableFutures.EXTENDED_TEMPLATE_DATAMODEL_NULL_FUTURE;
                }
                QuteProject project = this.getProject((ProjectInfo)projectInfo);
                return project.getDataModelTemplate(template);
            });
        }
        return existingProject.getDataModelTemplate(template);
    }

    public CompletableFuture<List<JavaTypeInfo>> getJavaTypes(QuteJavaTypesParams params) {
        return this.javaTypeProvider.getJavaTypes(params);
    }

    public CompletableFuture<Location> getJavaDefinition(QuteJavaDefinitionParams params) {
        return this.definitionProvider.getJavaDefinition(params);
    }

    @Override
    public CompletableFuture<DataModelProject<DataModelTemplate<DataModelParameter>>> getDataModelProject(QuteDataModelProjectParams params) {
        return this.dataModelProvider.getDataModelProject(params);
    }

    @Override
    public CompletableFuture<List<UserTagInfo>> getUserTags(QuteUserTagParams params) {
        return this.userTagProvider.getUserTags(params);
    }

    List<MethodValueResolver> getCommmonsResolvers() {
        return this.valueResolversRegistry.getResolvers();
    }

    public JavaTypeFilter getJavaTypeFilter(String projectUri, QuteNativeSettings nativeImagesSettings) {
        QuteProject project;
        if (nativeImagesSettings != null && nativeImagesSettings.isEnabled() && projectUri != null && (project = this.getProject(projectUri)) != null) {
            return project.getJavaTypeFilterInNativeMode();
        }
        return ReflectionJavaTypeFilter.INSTANCE;
    }

    @Override
    public CompletableFuture<String> getJavadoc(QuteJavadocParams params) {
        return this.javadocProvider.getJavadoc(params);
    }

    private QuteProject findProjectFor(Path path) {
        for (QuteProject project : this.projects.values()) {
            if (!QuteProjectRegistry.isBelongToProject(path, project)) continue;
            return project;
        }
        return null;
    }

    private static boolean isBelongToProject(Path path, QuteProject project) {
        return path.startsWith(project.getTemplateBaseDir());
    }

    public Collection<QuteProject> getProjects() {
        return this.projects.values();
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        HashSet<QuteProject> projects = new HashSet<QuteProject>();
        List changes = params.getChanges();
        for (FileEvent fileEvent : changes) {
            String fileUri = fileEvent.getUri();
            Path templatePath = FileUtils.createPath(fileUri);
            QuteProject project = this.findProjectFor(templatePath);
            if (project == null) continue;
            String templateId = project.getTemplateId(templatePath);
            if (project.isTemplateOpened(templateId)) {
                projects.add(project);
                continue;
            }
            switch (fileEvent.getType()) {
                case Changed: 
                case Created: {
                    QuteTextDocument closedTemplate = project.onDidCreateTemplate(templatePath);
                    if (closedTemplate == null) break;
                    projects.add(closedTemplate.getProject());
                    break;
                }
                case Deleted: {
                    QuteTextDocument closedTemplate = project.onDidDeleteTemplate(templatePath);
                    if (closedTemplate == null) break;
                    projects.add(closedTemplate.getProject());
                    if (this.validator == null) break;
                    this.validator.clearDiagnosticsFor(fileUri);
                    break;
                }
            }
        }
        if (projects.isEmpty()) {
            return;
        }
        if (this.validator != null) {
            this.validator.triggerValidationFor(projects);
        }
    }

    public void dispose() {
        for (QuteProject project : this.projects.values()) {
            project.dispose();
        }
    }

    public CompletableFuture<ProjectInfo> getProjectInfo(QuteProjectParams params) {
        return this.projectInfoProvider.getProjectInfo(params);
    }

    public void loadQuteProjects(Collection<ProjectInfo> projects) {
        for (ProjectInfo projectInfo : projects) {
            this.loadQuteProject(projectInfo);
        }
        for (ProjectInfo projectInfo : projects) {
            if (projectInfo.getProjectDependencyUris() == null || projectInfo.getProjectDependencyUris().isEmpty()) continue;
            QuteProject project = this.getProject(projectInfo.getUri());
            for (String projectDependencyUri : projectInfo.getProjectDependencyUris()) {
                QuteProject projectDependency = this.getProject(projectDependencyUri);
                if (projectDependency == null) continue;
                project.getProjectDependencies().add(projectDependency);
            }
        }
    }

    private QuteProject loadQuteProject(ProjectInfo projectInfo) {
        ProgressSupport progressSupport = this.progressSupportProvider.get();
        String projectName = projectInfo.getUri();
        String progressId = QuteProjectRegistry.createAndStartProgress(projectName, progressSupport);
        QuteProject project = this.getProject(projectInfo, false);
        if (progressSupport != null) {
            WorkDoneProgressReport report = new WorkDoneProgressReport();
            report.setMessage("Loading data model for '" + projectName + "' Qute project.");
            report.setPercentage(Integer.valueOf(10));
            progressSupport.notifyProgress(progressId, (WorkDoneProgressNotification)report);
        }
        ((CompletableFuture)project.getDataModelProject().thenAccept(dataModel -> {
            if (progressSupport != null) {
                WorkDoneProgressReport report = new WorkDoneProgressReport();
                report.setMessage("Validating Qute templates for '" + projectName + "' Qute project.");
                report.setPercentage(Integer.valueOf(80));
                progressSupport.notifyProgress(progressId, (WorkDoneProgressNotification)report);
            }
            project.validateClosedTemplates();
            QuteProjectRegistry.endProgress(progressId, progressSupport);
        })).exceptionally(a -> {
            QuteProjectRegistry.endProgress(progressId, progressSupport);
            return null;
        });
        return project;
    }

    private static String createAndStartProgress(String projectName, ProgressSupport progressSupport) {
        if (progressSupport == null) {
            return null;
        }
        String progressId = UUID.randomUUID().toString();
        WorkDoneProgressCreateParams create = new WorkDoneProgressCreateParams(Either.forLeft((Object)progressId));
        progressSupport.createProgress(create);
        WorkDoneProgressBegin begin = new WorkDoneProgressBegin();
        begin.setTitle("Loading '" + projectName + "' project");
        begin.setMessage("Trying to load '" + projectName + "' as Qute project.");
        begin.setPercentage(Integer.valueOf(100));
        progressSupport.notifyProgress(progressId, (WorkDoneProgressNotification)begin);
        return progressId;
    }

    private static void endProgress(String progressId, ProgressSupport progressSupport) {
        if (progressSupport != null) {
            WorkDoneProgressEnd end = new WorkDoneProgressEnd();
            progressSupport.notifyProgress(progressId, (WorkDoneProgressNotification)end);
        }
    }

    public void projectAdded(ProjectInfo project) {
        this.loadQuteProject(project);
    }

    public void projectRemoved(ProjectInfo projectInfo) {
        String projectUri = projectInfo.getUri();
        QuteProject project = this.getProject(projectUri);
        if (project != null) {
            project.dispose();
            this.projects.remove(projectUri);
        }
    }
}

