/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project;

import com.redhat.qute.commons.InvalidMethodReason;
import com.redhat.qute.commons.JavaFieldInfo;
import com.redhat.qute.commons.JavaMethodInfo;
import com.redhat.qute.commons.JavaTypeInfo;
import com.redhat.qute.commons.JavaTypeKind;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.commons.annotations.RegisterForReflectionAnnotation;
import com.redhat.qute.commons.annotations.TemplateDataAnnotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class ResolvedGenericJavaTypeInfo
extends ResolvedJavaTypeInfo {
    private final ResolvedJavaTypeInfo genericType;
    private final Map<String, String> genericMap;

    public ResolvedGenericJavaTypeInfo(ResolvedJavaTypeInfo genericType, Map<String, String> genericMap) {
        this.genericType = genericType;
        this.genericMap = genericMap;
        List<String> extendedTypes = genericType.getExtendedTypes();
        if (extendedTypes != null && !extendedTypes.isEmpty()) {
            ArrayList<String> newExtendedTypes = new ArrayList<String>(extendedTypes.size());
            for (String extendedType : extendedTypes) {
                newExtendedTypes.add(JavaTypeInfo.applyGenericTypeInvocation(extendedType, genericMap));
            }
            super.setExtendedTypes(newExtendedTypes);
        }
        super.setSignature(JavaTypeInfo.applyGenericTypeInvocation(genericType, genericMap));
        String iterableOf = genericType.getIterableOf();
        if (iterableOf != null) {
            this.setIterableOf(genericMap.get(iterableOf));
        }
    }

    @Override
    public String getDocumentation() {
        return this.genericType.getDocumentation();
    }

    @Override
    public boolean isBinary() {
        return this.genericType.isBinary();
    }

    @Override
    public RegisterForReflectionAnnotation getRegisterForReflectionAnnotation() {
        return this.genericType.getRegisterForReflectionAnnotation();
    }

    @Override
    public List<TemplateDataAnnotation> getTemplateDataAnnotations() {
        return this.genericType.getTemplateDataAnnotations();
    }

    @Override
    public JavaTypeKind getJavaTypeKind() {
        return this.genericType.getJavaTypeKind();
    }

    @Override
    public InvalidMethodReason getInvalidMethodReason(String methodName) {
        return this.genericType.getInvalidMethodReason(methodName);
    }

    @Override
    public List<JavaFieldInfo> getFields() {
        if (super.isFieldsInitialized()) {
            return super.getFields();
        }
        return this.computeFields();
    }

    private synchronized List<JavaFieldInfo> computeFields() {
        if (super.isFieldsInitialized()) {
            return super.getFields();
        }
        ArrayList<JavaFieldInfo> fields = new ArrayList<JavaFieldInfo>(this.genericType.getFields().size());
        for (JavaFieldInfo field : this.genericType.getFields()) {
            JavaFieldInfo newField = JavaFieldInfo.applyGenericTypeInvocation(field, this.genericMap);
            newField.setJavaType(this);
            fields.add(newField);
        }
        super.setFields(fields);
        return fields;
    }

    @Override
    public List<JavaMethodInfo> getMethods() {
        if (super.isMethodsInitialized()) {
            return super.getMethods();
        }
        return this.computeMethods();
    }

    private synchronized List<JavaMethodInfo> computeMethods() {
        if (super.isMethodsInitialized()) {
            return super.getMethods();
        }
        ArrayList<JavaMethodInfo> methods = new ArrayList<JavaMethodInfo>(this.genericType.getMethods().size());
        for (JavaMethodInfo field : this.genericType.getMethods()) {
            JavaMethodInfo newMethod = JavaMethodInfo.applyGenericTypeInvocation(field, this.genericMap);
            newMethod.setJavaType(this);
            methods.add(newMethod);
        }
        super.setMethods(methods);
        return methods;
    }
}

