/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;

public abstract class WatchDir
implements Runnable {
    private boolean poll = true;
    private final WatchService watcher;
    private final Map<WatchKey, Path> keys;
    private final boolean recursive;

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    private void register(Path dir) throws IOException {
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.keys.put(key, dir);
    }

    private void registerAll(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                WatchDir.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WatchDir(Path dir, boolean recursive) throws IOException {
        while (this.poll && Files.notExists(dir, new LinkOption[0])) {
            WatchDir watchDir = this;
            synchronized (watchDir) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.watcher = FileSystems.getDefault().newWatchService();
        this.keys = new HashMap<WatchKey, Path>();
        this.recursive = recursive;
        if (recursive) {
            this.registerAll(dir);
        } else {
            this.register(dir);
        }
    }

    @Override
    public void run() {
        while (this.poll) {
            WatchKey key;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException x) {
                return;
            }
            Path dir = this.keys.get(key);
            if (dir == null) continue;
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent ev = WatchDir.cast(event);
                Path name = (Path)ev.context();
                Path child = dir.resolve(name);
                this.notifyListeners(event, child);
                if (!this.recursive || kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                try {
                    if (!Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) continue;
                    this.registerAll(child);
                }
                catch (IOException iOException) {}
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.keys.remove(key);
            if (!this.keys.isEmpty()) continue;
            break;
        }
    }

    public void stop() {
        this.poll = false;
        try {
            this.watcher.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract void notifyListeners(WatchEvent<?> var1, Path var2);
}

