/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project.datamodel;

import com.redhat.qute.commons.JavaElementKind;
import com.redhat.qute.commons.JavaParameterInfo;
import com.redhat.qute.commons.JavaTypeInfo;
import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.commons.datamodel.DataModelProject;
import com.redhat.qute.commons.datamodel.DataModelTemplate;
import com.redhat.qute.commons.datamodel.resolvers.MessageResolverData;
import com.redhat.qute.commons.datamodel.resolvers.NamespaceResolverInfo;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverKind;
import com.redhat.qute.project.datamodel.ExtendedDataModelParameter;
import com.redhat.qute.project.datamodel.ExtendedDataModelTemplate;
import com.redhat.qute.project.datamodel.resolvers.FieldValueResolver;
import com.redhat.qute.project.datamodel.resolvers.MessageValueResolver;
import com.redhat.qute.project.datamodel.resolvers.MethodValueResolver;
import com.redhat.qute.project.datamodel.resolvers.TypeValueResolver;
import com.redhat.qute.utils.JSONUtility;
import com.redhat.qute.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ExtendedDataModelProject
extends DataModelProject<ExtendedDataModelTemplate> {
    private final Set<String> allNamespaces;
    private final Set<String> allTemplateExtensionsClasses;
    private final List<TypeValueResolver> typeValueResolvers;
    private final List<FieldValueResolver> fieldValueResolvers;
    private final List<MethodValueResolver> methodValueResolvers;
    private final Map<String, String> similarNamespaces;
    private Set<String> javaTypesSupportedInNativeMode;

    public ExtendedDataModelProject(DataModelProject<DataModelTemplate<DataModelParameter>> project) {
        super.setTemplates(this.createTemplates(project.getTemplates()));
        super.setNamespaceResolverInfos(project.getNamespaceResolverInfos());
        this.typeValueResolvers = new ArrayList<TypeValueResolver>();
        this.fieldValueResolvers = new ArrayList<FieldValueResolver>();
        this.methodValueResolvers = new ArrayList<MethodValueResolver>();
        ExtendedDataModelProject.updateValueResolvers(this.typeValueResolvers, this.fieldValueResolvers, this.methodValueResolvers, project);
        Collections.sort(this.methodValueResolvers, (r1, r2) -> {
            if ("*".equals(r1.getMatchName())) {
                return 1;
            }
            if ("*".equals(r2.getMatchName())) {
                return -1;
            }
            return 0;
        });
        this.allNamespaces = ExtendedDataModelProject.getAllNamespaces(project);
        this.allTemplateExtensionsClasses = ExtendedDataModelProject.getAllTemplateExtensionsClasses(project);
        this.similarNamespaces = ExtendedDataModelProject.getSimilarNamespaces(project);
    }

    private static void updateValueResolvers(List<TypeValueResolver> typeValueResolvers, List<FieldValueResolver> fieldValueResolvers, List<MethodValueResolver> methodValueResolvers, DataModelProject<DataModelTemplate<DataModelParameter>> project) {
        project.getValueResolvers().forEach(resolver -> {
            JavaElementKind kind = resolver.getJavaElementKind();
            switch (kind) {
                case TYPE: {
                    TypeValueResolver typeValueResolver = new TypeValueResolver();
                    typeValueResolver.setNamed(resolver.getNamed());
                    typeValueResolver.setNamespace(resolver.getNamespace());
                    typeValueResolver.setSignature(resolver.getSignature());
                    typeValueResolver.setSourceType(resolver.getSourceType());
                    typeValueResolver.setGlobalVariable(resolver.isGlobalVariable());
                    typeValueResolver.setKind(resolver.getKind());
                    typeValueResolvers.add(typeValueResolver);
                    break;
                }
                case FIELD: {
                    FieldValueResolver fieldValueResolver = new FieldValueResolver();
                    fieldValueResolver.setNamed(resolver.getNamed());
                    fieldValueResolver.setNamespace(resolver.getNamespace());
                    fieldValueResolver.setSignature(resolver.getSignature());
                    fieldValueResolver.setSourceType(resolver.getSourceType());
                    fieldValueResolver.setGlobalVariable(resolver.isGlobalVariable());
                    fieldValueResolver.setKind(resolver.getKind());
                    fieldValueResolvers.add(fieldValueResolver);
                    break;
                }
                case METHOD: {
                    MethodValueResolver methodValueResolver = resolver.getKind() == ValueResolverKind.Message ? new MessageValueResolver() : new MethodValueResolver();
                    methodValueResolver.setNamed(resolver.getNamed());
                    methodValueResolver.setNamespace(resolver.getNamespace());
                    methodValueResolver.setMatchName(resolver.getMatchName());
                    methodValueResolver.setSignature(resolver.getSignature());
                    methodValueResolver.setSourceType(resolver.getSourceType());
                    methodValueResolver.setGlobalVariable(resolver.isGlobalVariable());
                    methodValueResolver.setKind(resolver.getKind());
                    if (resolver.getKind() == ValueResolverKind.Message && resolver.getData() != null) {
                        MessageResolverData data = JSONUtility.toModel(resolver.getData(), MessageResolverData.class);
                        ((MessageValueResolver)methodValueResolver).setLocale(data.getLocale());
                        ((MessageValueResolver)methodValueResolver).setMessage(data.getMessage());
                    }
                    methodValueResolvers.add(methodValueResolver);
                    break;
                }
            }
        });
    }

    private static Set<String> getAllNamespaces(DataModelProject<DataModelTemplate<DataModelParameter>> project) {
        Set<String> allNamespaces = project.getValueResolvers().stream().filter(resolver -> resolver.getNamespace() != null).map(resolver -> resolver.getNamespace()).distinct().collect(Collectors.toSet());
        allNamespaces.add("data");
        for (NamespaceResolverInfo info : project.getNamespaceResolverInfos().values()) {
            info.getNamespaces().forEach(namespace -> allNamespaces.add((String)namespace));
        }
        return allNamespaces;
    }

    private static Set<String> getAllTemplateExtensionsClasses(DataModelProject<DataModelTemplate<DataModelParameter>> project) {
        return project.getValueResolvers().stream().filter(resolver -> ValueResolverKind.TemplateExtensionOnClass.equals((Object)resolver.getKind()) && !resolver.isBinary()).map(resolver -> resolver.getSourceType()).distinct().collect(Collectors.toSet());
    }

    private static Map<String, String> getSimilarNamespaces(DataModelProject<DataModelTemplate<DataModelParameter>> project) {
        HashMap<String, String> similar = new HashMap<String, String>();
        for (Map.Entry<String, NamespaceResolverInfo> entry : project.getNamespaceResolverInfos().entrySet()) {
            String mainNamespace = entry.getKey();
            List<String> namespaces = entry.getValue().getNamespaces();
            for (String namespace : namespaces) {
                similar.put(namespace, mainNamespace);
            }
        }
        return similar;
    }

    private List<ExtendedDataModelTemplate> createTemplates(List<DataModelTemplate<DataModelParameter>> templates) {
        if (templates == null || templates.isEmpty()) {
            return Collections.emptyList();
        }
        return templates.stream().map(template -> new ExtendedDataModelTemplate((DataModelTemplate<DataModelParameter>)template)).collect(Collectors.toList());
    }

    public Set<String> getAllNamespaces() {
        return this.allNamespaces;
    }

    public Set<String> getAllTemplateExtensionsClasses() {
        return this.allTemplateExtensionsClasses;
    }

    public String getSimilarNamespace(String namespace) {
        String similar = this.similarNamespaces.get(namespace);
        return similar != null ? similar : namespace;
    }

    public List<TypeValueResolver> getTypeValueResolvers() {
        return this.typeValueResolvers;
    }

    public List<MethodValueResolver> getMethodValueResolvers() {
        return this.methodValueResolvers;
    }

    public List<FieldValueResolver> getFieldValueResolvers() {
        return this.fieldValueResolvers;
    }

    public NamespaceResolverInfo getNamespaceResolver(String namespace) {
        String mainNamespace = this.getSimilarNamespace(namespace);
        return super.getNamespaceResolverInfos().get(mainNamespace);
    }

    public Set<String> getJavaTypesSupportedInNativeMode() {
        if (this.javaTypesSupportedInNativeMode == null) {
            this.javaTypesSupportedInNativeMode = this.loadJavaTypesSupportedInNativeMode();
        }
        return this.javaTypesSupportedInNativeMode;
    }

    private synchronized Set<String> loadJavaTypesSupportedInNativeMode() {
        if (this.javaTypesSupportedInNativeMode != null) {
            return this.javaTypesSupportedInNativeMode;
        }
        HashSet<String> javaTypesSupportedInNativeMode = new HashSet<String>();
        this.getTemplates().forEach(t -> {
            List parameters = t.getParameters();
            for (ExtendedDataModelParameter parameter : parameters) {
                if (parameter.isDataMethodInvocation()) continue;
                String sourceType = parameter.getJavaType();
                if (StringUtils.isEmpty(sourceType)) {
                    return;
                }
                if (sourceType.contains("<")) {
                    JavaTypeInfo javaType = new JavaTypeInfo();
                    javaType.setSignature(sourceType);
                    List<JavaParameterInfo> javaTypeParameters = javaType.getTypeParameters();
                    for (JavaParameterInfo parameterType : javaTypeParameters) {
                        javaTypesSupportedInNativeMode.add(parameterType.getType());
                    }
                    continue;
                }
                javaTypesSupportedInNativeMode.add(sourceType);
            }
        });
        return javaTypesSupportedInNativeMode;
    }
}

