/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project.datamodel;

import com.redhat.qute.commons.QuteJavaDefinitionParams;
import com.redhat.qute.commons.datamodel.DataModelFragment;
import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.commons.datamodel.DataModelTemplate;
import com.redhat.qute.project.datamodel.DataModelSourceProvider;
import com.redhat.qute.project.datamodel.ExtendedDataModelFragment;
import com.redhat.qute.project.datamodel.ExtendedDataModelParameter;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ExtendedDataModelTemplate
extends DataModelTemplate<ExtendedDataModelParameter>
implements DataModelSourceProvider {
    public ExtendedDataModelTemplate(DataModelTemplate<DataModelParameter> template) {
        super.setTemplateUri(template.getTemplateUri());
        super.setSourceType(template.getSourceType());
        super.setSourceMethod(template.getSourceMethod());
        super.setSourceField(template.getSourceField());
        super.setParameters(ExtendedDataModelTemplate.createParameters(template.getParameters(), this));
        super.setFragments(this.createFragments(template.getFragments(), this));
    }

    private List<DataModelFragment<ExtendedDataModelParameter>> createFragments(List<DataModelFragment<DataModelParameter>> fragments, ExtendedDataModelTemplate template) {
        if (fragments == null) {
            return Collections.emptyList();
        }
        return fragments.stream().map(fragment -> new ExtendedDataModelFragment((DataModelFragment<DataModelParameter>)fragment)).collect(Collectors.toList());
    }

    protected static List<ExtendedDataModelParameter> createParameters(List<DataModelParameter> parameters, DataModelSourceProvider template) {
        if (parameters == null) {
            return Collections.emptyList();
        }
        return parameters.stream().map(parameter -> new ExtendedDataModelParameter((DataModelParameter)parameter, template)).collect(Collectors.toList());
    }

    @Override
    public QuteJavaDefinitionParams toJavaDefinitionParams(String projectUri) {
        String sourceType = this.getSourceType();
        String sourceField = this.getSourceField();
        String sourceMethod = this.getSourceMethod();
        QuteJavaDefinitionParams params = new QuteJavaDefinitionParams(sourceType, projectUri);
        params.setSourceField(sourceField);
        params.setSourceMethod(sourceMethod);
        return params;
    }
}

