/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project.documents;

import com.redhat.qute.commons.ProjectInfo;
import com.redhat.qute.ls.commons.TextDocument;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.template.TemplateParser;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteTextDocument;
import com.redhat.qute.project.documents.SearchInfoQuery;
import com.redhat.qute.project.documents.TemplateInfoCollector;
import com.redhat.qute.utils.FileUtils;
import com.redhat.qute.utils.IOUtils;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class QuteClosedTextDocument
implements QuteTextDocument {
    private static final Logger LOGGER = Logger.getLogger(QuteClosedTextDocument.class.getName());
    private final String uri;
    private final Path path;
    private final String templateId;
    private final QuteProject project;
    private Template template;
    private TemplateInfoCollector collector;

    public QuteClosedTextDocument(Path path, String templateId, QuteProject project) {
        this.path = path;
        this.templateId = templateId;
        this.uri = FileUtils.toUri(path);
        this.project = project;
    }

    @Override
    public Template getTemplate() {
        if (this.template == null) {
            this.template = this.loadTemplate();
        }
        return this.template;
    }

    private synchronized Template loadTemplate() {
        if (this.template != null) {
            return this.template;
        }
        try {
            TextDocument document = new TextDocument(IOUtils.getContent(this.path), this.uri);
            Template template = TemplateParser.parse(document, () -> {});
            template.setTemplateId(this.templateId);
            template.setProjectRegistry(this.project.getProjectRegistry());
            template.setProjectUri(this.project.getUri());
            return template;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while loading closed template '" + this.uri + "'.", e);
            return null;
        }
    }

    @Override
    public CompletableFuture<ProjectInfo> getProjectInfoFuture() {
        return null;
    }

    @Override
    public QuteProject getProject() {
        return this.project;
    }

    @Override
    public String getTemplateId() {
        return this.templateId;
    }

    private TemplateInfoCollector getCollector() {
        if (this.collector == null) {
            this.collector = this.getSynchCollector();
        }
        return this.collector;
    }

    private synchronized TemplateInfoCollector getSynchCollector() {
        if (this.collector != null) {
            return this.collector;
        }
        SearchInfoQuery query = new SearchInfoQuery();
        query.setInsertParameter("@all");
        query.setSectionTag("@all");
        TemplateInfoCollector collector = new TemplateInfoCollector(query);
        this.getTemplate().accept(collector);
        return collector;
    }

    @Override
    public List<Parameter> findInsertTagParameter(String insertParameter) {
        List<Parameter> parameters = this.getCollector().getInsertParameters();
        if (parameters == null) {
            return Collections.emptyList();
        }
        if ("@all".equals(insertParameter)) {
            return parameters;
        }
        return parameters.stream().filter(p -> insertParameter.equals(p.getValue())).collect(Collectors.toList());
    }

    @Override
    public List<Section> findSectionsByTag(String tag) {
        List<Section> sections = this.getCollector().getSectionsByTag();
        if (sections == null) {
            return Collections.emptyList();
        }
        if ("@all".equals(tag)) {
            return sections;
        }
        return sections.stream().filter(s -> tag.equals(s.getTag())).collect(Collectors.toList());
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public boolean isOpened() {
        return false;
    }
}

