/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project.documents;

import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteTextDocument;
import com.redhat.qute.project.documents.QuteClosedTextDocument;
import com.redhat.qute.utils.FileUtils;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QuteClosedTextDocuments {
    private static final Logger LOGGER = Logger.getLogger(QuteClosedTextDocuments.class.getName());
    private final QuteProject project;
    private final Map<String, QuteTextDocument> documents;
    private boolean scanned;

    public QuteClosedTextDocuments(QuteProject project, Map<String, QuteTextDocument> documents) {
        this.project = project;
        this.documents = documents;
    }

    public void loadClosedTemplatesIfNeeded() {
        if (this.scanned) {
            return;
        }
        this.scan();
    }

    private synchronized void scan() {
        if (this.scanned) {
            return;
        }
        if (!Files.exists(this.project.getTemplateBaseDir(), new LinkOption[0])) {
            return;
        }
        try {
            Files.walk(this.project.getTemplateBaseDir(), new FileVisitOption[0]).forEach(path -> {
                try {
                    this.tryToAddClosedTemplate((Path)path, false);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error while loading template '" + FileUtils.toUri(path) + "'.", e);
                }
            });
        }
        catch (Exception exception) {
        }
        finally {
            this.scanned = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuteTextDocument tryToAddClosedTemplate(Path path, boolean force) {
        if (!this.isValidTemplate(path)) {
            return null;
        }
        String templateId = this.project.getTemplateId(path);
        if (force || !this.project.isTemplateOpened(templateId)) {
            Map<String, QuteTextDocument> map = this.documents;
            synchronized (map) {
                QuteTextDocument document;
                if (!force && (document = this.documents.get(templateId)) != null && !document.isOpened()) {
                    return document;
                }
                document = new QuteClosedTextDocument(path, templateId, this.project);
                this.documents.put(templateId, document);
                return document;
            }
        }
        return null;
    }

    private boolean isValidTemplate(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        String uri = path.toString();
        for (String variant : this.project.getTemplateVariants()) {
            if (variant.isEmpty() || !uri.endsWith(variant)) continue;
            return true;
        }
        return false;
    }

    public QuteTextDocument onDidCreateTemplate(Path path) {
        return this.tryToAddClosedTemplate(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuteTextDocument onDidDeleteTemplate(Path path) {
        String templateId = this.project.getTemplateId(path);
        Map<String, QuteTextDocument> map = this.documents;
        synchronized (map) {
            return this.documents.remove(templateId);
        }
    }

    public void onDidCloseTemplate(Path path) {
        this.onDidCreateTemplate(path);
    }
}

