/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project.documents;

import com.redhat.qute.commons.ProjectInfo;
import com.redhat.qute.commons.QuteProjectParams;
import com.redhat.qute.ls.api.QuteProjectInfoProvider;
import com.redhat.qute.ls.commons.ModelTextDocument;
import com.redhat.qute.ls.commons.TextDocument;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.project.QuteTextDocument;
import com.redhat.qute.project.documents.SearchInfoQuery;
import com.redhat.qute.project.documents.TemplateInfoCollector;
import com.redhat.qute.utils.FileUtils;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class QuteOpenedTextDocument
extends ModelTextDocument<Template>
implements QuteTextDocument {
    private CompletableFuture<ProjectInfo> projectInfoFuture;
    private final QuteProjectInfoProvider projectInfoProvider;
    private QuteProjectRegistry projectRegistry;
    private final Path templatePath;
    private String projectUri;
    private String templateId;

    public QuteOpenedTextDocument(TextDocumentItem document, BiFunction<TextDocument, CancelChecker, Template> parse, QuteProjectInfoProvider projectInfoProvider, QuteProjectRegistry projectRegistry) {
        super(document, parse);
        this.projectInfoProvider = projectInfoProvider;
        this.projectRegistry = projectRegistry;
        this.templatePath = FileUtils.createPath(document.getUri());
    }

    @Override
    public Template getModel() {
        Template template = (Template)super.getModel();
        if (template != null && template.getProjectUri() == null) {
            template.setTemplateInfoProvider(this);
            ProjectInfo projectInfo = this.getProjectInfoFuture().getNow(null);
            if (projectInfo != null) {
                QuteProject project = this.projectRegistry.getProject(projectInfo);
                template.setProjectUri(project.getUri());
                template.setTemplateId(this.templateId);
            }
            template.setProjectRegistry(this.projectRegistry);
        }
        return template;
    }

    @Override
    public CompletableFuture<ProjectInfo> getProjectInfoFuture() {
        if (this.projectInfoFuture == null || this.projectInfoFuture.isCompletedExceptionally() || this.projectInfoFuture.isCancelled()) {
            QuteProjectParams params = new QuteProjectParams(super.getUri());
            this.projectInfoFuture = this.projectInfoProvider.getProjectInfo(params).thenApply(projectInfo -> {
                if (projectInfo != null && this.projectUri == null) {
                    QuteProject project = this.projectRegistry.getProject((ProjectInfo)projectInfo);
                    this.projectUri = projectInfo.getUri();
                    this.templateId = project.getTemplateId(this.templatePath);
                    this.projectRegistry.onDidOpenTextDocument(this);
                }
                return projectInfo;
            });
        }
        return this.projectInfoFuture;
    }

    @Override
    public Template getTemplate() {
        return this.getModel();
    }

    @Override
    public String getTemplateId() {
        if (this.templateId != null) {
            return this.templateId;
        }
        this.getProjectInfoFuture().getNow(null);
        return this.templateId;
    }

    @Override
    public QuteProject getProject() {
        if (this.projectUri != null) {
            return this.projectRegistry.getProject(this.projectUri);
        }
        this.getProjectInfoFuture().getNow(null);
        return null;
    }

    @Override
    public List<Parameter> findInsertTagParameter(String insertParameter) {
        SearchInfoQuery query = new SearchInfoQuery();
        query.setInsertParameter(insertParameter);
        TemplateInfoCollector collector = new TemplateInfoCollector(query);
        this.getTemplate().accept(collector);
        return collector.getInsertParameters();
    }

    @Override
    public List<Section> findSectionsByTag(String tag) {
        SearchInfoQuery query = new SearchInfoQuery();
        query.setSectionTag(tag);
        TemplateInfoCollector collector = new TemplateInfoCollector(query);
        this.getTemplate().accept(collector);
        return collector.getSectionsByTag();
    }

    @Override
    public boolean isOpened() {
        return true;
    }
}

