/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project.documents;

import com.redhat.qute.ls.api.QuteProjectInfoProvider;
import com.redhat.qute.ls.commons.ModelTextDocument;
import com.redhat.qute.ls.commons.ModelTextDocuments;
import com.redhat.qute.ls.commons.TextDocument;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.project.documents.QuteOpenedTextDocument;
import java.util.function.BiFunction;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class QuteOpenedTextDocuments
extends ModelTextDocuments<Template> {
    private final QuteProjectInfoProvider projectInfoProvider;
    private final QuteProjectRegistry projectRegistry;

    public QuteOpenedTextDocuments(BiFunction<TextDocument, CancelChecker, Template> parse, QuteProjectInfoProvider projectInfoProvider, QuteProjectRegistry projectRegistry) {
        super(parse);
        this.projectInfoProvider = projectInfoProvider;
        this.projectRegistry = projectRegistry;
    }

    @Override
    public QuteOpenedTextDocument createDocument(TextDocumentItem document) {
        QuteOpenedTextDocument doc = new QuteOpenedTextDocument(document, this.parse, this.projectInfoProvider, this.projectRegistry);
        doc.setIncremental(this.isIncremental());
        return doc;
    }

    @Override
    public ModelTextDocument<Template> onDidOpenTextDocument(DidOpenTextDocumentParams params) {
        QuteOpenedTextDocument document = (QuteOpenedTextDocument)super.onDidOpenTextDocument(params);
        this.projectRegistry.onDidOpenTextDocument(document);
        return document;
    }

    @Override
    public ModelTextDocument<Template> onDidCloseTextDocument(DidCloseTextDocumentParams params) {
        QuteOpenedTextDocument document = (QuteOpenedTextDocument)super.onDidCloseTextDocument(params);
        this.projectRegistry.onDidCloseTextDocument(document);
        return document;
    }

    @Override
    public ModelTextDocument<Template> onDidSaveTextDocument(DidSaveTextDocumentParams params) {
        QuteOpenedTextDocument document = (QuteOpenedTextDocument)super.onDidSaveTextDocument(params);
        this.projectRegistry.onDidSaveTextDocument(document);
        return document;
    }
}

