/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project.tags;

import com.redhat.qute.ls.commons.snippets.SnippetRegistry;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.tags.QuteCompletionsForUserTagSection;
import com.redhat.qute.project.tags.SourceUserTag;
import com.redhat.qute.project.tags.UserTag;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class QuteCompletionsForSourceUserTagSection
extends QuteCompletionsForUserTagSection {
    private static final Logger LOGGER = Logger.getLogger(QuteCompletionsForSourceUserTagSection.class.getName());

    public void refresh(Path tagsDir, QuteProject project) {
        if (!Files.exists(tagsDir, new LinkOption[0])) {
            return;
        }
        SnippetRegistry snippetRegistry = super.getSnippetRegistry();
        List snippets = snippetRegistry.getSnippets();
        try {
            if (snippets.isEmpty()) {
                Files.list(tagsDir).forEach(path -> snippetRegistry.registerSnippet(QuteCompletionsForSourceUserTagSection.createUserTag(path, tagsDir, project)));
            } else {
                ArrayList existingSnippets = new ArrayList(snippets);
                for (UserTag userTag2 : existingSnippets) {
                    if (Files.exists(((SourceUserTag)userTag2).getPath(), new LinkOption[0])) continue;
                    snippets.remove(userTag2);
                }
                Set existingSnippetPaths = snippets.stream().map(userTag -> ((SourceUserTag)userTag).getPath()).collect(Collectors.toSet());
                Files.list(tagsDir).forEach(path -> {
                    if (!existingSnippetPaths.contains(path)) {
                        snippetRegistry.registerSnippet(QuteCompletionsForSourceUserTagSection.createUserTag(path, tagsDir, project));
                    }
                });
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error while collecting source user tags", e);
        }
    }

    private static UserTag createUserTag(Path path, Path tagsDir, QuteProject project) {
        String fileName = path.getName(path.getNameCount() - 1).toString();
        return new SourceUserTag(fileName, path, project);
    }

    public void clear() {
        SnippetRegistry snippetRegistry = super.getSnippetRegistry();
        List snippets = snippetRegistry.getSnippets();
        for (UserTag userTag : snippets) {
            userTag.clear();
        }
    }
}

