/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project.tags;

import com.redhat.qute.ls.commons.snippets.Snippet;
import com.redhat.qute.ls.commons.snippets.SnippetsBuilder;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.template.TemplateParser;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.tags.UserTagParameter;
import com.redhat.qute.project.tags.UserTagParameterCollector;
import com.redhat.qute.services.snippets.QuteSnippetContext;
import com.redhat.qute.utils.UserTagUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class UserTag
extends Snippet {
    private final String fileName;
    private final String templateId;
    private Map<String, UserTagParameter> parameters;
    private final QuteProject project;

    public UserTag(String fileName, QuteProject project) {
        String name = UserTagUtils.getUserTagName(fileName);
        super.setLabel(name);
        super.setPrefixes(Arrays.asList(name));
        super.setContext(QuteSnippetContext.IN_TEXT);
        this.fileName = fileName;
        this.templateId = UserTagUtils.getTemplateId(name);
        this.project = project;
    }

    @Override
    public List<String> getBody() {
        if (super.getBody() == null) {
            super.setBody(this.createBody());
        }
        return super.getBody();
    }

    private List<String> createBody() {
        String name = this.getLabel();
        ArrayList<String> body = new ArrayList<String>();
        Collection<UserTagParameter> parameters = this.getParameters();
        boolean hasNestedContent = false;
        int index = 1;
        StringBuilder startSection = new StringBuilder("{#");
        startSection.append(name);
        block8: for (UserTagParameter parameter : parameters) {
            if (!parameter.isRequired().booleanValue()) continue;
            switch (parameter.getName()) {
                case "it": {
                    startSection.append(" ");
                    SnippetsBuilder.placeholders(index++, parameter.getName(), startSection);
                    continue block8;
                }
                case "nested-content": {
                    hasNestedContent = true;
                    continue block8;
                }
            }
            startSection.append(" ");
            UserTag.generateUserTagParameter(parameter, true, index++, startSection);
        }
        if (hasNestedContent) {
            if (!parameters.isEmpty()) {
                startSection.append(" ");
            }
            startSection.append("}");
        } else {
            startSection.append(" /}");
            SnippetsBuilder.tabstops(0, startSection);
        }
        body.add(startSection.toString());
        if (hasNestedContent) {
            body.add("\t" + SnippetsBuilder.tabstops(index++));
            body.add("{/" + name + "}" + SnippetsBuilder.tabstops(0));
        }
        return body;
    }

    public static void generateUserTagParameter(UserTagParameter parameter, boolean snippetsSupported, int index, StringBuilder snippet) {
        snippet.append(parameter.getName());
        snippet.append("=");
        String value = parameter.getName();
        Character quote = Character.valueOf('\"');
        String defaultValue = parameter.getDefaultValue();
        if (defaultValue != null && !defaultValue.isEmpty()) {
            value = defaultValue;
            char start = defaultValue.charAt(0);
            if (start == '\"' || start == '\'') {
                quote = Character.valueOf(start);
                value = value.substring(1, value.length() - (value.endsWith("" + start) ? 1 : 0));
            } else {
                quote = null;
            }
        }
        if (quote != null) {
            snippet.append(quote);
        }
        if (snippetsSupported) {
            SnippetsBuilder.placeholders(index, value, snippet);
        } else {
            snippet.append(value);
        }
        if (quote != null) {
            snippet.append(quote);
        }
    }

    public String getName() {
        return this.getLabel();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public Collection<UserTagParameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.collectParameters();
        }
        return this.parameters.values();
    }

    public List<String> getRequiredParameterNames() {
        return this.getParameters().stream().filter(UserTagParameter::isRequired).map(UserTagParameter::getName).filter(paramName -> !paramName.equals("nested-content")).collect(Collectors.toList());
    }

    public UserTagParameter findParameter(String parameterName) {
        for (UserTagParameter parameter : this.getParameters()) {
            if (!parameterName.equals(parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    private Map<String, UserTagParameter> collectParameters() {
        Template template = this.getTemplate();
        if (template == null) {
            return Collections.emptyMap();
        }
        UserTagParameterCollector collector = new UserTagParameterCollector(this.project);
        template.accept(collector);
        return collector.getParameters();
    }

    public Template getTemplate() {
        String content = this.getContent();
        if (content == null) {
            return null;
        }
        return TemplateParser.parse(content, this.getUri());
    }

    public void clear() {
        this.parameters = null;
        this.setBody(null);
    }

    public abstract String getUri();

    public abstract String getContent();
}

