/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project.tags;

import com.redhat.qute.parser.expression.MethodPart;
import com.redhat.qute.parser.expression.ObjectPart;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.template.ASTVisitor;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.LiteralSupport;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.sections.IfSection;
import com.redhat.qute.parser.template.sections.LetSection;
import com.redhat.qute.parser.template.sections.SetSection;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.datamodel.resolvers.ValueResolver;
import com.redhat.qute.project.tags.UserTagParameter;
import com.redhat.qute.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UserTagParameterCollector
extends ASTVisitor {
    private final QuteProject project;
    private final Map<String, UserTagParameter> parameters;
    private final List<List<ParamInfo>> parameterNamesStack;
    private List<String> globalVariables;

    public UserTagParameterCollector(QuteProject project) {
        this.project = project;
        this.parameters = new LinkedHashMap<String, UserTagParameter>();
        this.parameterNamesStack = new ArrayList<List<ParamInfo>>();
    }

    @Override
    public boolean visit(IfSection node) {
        this.addOptionalStack(node);
        return super.visit(node);
    }

    @Override
    public void endVisit(IfSection node) {
        this.removeParameterStack();
        super.endVisit(node);
    }

    private void addOptionalStack(Section node) {
        List optionalParameterNames = null;
        List<Parameter> parameters = node.getParameters();
        for (Parameter parameter : parameters) {
            String name = parameter.getName();
            if (StringUtils.isEmpty(name) || !parameter.isOptional()) continue;
            if (optionalParameterNames == null) {
                optionalParameterNames = new ArrayList();
            }
            optionalParameterNames.add(new ParamInfo(name, false, null));
        }
        this.parameterNamesStack.add(optionalParameterNames != null ? optionalParameterNames : Collections.emptyList());
    }

    private void removeParameterStack() {
        this.parameterNamesStack.remove(this.parameterNamesStack.size() - 1);
    }

    @Override
    public boolean visit(LetSection node) {
        this.addAssignedParameterStack(node);
        return super.visit(node);
    }

    @Override
    public void endVisit(LetSection node) {
        this.removeParameterStack();
        super.endVisit(node);
    }

    @Override
    public boolean visit(SetSection node) {
        this.addAssignedParameterStack(node);
        return super.visit(node);
    }

    @Override
    public void endVisit(SetSection node) {
        this.removeParameterStack();
        super.endVisit(node);
    }

    private void addAssignedParameterStack(Section node) {
        List declaredParameterNames = null;
        List<Parameter> parameters = node.getParameters();
        for (Parameter parameter : parameters) {
            String defaultValue;
            String name = parameter.getName();
            String string = defaultValue = parameter.hasDefaultValue() ? parameter.getValue() : null;
            if (StringUtils.isEmpty(name)) continue;
            if (declaredParameterNames == null) {
                declaredParameterNames = new ArrayList();
            }
            declaredParameterNames.add(new ParamInfo(name, true, defaultValue));
        }
        this.parameterNamesStack.add(declaredParameterNames != null ? declaredParameterNames : Collections.emptyList());
    }

    @Override
    public boolean visit(MethodPart node) {
        for (Parameter parameter : node.getParameters()) {
            Expression expression = parameter.getJavaTypeExpression();
            if (expression == null) continue;
            expression.accept(this);
        }
        return super.visit(node);
    }

    @Override
    public boolean visit(ObjectPart node) {
        if (this.isValid(node)) {
            String partName = node.getPartName();
            ParamInfo paramInfo = this.getParamInfo(partName);
            if (paramInfo != null && paramInfo.assigned && paramInfo.defaultValue == null) {
                return super.visit(node);
            }
            UserTagParameter parameter = this.parameters.get(partName);
            if (parameter == null) {
                parameter = new UserTagParameter(partName);
                parameter.setDefaultValue(paramInfo != null ? paramInfo.defaultValue : null);
                this.parameters.put(partName, parameter);
            }
            if (!parameter.isRequired().booleanValue() && parameter.getDefaultValue() == null) {
                boolean ignore;
                boolean bl = ignore = paramInfo != null && !paramInfo.assigned;
                if (!ignore) {
                    boolean required = true;
                    Parts parts = node.getParent();
                    int index = parts.getPartIndex(node);
                    if (index + 1 < parts.getChildCount()) {
                        MethodPart methodPart;
                        Part next = parts.getChild(index + 1);
                        if (next != null && next.getPartKind() == Parts.PartKind.Method && (methodPart = (MethodPart)next).isOrOperator()) {
                            required = false;
                        }
                    } else {
                        required = !node.isOptional();
                    }
                    parameter.setRequired(required);
                }
            }
        }
        return super.visit(node);
    }

    private ParamInfo getParamInfo(String partName) {
        for (List<ParamInfo> params : this.parameterNamesStack) {
            for (ParamInfo paramInfo : params) {
                if (!paramInfo.name.equals(partName)) continue;
                return paramInfo;
            }
        }
        return null;
    }

    public boolean isValid(ObjectPart node) {
        if (node.getNamespace() != null) {
            return false;
        }
        if (this.globalVariables == null) {
            List resolvers = this.project.getGlobalVariables().getNow(null);
            List<Object> list = this.globalVariables = resolvers != null ? resolvers.stream().map(ValueResolver::getName).collect(Collectors.toList()) : Collections.emptyList();
        }
        if (this.globalVariables.contains(node.getPartName())) {
            return false;
        }
        return LiteralSupport.getLiteralJavaType(node.getPartName()) == null;
    }

    public Map<String, UserTagParameter> getParameters() {
        return this.parameters;
    }

    private static class ParamInfo {
        public final String name;
        public final boolean assigned;
        public final String defaultValue;

        public ParamInfo(String name, boolean assigned, String defaultValue) {
            this.name = name;
            this.assigned = assigned;
            this.defaultValue = defaultValue;
        }
    }
}

