/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.project.tags;

import com.redhat.qute.commons.usertags.QuteUserTagParams;
import com.redhat.qute.commons.usertags.UserTagInfo;
import com.redhat.qute.ls.api.QuteUserTagProvider;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.tags.BinaryUserTag;
import com.redhat.qute.project.tags.QuteCompletionsForBinaryUserTagSection;
import com.redhat.qute.project.tags.QuteCompletionsForSourceUserTagSection;
import com.redhat.qute.project.tags.UserTag;
import com.redhat.qute.services.completions.CompletionRequest;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;

public class UserTagRegistry {
    private final QuteProject project;
    private final Path tagsDir;
    private final QuteCompletionsForSourceUserTagSection completionsSourceUserTag;
    private final QuteUserTagProvider userTagProvider;
    private final QuteCompletionsForBinaryUserTagSection completionsBinaryUserTag;
    private CompletableFuture<List<UserTag>> userTagFuture;

    public UserTagRegistry(QuteProject project, Path templateBaseDir, QuteUserTagProvider userTagProvider) {
        this.project = project;
        this.tagsDir = templateBaseDir.resolve("tags");
        this.userTagProvider = userTagProvider;
        this.completionsSourceUserTag = new QuteCompletionsForSourceUserTagSection();
        this.completionsBinaryUserTag = new QuteCompletionsForBinaryUserTagSection();
    }

    public Collection<UserTag> getSourceUserTags() {
        this.refresh();
        return this.completionsSourceUserTag.getUserTags();
    }

    private void refresh() {
        this.completionsSourceUserTag.refresh(this.getTagsDir(), this.project);
        this.completionsBinaryUserTag.refresh(this.getBinaryUserTags());
    }

    public void collectUserTagSuggestions(CompletionRequest completionRequest, String prefixFilter, String suffixToFind, Set<CompletionItem> completionItems) {
        this.refresh();
        this.completionsSourceUserTag.collectSnippetSuggestions(completionRequest, prefixFilter, suffixToFind, completionItems);
        this.completionsBinaryUserTag.collectSnippetSuggestions(completionRequest, prefixFilter, suffixToFind, completionItems);
    }

    public CompletableFuture<List<UserTag>> getBinaryUserTags() {
        if (this.userTagFuture == null || this.userTagFuture.isCancelled() || this.userTagFuture.isCompletedExceptionally()) {
            this.userTagFuture = null;
            this.userTagFuture = this.loadBinaryUserTags();
        }
        return this.userTagFuture;
    }

    protected synchronized CompletableFuture<List<UserTag>> loadBinaryUserTags() {
        if (this.userTagFuture != null) {
            return this.userTagFuture;
        }
        QuteUserTagParams params = new QuteUserTagParams();
        params.setProjectUri(this.project.getUri());
        return this.getBinaryUserTags(params).thenApply(tagInfos -> {
            if (tagInfos == null) {
                return Collections.emptyList();
            }
            return tagInfos.stream().map(info -> new BinaryUserTag((UserTagInfo)info, this.project)).collect(Collectors.toList());
        });
    }

    protected CompletableFuture<List<UserTagInfo>> getBinaryUserTags(QuteUserTagParams params) {
        return this.userTagProvider.getUserTags(params);
    }

    public Path getTagsDir() {
        return this.tagsDir;
    }

    public void refreshDataModel() {
        this.completionsSourceUserTag.clear();
    }
}

