/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services;

import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.utils.QutePositionUtility;
import org.eclipse.lsp4j.Position;

public abstract class AbstractPositionRequest {
    private final Template template;
    private final int offset;
    private final Node node;

    public AbstractPositionRequest(Template template, Position position) throws BadLocationException {
        this.template = template;
        this.offset = template.offsetAt(position);
        this.node = this.findNodeAt(template, this.offset);
        if (this.node == null) {
            throw new BadLocationException("node is null at offset " + this.offset);
        }
    }

    protected final Node findNodeAt(Template template, int offset) {
        Node node = this.doFindNodeAt(template, offset);
        if (node == null) {
            return null;
        }
        return QutePositionUtility.findBestNode(offset, node, this.isIncludeAfterStartExpression());
    }

    protected boolean isIncludeAfterStartExpression() {
        return false;
    }

    protected abstract Node doFindNodeAt(Template var1, int var2);

    public Template getTemplate() {
        return this.template;
    }

    public int getOffset() {
        return this.offset;
    }

    public Node getNode() {
        return this.node;
    }
}

