/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services;

import com.redhat.qute.ls.api.QuteTemplateJavaTextEditProvider;
import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.ls.commons.client.ConfigurationItemEditType;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.validator.QuteSyntaxErrorCode;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.services.codeactions.AbstractQuteCodeAction;
import com.redhat.qute.services.codeactions.CodeActionRequest;
import com.redhat.qute.services.codeactions.QuteCodeActionForMismatchSectionTag;
import com.redhat.qute.services.codeactions.QuteCodeActionForMissingInputs;
import com.redhat.qute.services.codeactions.QuteCodeActionForMissingParameters;
import com.redhat.qute.services.codeactions.QuteCodeActionForUndefinedNamespace;
import com.redhat.qute.services.codeactions.QuteCodeActionForUndefinedObject;
import com.redhat.qute.services.codeactions.QuteCodeActionForUndefinedSectionTag;
import com.redhat.qute.services.codeactions.QuteCodeActionForUnknownMethod;
import com.redhat.qute.services.codeactions.QuteCodeActionForUnknownProperty;
import com.redhat.qute.services.codeactions.QuteCodeActionForUnterminatedSection;
import com.redhat.qute.services.diagnostics.QuteErrorCode;
import com.redhat.qute.settings.SharedSettings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

class QuteCodeActions {
    private static final Logger LOGGER = Logger.getLogger(QuteCodeActions.class.getName());
    private static CompletableFuture<List<CodeAction>> NO_CODEACTION = CompletableFuture.completedFuture(Collections.emptyList());
    private static final String QUTE_VALIDATION_ENABLED_SECTION = "qute.validation.enabled";
    private static final String DISABLE_VALIDATION_ON_PROJECT_LEVEL_TITLE = "Disable Qute validation for the `{0}` project.";
    private static final String QUTE_VALIDATION_EXCLUDED_SECTION = "qute.validation.excluded";
    private static final String EXCLUDED_VALIDATION_TITLE = "Exclude this file from validation.";
    private final QuteCodeActionForUndefinedObject codeActionForUndefinedObject = new QuteCodeActionForUndefinedObject();
    private final QuteCodeActionForUndefinedNamespace codeActionForUndefinedNamespace = new QuteCodeActionForUndefinedNamespace();
    private final QuteCodeActionForUnknownProperty codeActionForUnknownProperty;
    private final QuteCodeActionForUnknownMethod codeActionForUnknownMethod;
    private final QuteCodeActionForUndefinedSectionTag codeActionForUndefinedSectionTag;
    private final QuteCodeActionForMissingInputs codeActionForMissingInputs;
    private final QuteCodeActionForMissingParameters codeActionForMissingParameters;
    private final QuteCodeActionForUnterminatedSection codeActionForUnterminatedSection;
    private final QuteCodeActionForMismatchSectionTag codeActionForMismatchSectionTag;

    public QuteCodeActions(QuteProjectRegistry projectRegistry) {
        this.codeActionForUnknownProperty = new QuteCodeActionForUnknownProperty(projectRegistry);
        this.codeActionForUnknownMethod = new QuteCodeActionForUnknownMethod(projectRegistry);
        this.codeActionForUndefinedSectionTag = new QuteCodeActionForUndefinedSectionTag();
        this.codeActionForMissingInputs = new QuteCodeActionForMissingInputs(projectRegistry);
        this.codeActionForMissingParameters = new QuteCodeActionForMissingParameters();
        this.codeActionForUnterminatedSection = new QuteCodeActionForUnterminatedSection();
        this.codeActionForMismatchSectionTag = new QuteCodeActionForMismatchSectionTag();
    }

    public CompletableFuture<List<CodeAction>> doCodeActions(Template template, CodeActionContext context, Range range, QuteTemplateJavaTextEditProvider javaTextEditProvider, SharedSettings sharedSettings) {
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        List diagnostics = context.getDiagnostics();
        if (diagnostics == null || diagnostics.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ArrayList<CompletableFuture<Void>> codeActionResolveFutures = new ArrayList<CompletableFuture<Void>>();
        for (Diagnostic diagnostic : diagnostics) {
            QuteSyntaxErrorCode syntaxErrorCode;
            QuteErrorCode errorCode = QuteErrorCode.getErrorCode((Either<String, Integer>)diagnostic.getCode());
            if (errorCode != null) {
                try {
                    CodeActionRequest request = new CodeActionRequest(template, range.getEnd(), diagnostic, javaTextEditProvider, sharedSettings);
                    switch (errorCode) {
                        case UndefinedObject: {
                            this.codeActionForUndefinedObject.doCodeActions(request, codeActionResolveFutures, codeActions);
                            break;
                        }
                        case UndefinedNamespace: {
                            this.codeActionForUndefinedNamespace.doCodeActions(request, codeActionResolveFutures, codeActions);
                            break;
                        }
                        case UnknownProperty: {
                            this.codeActionForUnknownProperty.doCodeActions(request, codeActionResolveFutures, codeActions);
                            break;
                        }
                        case UnknownMethod: {
                            this.codeActionForUnknownMethod.doCodeActions(request, codeActionResolveFutures, codeActions);
                            break;
                        }
                        case UndefinedSectionTag: {
                            this.codeActionForUndefinedSectionTag.doCodeActions(request, codeActionResolveFutures, codeActions);
                            break;
                        }
                        case MissingExpectedInput: {
                            this.codeActionForMissingInputs.doCodeActions(request, codeActionResolveFutures, codeActions);
                            break;
                        }
                        case MissingRequiredParameter: {
                            this.codeActionForMissingParameters.doCodeActions(request, codeActionResolveFutures, codeActions);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.SEVERE, "Failed creating CodeAction Request", e);
                    return NO_CODEACTION;
                }
            }
            if ((syntaxErrorCode = QuteSyntaxErrorCode.getErrorCode((Either<String, Integer>)diagnostic.getCode())) == null) continue;
            try {
                CodeActionRequest request = new CodeActionRequest(template, range.getEnd(), diagnostic, javaTextEditProvider, sharedSettings);
                switch (syntaxErrorCode) {
                    case UNTERMINATED_SECTION: {
                        this.codeActionForUnterminatedSection.doCodeActions(request, codeActionResolveFutures, codeActions);
                        break;
                    }
                    case SECTION_END_DOES_NOT_MATCH_START: 
                    case SECTION_BLOCK_END_DOES_NOT_MATCH_START: {
                        this.codeActionForMismatchSectionTag.doCodeActions(request, codeActionResolveFutures, codeActions);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, "Failed creating Syntax CodeAction Request", e);
                return NO_CODEACTION;
            }
        }
        boolean canUpdateConfiguration = sharedSettings.getCommandCapabilities().isCommandSupported("qute.command.configuration.update");
        if (canUpdateConfiguration) {
            QuteCodeActions.doCodeActionToDisableValidation(template, diagnostics, codeActions);
        }
        CompletableFuture[] registrationsArray = new CompletableFuture[codeActionResolveFutures.size()];
        codeActionResolveFutures.toArray(registrationsArray);
        return CompletableFuture.allOf(registrationsArray).thenApply(_void -> codeActions);
    }

    private static void doCodeActionToDisableValidation(Template template, List<Diagnostic> diagnostics, List<CodeAction> codeActions) {
        String templateUri = template.getUri();
        String title = MessageFormat.format(EXCLUDED_VALIDATION_TITLE, template.getTemplateId());
        CodeAction disableValidationForTemplateQuickFix = AbstractQuteCodeAction.createConfigurationUpdateCodeAction(title, templateUri, QUTE_VALIDATION_EXCLUDED_SECTION, templateUri, ConfigurationItemEditType.add, diagnostics);
        codeActions.add(disableValidationForTemplateQuickFix);
        String projectUri = template.getProjectUri();
        title = MessageFormat.format(DISABLE_VALIDATION_ON_PROJECT_LEVEL_TITLE, projectUri);
        CodeAction disableValidationQuickFix = AbstractQuteCodeAction.createConfigurationUpdateCodeAction(title, templateUri, QUTE_VALIDATION_ENABLED_SECTION, false, ConfigurationItemEditType.update, diagnostics);
        codeActions.add(disableValidationQuickFix);
    }
}

