/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services;

import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.ls.commons.snippets.Snippet;
import com.redhat.qute.ls.commons.snippets.SnippetRegistryProvider;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.ParameterDeclaration;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.services.completions.CompletionRequest;
import com.redhat.qute.services.completions.QuteCompletionForTemplateIds;
import com.redhat.qute.services.completions.QuteCompletionsForExpression;
import com.redhat.qute.services.completions.QuteCompletionsForParameterDeclaration;
import com.redhat.qute.services.completions.tags.QuteCompletionForTagSection;
import com.redhat.qute.services.completions.tags.QuteCompletionsForSnippets;
import com.redhat.qute.settings.QuteCompletionSettings;
import com.redhat.qute.settings.QuteFormattingSettings;
import com.redhat.qute.settings.QuteNativeSettings;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class QuteCompletions {
    private static final Logger LOGGER = Logger.getLogger(QuteCompletions.class.getName());
    public static final CompletionList EMPTY_COMPLETION = new CompletionList();
    public static final CompletableFuture<CompletionList> EMPTY_FUTURE_COMPLETION = CompletableFuture.completedFuture(EMPTY_COMPLETION);
    private final QuteCompletionsForParameterDeclaration completionsForParameterDeclaration;
    private final QuteCompletionsForExpression completionForExpression;
    private final QuteCompletionsForSnippets<Snippet> completionsForSnippets;
    private final QuteCompletionForTagSection completionForTagSection;
    private final QuteCompletionForTemplateIds completionForTemplateIds;

    public QuteCompletions(QuteProjectRegistry projectRegistry, SnippetRegistryProvider<Snippet> snippetRegistryProvider) {
        this.completionsForParameterDeclaration = new QuteCompletionsForParameterDeclaration(projectRegistry);
        this.completionsForSnippets = new QuteCompletionsForSnippets<Snippet>(snippetRegistryProvider);
        this.completionForTagSection = new QuteCompletionForTagSection(this.completionsForSnippets);
        this.completionForExpression = new QuteCompletionsForExpression(this.completionForTagSection, projectRegistry);
        this.completionForTemplateIds = new QuteCompletionForTemplateIds();
    }

    public CompletableFuture<CompletionList> doComplete(Template template, Position position, QuteCompletionSettings completionSettings, QuteFormattingSettings formattingSettings, QuteNativeSettings nativeImagesSettings, CancelChecker cancelChecker) {
        CompletionRequest completionRequest = null;
        try {
            completionRequest = new CompletionRequest(template, position, completionSettings, formattingSettings);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Creation of CompletionRequest failed", e);
            return EMPTY_FUTURE_COMPLETION;
        }
        Node node = completionRequest.getNode();
        if (node == null) {
            return EMPTY_FUTURE_COMPLETION;
        }
        String text = template.getText();
        int offset = completionRequest.getOffset();
        if (node.getKind() == NodeKind.Expression || node.getKind() == NodeKind.ExpressionParts || node.getKind() == NodeKind.ExpressionPart) {
            Expression expression = null;
            Node nodeExpression = null;
            if (node.getKind() == NodeKind.Expression) {
                expression = (Expression)node;
            } else if (node.getKind() == NodeKind.ExpressionParts) {
                nodeExpression = node;
                expression = ((Parts)node).getParent();
            } else if (node.getKind() == NodeKind.ExpressionPart) {
                nodeExpression = node;
                expression = ((Part)node).getParent().getParent();
            }
            if (expression != null && Section.isIncludeSection(expression.getOwnerSection())) {
                return this.completionForTemplateIds.doCompleteTemplateId(completionRequest, completionSettings, formattingSettings, cancelChecker);
            }
            return this.completionForExpression.doCompleteExpression(completionRequest, expression, nodeExpression, template, offset, completionSettings, formattingSettings, nativeImagesSettings, cancelChecker);
        }
        if (node.getKind() == NodeKind.Text) {
            Section parent = node.getParentSection();
            if (parent != null && parent.isInEndTagName(offset)) {
                return EMPTY_FUTURE_COMPLETION;
            }
            int nbBrackets = 0;
            int bracketOffset = offset - 1;
            char previousChar = text.charAt(bracketOffset);
            if (previousChar == '#') {
                --bracketOffset;
            }
            while (bracketOffset >= 0 && text.charAt(bracketOffset) == '{') {
                --bracketOffset;
                ++nbBrackets;
            }
            if (nbBrackets > 0) {
                if (nbBrackets % 2 != 0) {
                    return this.completionForExpression.doCompleteExpression(completionRequest, null, node, template, offset, completionSettings, formattingSettings, nativeImagesSettings, cancelChecker);
                }
                return EMPTY_FUTURE_COMPLETION;
            }
        } else {
            if (node.getKind() == NodeKind.ParameterDeclaration) {
                return this.completionsForParameterDeclaration.doCollectJavaClassesSuggestions((ParameterDeclaration)node, template, offset, completionSettings, cancelChecker);
            }
            if (node.getKind() == NodeKind.Section) {
                return this.completionForTagSection.doCompleteTagSection(completionRequest, completionSettings, formattingSettings, cancelChecker);
            }
            if (node.getKind() == NodeKind.Parameter) {
                Parameter parameter = (Parameter)node;
                if (this.isJavaModelCompletionAllowed(parameter, offset)) {
                    return this.completionForExpression.doCompleteExpression(completionRequest, null, null, template, offset, completionSettings, formattingSettings, nativeImagesSettings, cancelChecker);
                }
                if (Section.isIncludeSection(parameter.getOwnerSection())) {
                    return this.completionForTemplateIds.doCompleteTemplateId(completionRequest, completionSettings, formattingSettings, cancelChecker);
                }
            }
        }
        return this.collectSnippetSuggestions(completionRequest);
    }

    public boolean isJavaModelCompletionAllowed(Parameter parameter, int offset) {
        if (Section.isCaseSection(parameter.getOwnerSection())) {
            return true;
        }
        return parameter.isAfterAssign(offset);
    }

    private CompletableFuture<CompletionList> collectSnippetSuggestions(CompletionRequest completionRequest) {
        Template template = completionRequest.getTemplate();
        QuteProject project = template.getProject();
        HashSet<CompletionItem> completionItems = new HashSet<CompletionItem>();
        if (project != null) {
            project.collectUserTagSuggestions(completionRequest, "", null, completionItems);
        }
        this.completionsForSnippets.collectSnippetSuggestions(completionRequest, "", null, completionItems);
        CompletionList list = new CompletionList();
        list.setItems(completionItems.stream().collect(Collectors.toList()));
        return CompletableFuture.completedFuture(list);
    }
}

