/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services;

import com.redhat.qute.commons.JavaElementInfo;
import com.redhat.qute.commons.JavaElementKind;
import com.redhat.qute.commons.JavaMemberInfo;
import com.redhat.qute.commons.QuteJavaDefinitionParams;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.parser.expression.MethodPart;
import com.redhat.qute.parser.expression.ObjectPart;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.expression.PropertyPart;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.ParameterDeclaration;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionKind;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.template.sections.CaseSection;
import com.redhat.qute.parser.template.sections.IncludeSection;
import com.redhat.qute.parser.template.sections.WhenSection;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.tags.ObjectPartCollector;
import com.redhat.qute.project.tags.UserTag;
import com.redhat.qute.project.tags.UserTagParameter;
import com.redhat.qute.services.QuteCompletableFutures;
import com.redhat.qute.services.definition.DefinitionRequest;
import com.redhat.qute.utils.QutePositionUtility;
import com.redhat.qute.utils.QuteSearchUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class QuteDefinition {
    private static final Logger LOGGER = Logger.getLogger(QuteDefinition.class.getName());
    private static CompletableFuture<List<? extends LocationLink>> NO_DEFINITION = CompletableFuture.completedFuture(Collections.emptyList());

    QuteDefinition() {
    }

    public CompletableFuture<List<? extends LocationLink>> findDefinition(Template template, Position position, CancelChecker cancelChecker) {
        try {
            DefinitionRequest definitionRequest = new DefinitionRequest(template, position);
            Node node = definitionRequest.getNode();
            if (node == null) {
                return NO_DEFINITION;
            }
            int offset = definitionRequest.getOffset();
            switch (node.getKind()) {
                case Section: {
                    return this.findDefinitionFromSection(offset, (Section)node, template, cancelChecker);
                }
                case ParameterDeclaration: {
                    return this.findDefinitionFromParameterDeclaration(offset, (ParameterDeclaration)node, template, cancelChecker);
                }
                case Expression: {
                    return this.findDefinitionFromExpression(offset, (Expression)node, template, cancelChecker);
                }
                case ExpressionPart: {
                    Part part = (Part)node;
                    return this.findDefinitionFromPart(part, template, cancelChecker);
                }
                case Parameter: {
                    return this.findDefinitionFromParameter(offset, (Parameter)node, template, cancelChecker);
                }
            }
            return NO_DEFINITION;
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Failed creating DefinitionRequest", e);
            return NO_DEFINITION;
        }
    }

    private CompletableFuture<List<? extends LocationLink>> findDefinitionFromSection(int offset, Section sectionTag, Template template, CancelChecker cancelChecker) throws BadLocationException {
        Expression expression;
        Parameter parameter;
        ArrayList<LocationLink> locations = new ArrayList<LocationLink>();
        if (!QuteDefinition.findDefinitionFromStartEndTagSection(offset, sectionTag, template, locations) && sectionTag.isInParameters(offset) && (parameter = sectionTag.getParameterAtOffset(offset)) != null && (expression = parameter.getJavaTypeExpression()) != null) {
            return this.findDefinitionFromExpression(offset, expression, template, cancelChecker);
        }
        return CompletableFuture.completedFuture(locations);
    }

    private static boolean findDefinitionFromStartEndTagSection(int offset, Section section, Template template, List<LocationLink> locations) {
        if (section.isInStartTagName(offset)) {
            QuteProject project;
            int locationsLength = locations.size();
            if (section.getSectionKind() == SectionKind.CUSTOM && (project = template.getProject()) != null) {
                String tagName = section.getTag();
                UserTag userTag = project.findUserTag(tagName);
                if (userTag != null) {
                    String userTagUri = userTag.getUri();
                    Range targetRange = new Range(new Position(0, 0), new Position(0, 0));
                    Range originRange = QutePositionUtility.selectStartTagName(section);
                    locations.add(new LocationLink(userTagUri, targetRange, targetRange, originRange));
                } else {
                    Range originRange = null;
                    for (Node parent = section.getParent(); parent != null; parent = parent.getParent()) {
                        IncludeSection includeSection;
                        List<Parameter> parameters;
                        Section parentSection;
                        if (parent.getKind() != NodeKind.Section || (parentSection = (Section)parent).getSectionKind() != SectionKind.INCLUDE || (parameters = project.findInsertTagParameter((includeSection = (IncludeSection)parentSection).getReferencedTemplateId(), tagName)) == null) continue;
                        for (Parameter index : parameters) {
                            String linkedTemplateUri = index.getOwnerTemplate().getUri();
                            Range linkedTargetRange = QutePositionUtility.selectParameterName(index);
                            if (originRange == null) {
                                originRange = QutePositionUtility.selectStartTagName(section);
                            }
                            locations.add(new LocationLink(linkedTemplateUri, linkedTargetRange, linkedTargetRange, originRange));
                        }
                    }
                }
            }
            if (section.hasEndTag() && locationsLength == locations.size()) {
                Range originRange = QutePositionUtility.selectStartTagName(section);
                Range targetRange = QutePositionUtility.selectEndTagName(section);
                locations.add(new LocationLink(template.getUri(), targetRange, targetRange, originRange));
            }
            return true;
        }
        if (section.isInEndTagName(offset)) {
            if (section.hasStartTag()) {
                Range originRange = QutePositionUtility.selectEndTagName(section);
                Range targetRange = QutePositionUtility.selectStartTagName(section);
                locations.add(new LocationLink(template.getUri(), targetRange, targetRange, originRange));
            }
            return true;
        }
        return false;
    }

    private CompletableFuture<List<? extends LocationLink>> findDefinitionFromParameterDeclaration(int offset, ParameterDeclaration parameterDeclaration, Template template, CancelChecker cancelChecker) {
        ParameterDeclaration.JavaTypeRangeOffset range;
        QuteProject project = template.getProject();
        if (project != null && parameterDeclaration.isInJavaTypeName(offset) && (range = parameterDeclaration.getJavaTypeNameRange(offset)) != null) {
            String className = template.getText(range);
            QuteJavaDefinitionParams params = new QuteJavaDefinitionParams(className, project.getUri());
            return this.findJavaDefinition(params, project, cancelChecker, () -> QutePositionUtility.createRange(range, template));
        }
        return NO_DEFINITION;
    }

    private CompletableFuture<List<? extends LocationLink>> findJavaDefinition(QuteJavaDefinitionParams params, QuteProject project, CancelChecker cancelChecker, Supplier<Range> originSelectionRangeProvider) {
        return project.getProjectRegistry().getJavaDefinition(params).thenApply(location -> {
            cancelChecker.checkCanceled();
            if (location != null) {
                String targetUri = location.getUri();
                Range targetRange = location.getRange();
                Range originSelectionRange = (Range)originSelectionRangeProvider.get();
                LocationLink locationLink = new LocationLink(targetUri, targetRange, targetRange, originSelectionRange);
                return Arrays.asList(locationLink);
            }
            return Collections.emptyList();
        });
    }

    private CompletableFuture<List<? extends LocationLink>> findDefinitionFromExpression(int offset, Expression expression, Template template, CancelChecker cancelChecker) {
        Node expressionNode = expression.findNodeExpressionAt(offset);
        if (expressionNode != null && expressionNode.getKind() == NodeKind.ExpressionPart) {
            Part part = (Part)expressionNode;
            return this.findDefinitionFromPart(part, template, cancelChecker);
        }
        return NO_DEFINITION;
    }

    private CompletableFuture<List<? extends LocationLink>> findDefinitionFromPart(Part part, Template template, CancelChecker cancelChecker) {
        String namespace = part.getNamespace();
        if (namespace != null) {
            return this.findDefinitionFromPartWithNamespace(namespace, part, template, cancelChecker);
        }
        switch (part.getPartKind()) {
            case Object: {
                return this.findDefinitionFromObjectPart((ObjectPart)part, template, cancelChecker);
            }
            case Property: {
                return this.findDefinitionFromPropertyPart((PropertyPart)part, template, cancelChecker);
            }
            case Method: {
                return this.findDefinitionFromPropertyPart((MethodPart)part, template, cancelChecker);
            }
        }
        return NO_DEFINITION;
    }

    private CompletableFuture<List<? extends LocationLink>> findDefinitionFromPartWithNamespace(String namespace, Part part, Template template, CancelChecker cancelChecker) {
        QuteProject project = template.getProject();
        if ("data".equals(namespace)) {
            ParameterDeclaration parameterDeclaration = template.findInParameterDeclarationByAlias(part.getPartName());
            if (parameterDeclaration != null) {
                String targetUri = template.getUri();
                Range targetRange = QutePositionUtility.selectAlias(parameterDeclaration);
                Range originSelectionRange = QutePositionUtility.createRange(part);
                LocationLink locationLink = new LocationLink(targetUri, targetRange, targetRange, originSelectionRange);
                return CompletableFuture.completedFuture(Arrays.asList(locationLink));
            }
            if (project != null) {
                return this.findDefinitionFromParameterDataModel(part, template, project, cancelChecker);
            }
            return NO_DEFINITION;
        }
        if (project != null) {
            return project.findJavaElementWithNamespace(namespace, part.getPartName()).thenCompose(member -> {
                cancelChecker.checkCanceled();
                return this.findDefinitionFromJavaMember((JavaElementInfo)member, part, project, cancelChecker);
            });
        }
        return NO_DEFINITION;
    }

    private CompletableFuture<List<? extends LocationLink>> findDefinitionFromObjectPart(ObjectPart part, Template template, CancelChecker cancelChecker) {
        Parameter parameter = part.getOwnerParameter();
        if (parameter != null && CaseSection.isCaseSection(parameter.getOwnerSection())) {
            return this.findDefinitionFromParameterCaseSection(parameter, (CaseSection)parameter.getOwnerSection(), template, cancelChecker);
        }
        ArrayList locations = new ArrayList();
        QuteSearchUtils.searchDeclaredObject(part, (node, range) -> {
            String targetUri = node.getOwnerTemplate().getUri();
            Range targetRange = range;
            Range originSelectionRange = QutePositionUtility.createRange(part);
            LocationLink locationLink = new LocationLink(targetUri, targetRange, targetRange, originSelectionRange);
            locations.add(locationLink);
        }, false, cancelChecker);
        if (!locations.isEmpty()) {
            return CompletableFuture.completedFuture(locations);
        }
        QuteProject project = template.getProject();
        if (project != null) {
            return this.findDefinitionFromParameterDataModel(part, template, project, cancelChecker);
        }
        return NO_DEFINITION;
    }

    private CompletableFuture<List<? extends LocationLink>> findDefinitionFromParameterCaseSection(Parameter parameter, CaseSection caseSection, Template template, CancelChecker cancelChecker) {
        JavaMemberInfo member;
        ResolvedJavaTypeInfo whenJavaType;
        Section whenSection = caseSection.getParentSection();
        if (!Section.isWhenSection(whenSection)) {
            return NO_DEFINITION;
        }
        if (caseSection.isCaseOperator(parameter) && caseSection.getParameters().size() > 1) {
            return NO_DEFINITION;
        }
        QuteProject project = template.getProject();
        if (project == null) {
            return NO_DEFINITION;
        }
        Parameter value = ((WhenSection)whenSection).getValueParameter();
        if (value != null && !QuteCompletableFutures.isResolvingJavaTypeOrNull(whenJavaType = project.resolveJavaTypeSync(value)) && whenJavaType.isEnum() && (member = project.findMember(whenJavaType, parameter.getName())) != null) {
            QuteJavaDefinitionParams params = new QuteJavaDefinitionParams(member.getSourceType(), project.getUri());
            params.setSourceField(member.getName());
            return this.findJavaDefinition(params, project, cancelChecker, () -> QutePositionUtility.selectParameterName(parameter));
        }
        return NO_DEFINITION;
    }

    private CompletableFuture<List<? extends LocationLink>> findDefinitionFromParameterDataModel(Part part, Template template, QuteProject project, CancelChecker cancelChecker) {
        return template.getParameterDataModel(part.getPartName()).thenCompose(parameter -> {
            cancelChecker.checkCanceled();
            if (parameter != null) {
                QuteJavaDefinitionParams params = parameter.toJavaDefinitionParams(project.getUri());
                return this.findJavaDefinition(params, project, cancelChecker, () -> QutePositionUtility.createRange(part));
            }
            return project.findGlobalVariableJavaElement(part.getPartName()).thenCompose(member -> {
                cancelChecker.checkCanceled();
                return this.findDefinitionFromJavaMember((JavaElementInfo)member, part, project, cancelChecker);
            });
        });
    }

    private CompletableFuture<List<? extends LocationLink>> findDefinitionFromPropertyPart(Part part, Template template, CancelChecker cancelChecker) {
        QuteProject project = template.getProject();
        if (project != null) {
            Parts parts = part.getParent();
            Part previousPart = parts.getPreviousPart(part);
            return project.resolveJavaType(previousPart).thenCompose(previousResolvedType -> {
                cancelChecker.checkCanceled();
                if (previousResolvedType != null) {
                    return this.findDefinitionFromPropertyPart(part, project, (ResolvedJavaTypeInfo)previousResolvedType, cancelChecker);
                }
                return NO_DEFINITION;
            });
        }
        return NO_DEFINITION;
    }

    private CompletableFuture<List<? extends LocationLink>> findDefinitionFromPropertyPart(Part part, QuteProject project, ResolvedJavaTypeInfo previousResolvedType, CancelChecker cancelChecker) {
        JavaMemberInfo member = project.findMember(previousResolvedType, part.getPartName());
        return this.findDefinitionFromJavaMember(member, part, project, cancelChecker);
    }

    private CompletableFuture<List<? extends LocationLink>> findDefinitionFromJavaMember(JavaElementInfo member, Part part, QuteProject project, CancelChecker cancelChecker) {
        String sourceType;
        if (member == null) {
            return NO_DEFINITION;
        }
        String string = sourceType = member.getJavaElementKind() == JavaElementKind.TYPE ? member.getName() : ((JavaMemberInfo)member).getSourceType();
        if (sourceType == null) {
            return NO_DEFINITION;
        }
        QuteJavaDefinitionParams params = new QuteJavaDefinitionParams(sourceType, project.getUri());
        if (member != null) {
            switch (member.getJavaElementKind()) {
                case FIELD: {
                    params.setSourceField(member.getName());
                    break;
                }
                case METHOD: {
                    params.setSourceMethod(member.getName());
                    break;
                }
            }
        }
        return this.findJavaDefinition(params, project, cancelChecker, () -> QutePositionUtility.createRange(part));
    }

    private CompletableFuture<List<? extends LocationLink>> findDefinitionFromParameter(int offset, Parameter parameter, Template template, CancelChecker cancelChecker) {
        if (!parameter.isInName(offset)) {
            return NO_DEFINITION;
        }
        Section section = parameter.getOwnerSection();
        if (section == null || section.getSectionKind() != SectionKind.CUSTOM) {
            return NO_DEFINITION;
        }
        QuteProject project = template.getProject();
        if (project == null) {
            return NO_DEFINITION;
        }
        UserTag userTag = project.findUserTag(section.getTag());
        if (userTag == null) {
            return NO_DEFINITION;
        }
        UserTagParameter userTagParameter = userTag.findParameter(parameter.getName());
        if (userTagParameter == null) {
            return NO_DEFINITION;
        }
        ObjectPartCollector collector = new ObjectPartCollector(parameter.getName());
        userTag.getTemplate().accept(collector);
        ArrayList<LocationLink> locations = new ArrayList<LocationLink>();
        for (ObjectPart part : collector.getObjectParts()) {
            String targetUri = part.getOwnerTemplate().getUri();
            Range targetRange = QutePositionUtility.createRange(part);
            Range originSelectionRange = QutePositionUtility.selectParameterName(parameter);
            LocationLink locationLink = new LocationLink(targetUri, targetRange, targetRange, originSelectionRange);
            locations.add(locationLink);
        }
        return CompletableFuture.completedFuture(locations);
    }
}

