/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services;

import com.redhat.qute.commons.InvalidMethodReason;
import com.redhat.qute.commons.JavaElementKind;
import com.redhat.qute.commons.JavaMemberInfo;
import com.redhat.qute.commons.JavaMethodInfo;
import com.redhat.qute.commons.JavaParameterInfo;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.commons.jaxrs.JaxRsParamKind;
import com.redhat.qute.commons.jaxrs.RestParam;
import com.redhat.qute.parser.expression.MethodPart;
import com.redhat.qute.parser.expression.NamespacePart;
import com.redhat.qute.parser.expression.ObjectPart;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.expression.PropertyPart;
import com.redhat.qute.parser.template.CaseOperator;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.JavaTypeInfoProvider;
import com.redhat.qute.parser.template.LiteralSupport;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Operator;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.ParameterDeclaration;
import com.redhat.qute.parser.template.RangeOffset;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionKind;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.template.sections.CaseSection;
import com.redhat.qute.parser.template.sections.IncludeSection;
import com.redhat.qute.parser.template.sections.LoopSection;
import com.redhat.qute.project.JavaMemberResult;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.project.tags.UserTag;
import com.redhat.qute.project.tags.UserTagParameter;
import com.redhat.qute.services.QuteCompletableFutures;
import com.redhat.qute.services.ResolvingJavaTypeContext;
import com.redhat.qute.services.diagnostics.CollectHtmlInputNamesVisitor;
import com.redhat.qute.services.diagnostics.DiagnosticDataFactory;
import com.redhat.qute.services.diagnostics.JavaBaseTypeOfPartData;
import com.redhat.qute.services.diagnostics.QuteDiagnosticsForSyntax;
import com.redhat.qute.services.diagnostics.QuteErrorCode;
import com.redhat.qute.services.nativemode.JavaTypeAccessibiltyRule;
import com.redhat.qute.services.nativemode.JavaTypeFilter;
import com.redhat.qute.settings.QuteNativeSettings;
import com.redhat.qute.settings.QuteValidationSettings;
import com.redhat.qute.utils.QutePositionUtility;
import com.redhat.qute.utils.StringUtils;
import com.redhat.qute.utils.UserTagUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class QuteDiagnostics {
    private static final Logger LOGGER = Logger.getLogger(QuteDiagnostics.class.getName());
    private static final String FORM_SECTION_TAG = "form";
    private final QuteDiagnosticsForSyntax diagnosticsForSyntax;
    private final QuteProjectRegistry projectRegistry;

    public QuteDiagnostics(QuteProjectRegistry projectRegistry) {
        this.projectRegistry = projectRegistry;
        this.diagnosticsForSyntax = new QuteDiagnosticsForSyntax();
    }

    public List<Diagnostic> doDiagnostics(Template template, QuteValidationSettings validationSettings, QuteNativeSettings nativeImagesSettings, ResolvingJavaTypeContext resolvingJavaTypeContext, CancelChecker cancelChecker) {
        cancelChecker.checkCanceled();
        if (validationSettings == null) {
            validationSettings = QuteValidationSettings.DEFAULT;
        }
        if (!validationSettings.canValidate(template.getUri())) {
            return Collections.emptyList();
        }
        if (!resolvingJavaTypeContext.isProjectResolved()) {
            LOGGER.log(Level.INFO, "Resolving project for the template '" + template.getUri() + "'.");
        } else if (!resolvingJavaTypeContext.isDataModelTemplateResolved()) {
            LOGGER.log(Level.INFO, "Resolving data model (@CheckedTemplate, Template field) for the template '" + template.getUri() + "'.");
        }
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        try {
            this.diagnosticsForSyntax.validateWithRealQuteParser(template, diagnostics);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while validating Qute syntax'" + template.getUri() + "'.", e);
        }
        try {
            this.validateDataModel(template, template, validationSettings, nativeImagesSettings, resolvingJavaTypeContext, new ResolutionContext(), diagnostics);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while validating Qute data model'" + template.getUri() + "'.", e);
        }
        cancelChecker.checkCanceled();
        return diagnostics;
    }

    private void validateDataModel(Node parent, Template template, QuteValidationSettings validationSettings, QuteNativeSettings nativeImagesSettings, ResolvingJavaTypeContext resolvingJavaTypeContext, ResolutionContext currentContext, List<Diagnostic> diagnostics) {
        QuteProject project = template.getProject();
        String projectUri = project != null ? project.getUri() : null;
        JavaTypeFilter filter = this.projectRegistry.getJavaTypeFilter(projectUri, nativeImagesSettings);
        ResolutionContext previousContext = currentContext;
        List<Node> children = parent.getChildren();
        for (Node node : children) {
            block0 : switch (node.getKind()) {
                case ParameterDeclaration: {
                    if (project == null) break;
                    ParameterDeclaration parameter = (ParameterDeclaration)node;
                    this.validateParameterDeclaration(parameter, template, project, resolvingJavaTypeContext, currentContext, diagnostics);
                    break;
                }
                case Section: {
                    Section section = (Section)node;
                    if (QuteDiagnostics.canChangeContext(section)) {
                        currentContext = new ResolutionContext(currentContext);
                    }
                    List<Parameter> parameters = section.getParameters();
                    boolean checkValidOperator = section.getSectionKind() == SectionKind.IF;
                    boolean shouldBeAnOperator = false;
                    for (Parameter parameter : parameters) {
                        if (shouldBeAnOperator) {
                            String operatorName = parameter.getName();
                            if (!section.isValidOperator(operatorName)) {
                                Range range = QutePositionUtility.createRange(parameter);
                                Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.InvalidOperator, operatorName, section.getTag(), section.getAllowedOperators().stream().map(Operator::getName).collect(Collectors.joining(",", "[", "]")));
                                diagnostics.add(diagnostic);
                            }
                        } else {
                            Expression expression = parameter.getJavaTypeExpression();
                            if (expression != null) {
                                ResolvedJavaTypeInfo result = this.validateExpression(expression, section, template, validationSettings, filter, previousContext, resolvingJavaTypeContext, diagnostics);
                                switch (section.getSectionKind()) {
                                    case FOR: 
                                    case EACH: {
                                        String alias = ((LoopSection)section).getAlias();
                                        currentContext.put(alias, result);
                                        break;
                                    }
                                    case WITH: {
                                        currentContext.setWithObject(result);
                                        break;
                                    }
                                    case LET: 
                                    case SET: {
                                        currentContext.put(parameter.getName(), result);
                                        break;
                                    }
                                    case SWITCH: 
                                    case WHEN: {
                                        currentContext.setWhenObject(result);
                                        break;
                                    }
                                }
                            }
                        }
                        shouldBeAnOperator = checkValidOperator && !shouldBeAnOperator;
                    }
                    switch (section.getSectionKind()) {
                        case INCLUDE: {
                            QuteDiagnostics.validateIncludeSection((IncludeSection)section, project, diagnostics);
                            break;
                        }
                        case CASE: 
                        case IS: {
                            Section parentSection = section.getParentSection();
                            if (!Section.isWhenSection(parentSection)) {
                                Range range = QutePositionUtility.selectStartTagName(section);
                                Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.InvalidParentInCaseSection, section.getTag());
                                diagnostics.add(diagnostic);
                                break;
                            }
                            ResolvedJavaTypeInfo whenJavaType = currentContext.whenObject;
                            if (whenJavaType == null) break block0;
                            this.validateCaseSectionParameters((CaseSection)section, parentSection, template, whenJavaType, project, diagnostics);
                            break;
                        }
                        default: {
                            QuteDiagnostics.validateSectionTag(section, template, resolvingJavaTypeContext, diagnostics);
                            break;
                        }
                    }
                    break;
                }
                case Expression: {
                    this.validateExpression((Expression)node, null, template, validationSettings, filter, previousContext, resolvingJavaTypeContext, diagnostics);
                    break;
                }
            }
            this.validateDataModel(node, template, validationSettings, nativeImagesSettings, resolvingJavaTypeContext, currentContext, diagnostics);
        }
    }

    private void validateParameterDeclaration(ParameterDeclaration parameter, Template template, QuteProject project, ResolvingJavaTypeContext resolvingJavaTypeContext, ResolutionContext currentContext, List<Diagnostic> diagnostics) {
        String javaTypeToResolve = parameter.getJavaType();
        if (!StringUtils.isEmpty(javaTypeToResolve)) {
            List<ParameterDeclaration.JavaTypeRangeOffset> classNameRanges = parameter.getJavaTypeNameRanges();
            for (RangeOffset rangeOffset : classNameRanges) {
                String className = template.getText(rangeOffset);
                ResolvedJavaTypeInfo resolvedJavaType = this.resolveJavaType(className, project, resolvingJavaTypeContext);
                if (resolvedJavaType == null) {
                    Range range = QutePositionUtility.createRange(rangeOffset, template);
                    Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.UnknownType, className);
                    diagnostics.add(diagnostic);
                    continue;
                }
                if (QuteCompletableFutures.isResolvingJavaType(resolvedJavaType)) continue;
                currentContext.put(javaTypeToResolve, resolvedJavaType);
            }
        }
    }

    private static void validateSectionTag(Section section, Template template, ResolvingJavaTypeContext resolvingJavaTypeContext, List<Diagnostic> diagnostics) {
        String tagName = section.getTag();
        if (StringUtils.isEmpty(tagName) || section.isOrphanEndTag()) {
            return;
        }
        SectionKind sectionKind = section.getSectionKind();
        if (sectionKind == SectionKind.CUSTOM) {
            if (!resolvingJavaTypeContext.isBinaryUserTagResolved()) {
                return;
            }
            QuteProject project = template.getProject();
            if (project != null) {
                UserTag userTag = project.findUserTag(tagName);
                if (userTag != null) {
                    ArrayList<String> existingParameters = new ArrayList<String>();
                    for (Parameter parameter : section.getParameters()) {
                        String paramName;
                        String string = paramName = !parameter.hasValueAssigned() ? "it" : parameter.getName();
                        if (existingParameters.contains(paramName)) {
                            Range range = QutePositionUtility.selectParameterName(parameter);
                            Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Warning, QuteErrorCode.DuplicateParameter, paramName, tagName);
                            diagnostics.add(diagnostic);
                            continue;
                        }
                        existingParameters.add(paramName);
                        UserTagParameter userTagParameter = userTag.findParameter(paramName);
                        if (userTagParameter != null) continue;
                        Range range = QutePositionUtility.selectParameterName(parameter);
                        Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Warning, QuteErrorCode.UndefinedParameter, paramName, tagName);
                        diagnostics.add(diagnostic);
                    }
                    ArrayList<String> missingRequiredParameters = new ArrayList<String>();
                    for (UserTagParameter parameter : userTag.getParameters()) {
                        String paramName = parameter.getName();
                        if ("nested-content".equals(paramName) || !parameter.isRequired().booleanValue() || existingParameters.contains(paramName)) continue;
                        missingRequiredParameters.add(paramName);
                    }
                    if (!missingRequiredParameters.isEmpty()) {
                        String string = missingRequiredParameters.stream().collect(Collectors.joining("`, `", "`", "`"));
                        Range range = QutePositionUtility.selectStartTagName(section);
                        Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Warning, QuteErrorCode.MissingRequiredParameter, string, tagName);
                        diagnostics.add(diagnostic);
                    }
                    return;
                }
                for (Node parent = section.getParent(); parent != null; parent = parent.getParent()) {
                    IncludeSection includeSection;
                    List<Parameter> parameters;
                    Section parentSection;
                    if (parent.getKind() != NodeKind.Section || (parentSection = (Section)parent).getSectionKind() != SectionKind.INCLUDE || (parameters = project.findInsertTagParameter((includeSection = (IncludeSection)parentSection).getReferencedTemplateId(), tagName)) == null) continue;
                    return;
                }
                Range range = QutePositionUtility.selectStartTagName(section);
                Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.UndefinedSectionTag, tagName);
                diagnostics.add(diagnostic);
            }
        }
    }

    private static boolean canChangeContext(Section section) {
        SectionKind sectionKind = section.getSectionKind();
        return sectionKind == SectionKind.EACH || sectionKind == SectionKind.FOR || sectionKind == SectionKind.LET || sectionKind == SectionKind.SET || sectionKind == SectionKind.WITH || sectionKind == SectionKind.SWITCH || sectionKind == SectionKind.WHEN;
    }

    private static void validateIncludeSection(IncludeSection includeSection, QuteProject project, List<Diagnostic> diagnostics) {
        Parameter templateParameter = includeSection.getTemplateParameter();
        if (templateParameter != null) {
            Path templateFile;
            if (project != null && ((templateFile = includeSection.getReferencedTemplateFile()) == null || Files.notExists(templateFile, new LinkOption[0]))) {
                Range range = QutePositionUtility.createRange(templateParameter);
                Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.TemplateNotFound, templateParameter.getValue());
                diagnostics.add(diagnostic);
            }
        } else {
            Range range = QutePositionUtility.selectStartTagName(includeSection);
            Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.TemplateNotDefined, new Object[0]);
            diagnostics.add(diagnostic);
        }
    }

    private static void validateRenardeFormSectionParameters(Section section, JavaMemberInfo javaMemberInfo, String baseTypeSignature, List<Diagnostic> diagnostics) {
        if (javaMemberInfo == null) {
            return;
        }
        JavaMethodInfo method = (JavaMethodInfo)javaMemberInfo;
        Collection<RestParam> restParams = method.getRestParameters();
        if (restParams.isEmpty()) {
            return;
        }
        List formParams = restParams.stream().filter(p -> p.getParameterKind() == JaxRsParamKind.FORM).collect(Collectors.toList());
        if (formParams.isEmpty()) {
            return;
        }
        CollectHtmlInputNamesVisitor visitor = new CollectHtmlInputNamesVisitor();
        section.accept(visitor);
        List<String> existingInputNames = visitor.getHtmlInputNames();
        ArrayList<String> missingRequiredInputNames = new ArrayList<String>();
        for (RestParam param : formParams) {
            if (!param.isRequired() || existingInputNames != null && existingInputNames.contains(param.getName())) continue;
            missingRequiredInputNames.add(param.getName());
        }
        if (!missingRequiredInputNames.isEmpty()) {
            String diagnosticMessageArg = missingRequiredInputNames.stream().collect(Collectors.joining("`, `", "`", "`"));
            Range range = QutePositionUtility.selectStartTagName(section);
            Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Warning, QuteErrorCode.MissingExpectedInput, diagnosticMessageArg);
            diagnostic.setData((Object)new JavaBaseTypeOfPartData(baseTypeSignature));
            diagnostics.add(diagnostic);
        }
    }

    private ResolvedJavaTypeInfo validateExpression(Expression expression, Section ownerSection, Template template, QuteValidationSettings validationSettings, JavaTypeFilter filter, ResolutionContext resolutionContext, ResolvingJavaTypeContext resolvingJavaTypeContext, List<Diagnostic> diagnostics) {
        try {
            QuteProject project = template.getProject();
            String literalJavaType = expression.getLiteralJavaType();
            if (literalJavaType != null) {
                ResolvedJavaTypeInfo resolvedLiteralType;
                ResolvedJavaTypeInfo resolvedJavaTypeInfo = resolvedLiteralType = project != null ? project.resolveJavaTypeSync(literalJavaType) : null;
                if (QuteCompletableFutures.isResolvingJavaTypeOrNull(resolvedLiteralType)) {
                    return null;
                }
                return this.validateIterable(expression.getLastPart(), ownerSection, resolvedLiteralType, resolvedLiteralType.getName(), diagnostics);
            }
            ResolvedJavaTypeInfo resolvedJavaType = null;
            List<Node> expressionChildren = expression.getExpressionContent();
            for (Node expressionChild : expressionChildren) {
                if (expressionChild.getKind() != NodeKind.ExpressionParts) continue;
                Parts parts = (Parts)expressionChild;
                resolvedJavaType = this.validateExpressionParts(parts, ownerSection, template, project, validationSettings, filter, resolutionContext, resolvingJavaTypeContext, diagnostics);
            }
            return resolvedJavaType;
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while validating expression '" + expression.getContent() + "' in '" + template.getUri() + "'.", e);
            return null;
        }
    }

    private ResolvedJavaTypeInfo validateExpressionParts(Parts parts, Section ownerSection, Template template, QuteProject project, QuteValidationSettings validationSettings, JavaTypeFilter filter, ResolutionContext resolutionContext, ResolvingJavaTypeContext resolvingJavaTypeContext, List<Diagnostic> diagnostics) {
        ResolvedJavaTypeInfo baseType = null;
        String namespace = null;
        block5: for (int i = 0; i < parts.getChildCount(); ++i) {
            Part current = parts.getChild(i);
            switch (current.getPartKind()) {
                case Namespace: {
                    NamespacePart namespacePart = (NamespacePart)current;
                    namespace = this.validateNamespace(namespacePart, project, validationSettings, resolvingJavaTypeContext, diagnostics);
                    if (namespace != null) continue block5;
                    return null;
                }
                case Object: {
                    ObjectPart objectPart = (ObjectPart)current;
                    baseType = this.validateObjectPart(namespace, objectPart, ownerSection, template, project, validationSettings, resolutionContext, diagnostics, resolvingJavaTypeContext);
                    if (!QuteCompletableFutures.isResolvingJavaType(baseType)) continue block5;
                    return QuteCompletableFutures.RESOLVING_JAVA_TYPE;
                }
                case Method: 
                case Property: {
                    if (QuteCompletableFutures.isResolvingJavaType(baseType)) {
                        return QuteCompletableFutures.RESOLVING_JAVA_TYPE;
                    }
                    baseType = this.validateMemberPart(current, ownerSection, template, project, validationSettings, filter, resolutionContext, baseType, baseType, diagnostics, resolvingJavaTypeContext);
                }
            }
        }
        return baseType;
    }

    private ResolvedJavaTypeInfo resolveJavaType(String javaType, QuteProject project, ResolvingJavaTypeContext resolvingJavaTypeContext) {
        return resolvingJavaTypeContext.resolveJavaType(javaType, project);
    }

    private String validateNamespace(NamespacePart namespacePart, QuteProject project, QuteValidationSettings validationSettings, ResolvingJavaTypeContext resolvingJavaTypeContext, List<Diagnostic> diagnostics) {
        String namespace = namespacePart.getPartName();
        if ("data".equals(namespace)) {
            return namespace;
        }
        if (!resolvingJavaTypeContext.isDataModelTemplateResolved()) {
            return null;
        }
        if (project != null && !project.hasNamespace(namespace)) {
            DiagnosticSeverity severity = validationSettings.getUndefinedNamespace().getDiagnosticSeverity();
            if (severity == null) {
                return null;
            }
            Range range = QutePositionUtility.createRange(namespacePart);
            Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, severity, QuteErrorCode.UndefinedNamespace, namespacePart.getPartName());
            diagnostics.add(diagnostic);
            return null;
        }
        return namespace;
    }

    private ResolvedJavaTypeInfo validateObjectPart(String namespace, ObjectPart objectPart, Section ownerSection, Template template, QuteProject project, QuteValidationSettings validationSettings, ResolutionContext resolutionContext, List<Diagnostic> diagnostics, ResolvingJavaTypeContext resolvingJavaTypeContext) {
        Expression expression;
        if (project == null) {
            return null;
        }
        JavaMemberInfo javaMember = resolutionContext.findMemberWithObject(objectPart.getPartName(), project);
        if (javaMember != null) {
            ResolvedJavaTypeInfo resolvedJavaType = this.resolveJavaType(javaMember.getJavaElementType(), project, resolvingJavaTypeContext);
            return resolvedJavaType;
        }
        JavaTypeInfoProvider javaTypeInfo = objectPart.resolveJavaType();
        if (javaTypeInfo == null) {
            if (objectPart.isOptional()) {
                return null;
            }
            String partName = objectPart.getPartName();
            if (partName.isEmpty()) {
                return null;
            }
            String literalJavaType = LiteralSupport.getLiteralJavaType(partName);
            if (literalJavaType != null) {
                return null;
            }
            if (!resolvingJavaTypeContext.isDataModelTemplateResolved()) {
                return null;
            }
            if (UserTagUtils.isUserTag(template)) {
                return null;
            }
            if (Section.isCaseSection(ownerSection)) {
                return null;
            }
            DiagnosticSeverity severity = validationSettings.getUndefinedObject().getDiagnosticSeverity();
            if (severity == null) {
                return null;
            }
            Range range = QutePositionUtility.createRange(objectPart);
            Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, severity, QuteErrorCode.UndefinedObject, objectPart.getPartName());
            diagnostics.add(diagnostic);
            return null;
        }
        String javaTypeToResolve = javaTypeInfo.getJavaType();
        if (javaTypeToResolve == null && (expression = javaTypeInfo.getJavaTypeExpression()) != null) {
            String literalJavaType = expression.getLiteralJavaType();
            if (literalJavaType != null) {
                javaTypeToResolve = literalJavaType;
            } else {
                Part lastPart = expression.getLastPart();
                if (lastPart != null) {
                    ResolvedJavaTypeInfo alias = project.resolveJavaType(lastPart).getNow(QuteCompletableFutures.RESOLVING_JAVA_TYPE);
                    if (QuteCompletableFutures.isResolvingJavaType(alias)) {
                        return QuteCompletableFutures.RESOLVING_JAVA_TYPE;
                    }
                    if (alias == null) {
                        if (!resolvingJavaTypeContext.isDataModelTemplateResolved()) {
                            return null;
                        }
                    } else {
                        javaTypeToResolve = alias.getSignature();
                    }
                }
            }
        }
        return this.validateJavaTypePart(objectPart, ownerSection, project, diagnostics, resolvingJavaTypeContext, javaTypeToResolve, javaTypeInfo.getJavaTypeOwnerNode());
    }

    private ResolvedJavaTypeInfo validateMemberPart(Part part, Section ownerSection, Template template, QuteProject project, QuteValidationSettings validationSettings, JavaTypeFilter filter, ResolutionContext resolutionContext, ResolvedJavaTypeInfo baseType, ResolvedJavaTypeInfo iterableOfType, List<Diagnostic> diagnostics, ResolvingJavaTypeContext resolvingJavaTypeContext) {
        if (part.getPartKind() == Parts.PartKind.Method) {
            return this.validateMethodPart((MethodPart)part, ownerSection, template, project, validationSettings, filter, resolutionContext, baseType, iterableOfType, diagnostics, resolvingJavaTypeContext);
        }
        return this.validatePropertyPart((PropertyPart)part, ownerSection, template, project, resolutionContext, baseType, iterableOfType, filter, diagnostics, resolvingJavaTypeContext);
    }

    private ResolvedJavaTypeInfo validatePropertyPart(PropertyPart part, Section ownerSection, Template template, QuteProject project, ResolutionContext resolutionContext, ResolvedJavaTypeInfo baseType, ResolvedJavaTypeInfo iterableOfType, JavaTypeFilter filter, List<Diagnostic> diagnostics, ResolvingJavaTypeContext resolvingJavaTypeContext) {
        JavaTypeAccessibiltyRule javaTypeAccessibility;
        if (!QuteCompletableFutures.isValidJavaType(baseType) || project == null) {
            return null;
        }
        JavaMemberResult result = project.findProperty(part, baseType, filter.isInNativeMode());
        JavaMemberInfo javaMember = result.getMember();
        if (javaMember == null) {
            Range range = QutePositionUtility.createRange(part);
            String signature = baseType.getSignature();
            String property = part.getPartName();
            Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.UnknownProperty, property, signature);
            diagnostic.setData((Object)new JavaBaseTypeOfPartData(signature));
            diagnostics.add(diagnostic);
            return null;
        }
        if (QuteDiagnostics.canValidateMemberInNativeMode(filter, javaMember) && !JavaTypeAccessibiltyRule.ALLOWED_WITHOUT_RESTRICTION.equals(javaTypeAccessibility = filter.getJavaTypeAccessibility(baseType, resolvingJavaTypeContext.getJavaTypesSupportedInNativeMode()))) {
            if (javaTypeAccessibility == null) {
                Range range = QutePositionUtility.createRange(part);
                Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.PropertyNotSupportedInNativeMode, part.getPartName(), baseType.getSignature());
                diagnostics.add(diagnostic);
                return null;
            }
            if (!filter.isSuperClassAllowed(javaMember, baseType, javaTypeAccessibility)) {
                Range range = QutePositionUtility.createRange(part);
                Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.InheritedPropertyNotSupportedInNativeMode, part.getPartName(), baseType.getSignature());
                diagnostics.add(diagnostic);
                return null;
            }
            JavaTypeFilter.JavaMemberAccessibility javaMemberAccessibility = filter.getJavaMemberAccessibility(javaMember, javaTypeAccessibility);
            switch (javaMemberAccessibility.getKind()) {
                case FORBIDDEN_BY_TEMPLATE_DATA_IGNORE: {
                    Range range = QutePositionUtility.createRange(part);
                    Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.MethodIgnoredByTemplateData, part.getPartName(), baseType.getSignature(), javaMemberAccessibility.getIgnore());
                    diagnostics.add(diagnostic);
                    return null;
                }
                case FORBIDDEN_BY_TEMPLATE_DATA_PROPERTIES: {
                    JavaMethodInfo method = (JavaMethodInfo)javaMember;
                    Range range = QutePositionUtility.createRange(part);
                    Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.ForbiddenByTemplateDataProperties, method.getName(), baseType.getSignature(), method.getParameters().size());
                    diagnostics.add(diagnostic);
                    return null;
                }
                case FORBIDDEN_BY_REGISTER_FOR_REFLECTION_FIELDS: 
                case FORBIDDEN_BY_REGISTER_FOR_REFLECTION_METHODS: {
                    Range range = QutePositionUtility.createRange(part);
                    QuteErrorCode errorCode = javaMember.getJavaElementKind() == JavaElementKind.METHOD ? QuteErrorCode.ForbiddenByRegisterForReflectionMethods : QuteErrorCode.ForbiddenByRegisterForReflectionFields;
                    Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, errorCode, part.getPartName(), baseType.getSignature());
                    diagnostics.add(diagnostic);
                    return null;
                }
            }
        }
        String memberType = javaMember.resolveJavaElementType(iterableOfType);
        return this.validateJavaTypePart(part, ownerSection, project, diagnostics, resolvingJavaTypeContext, memberType, null);
    }

    private ResolvedJavaTypeInfo validateMethodPart(MethodPart methodPart, Section ownerSection, Template template, QuteProject project, QuteValidationSettings validationSettings, JavaTypeFilter filter, ResolutionContext resolutionContext, ResolvedJavaTypeInfo baseType, ResolvedJavaTypeInfo iterableOfType, List<Diagnostic> diagnostics, ResolvingJavaTypeContext resolvingJavaTypeContext) {
        int nbParameters;
        boolean matchVirtualMethod;
        JavaTypeAccessibiltyRule javaTypeAccessibility;
        Object result;
        if (methodPart.isInfixNotation() && methodPart.getParameters().isEmpty()) {
            Range range = QutePositionUtility.createRange(methodPart);
            Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.InfixNotationParameterRequired, methodPart.getPartName());
            diagnostics.add(diagnostic);
            return null;
        }
        boolean undefinedType = false;
        ArrayList<ResolvedJavaTypeInfo> parameterTypes = new ArrayList<ResolvedJavaTypeInfo>();
        for (Parameter parameter : methodPart.getParameters()) {
            result = null;
            Expression expression = parameter.getJavaTypeExpression();
            if (expression != null) {
                result = this.validateExpression(expression, ownerSection, template, validationSettings, filter, resolutionContext, resolvingJavaTypeContext, diagnostics);
            }
            if (result == null || QuteCompletableFutures.RESOLVING_JAVA_TYPE == result) {
                undefinedType = true;
            }
            parameterTypes.add((ResolvedJavaTypeInfo)result);
        }
        if (undefinedType) {
            return null;
        }
        if (methodPart.isOperator()) {
            return baseType;
        }
        if (project == null) {
            return null;
        }
        String methodName = methodPart.getPartName();
        String namespace = methodPart.getNamespace();
        result = project.findMethod(baseType, namespace, methodName, parameterTypes, filter.isInNativeMode());
        JavaMethodInfo method = (JavaMethodInfo)((JavaMemberResult)result).getMember();
        if (method == null) {
            String signature = null;
            QuteErrorCode errorCode = QuteErrorCode.UnknownMethod;
            String arg = null;
            if (namespace != null) {
                errorCode = QuteErrorCode.UnknownNamespaceResolverMethod;
                arg = namespace;
            } else if (baseType != null) {
                arg = baseType.getSignature();
                InvalidMethodReason reason = project.getInvalidMethodReason(methodName, baseType);
                if (reason != null) {
                    switch (reason) {
                        case VoidReturn: {
                            errorCode = QuteErrorCode.InvalidMethodVoid;
                            break;
                        }
                        case Static: {
                            errorCode = QuteErrorCode.InvalidMethodStatic;
                            break;
                        }
                        case FromObject: {
                            errorCode = QuteErrorCode.InvalidMethodFromObject;
                            break;
                        }
                    }
                }
                signature = baseType.getSignature();
            }
            if (signature != null || errorCode == QuteErrorCode.UnknownNamespaceResolverMethod) {
                Range range = QutePositionUtility.createRange(methodPart);
                Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, errorCode, methodName, arg);
                if (signature != null) {
                    diagnostic.setData((Object)new JavaBaseTypeOfPartData(signature));
                }
                diagnostics.add(diagnostic);
            }
            return null;
        }
        if (QuteDiagnostics.canValidateMemberInNativeMode(filter, method) && !JavaTypeAccessibiltyRule.ALLOWED_WITHOUT_RESTRICTION.equals(javaTypeAccessibility = filter.getJavaTypeAccessibility(baseType, resolvingJavaTypeContext.getJavaTypesSupportedInNativeMode()))) {
            if (javaTypeAccessibility == null) {
                Range range = QutePositionUtility.createRange(methodPart);
                Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.MethodNotSupportedInNativeMode, method.getName(), baseType.getSignature());
                diagnostics.add(diagnostic);
                return null;
            }
            if (!filter.isSuperClassAllowed(method, baseType, javaTypeAccessibility)) {
                Range range = QutePositionUtility.createRange(methodPart);
                Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.InheritedMethodNotSupportedInNativeMode, method.getName(), baseType.getSignature());
                diagnostics.add(diagnostic);
                return null;
            }
            JavaTypeFilter.JavaMemberAccessibility javaMemberAccessibility = filter.getJavaMemberAccessibility(method, javaTypeAccessibility);
            switch (javaMemberAccessibility.getKind()) {
                case FORBIDDEN_BY_TEMPLATE_DATA_IGNORE: {
                    Range range = QutePositionUtility.createRange(methodPart);
                    Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.MethodIgnoredByTemplateData, method.getName(), baseType.getSignature(), javaMemberAccessibility.getIgnore());
                    diagnostics.add(diagnostic);
                    return null;
                }
                case FORBIDDEN_BY_TEMPLATE_DATA_PROPERTIES: {
                    Range range = QutePositionUtility.createRange(methodPart);
                    Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.ForbiddenByTemplateDataProperties, method.getName(), baseType.getSignature(), method.getParameters().size());
                    diagnostics.add(diagnostic);
                    return null;
                }
                case FORBIDDEN_BY_REGISTER_FOR_REFLECTION_FIELDS: 
                case FORBIDDEN_BY_REGISTER_FOR_REFLECTION_METHODS: {
                    Range range = QutePositionUtility.createRange(methodPart);
                    QuteErrorCode errorCode = method.getJavaElementKind() == JavaElementKind.METHOD ? QuteErrorCode.ForbiddenByRegisterForReflectionMethods : QuteErrorCode.ForbiddenByRegisterForReflectionFields;
                    Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, errorCode, method.getName(), baseType.getSignature());
                    diagnostics.add(diagnostic);
                    return null;
                }
            }
        }
        if (!(matchVirtualMethod = ((JavaMemberResult)result).isMatchVirtualMethod())) {
            Range range = QutePositionUtility.createRange(methodPart);
            Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.InvalidVirtualMethod, method.getName(), method.getSimpleSourceType(), baseType.getJavaElementSimpleType());
            diagnostics.add(diagnostic);
            return null;
        }
        if (methodPart.isInfixNotation() && (nbParameters = method.getParameters().size() - (method.isVirtual() ? 1 : 0)) != 1) {
            Range range = QutePositionUtility.createRange(methodPart);
            Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.InvalidMethodInfixNotation, methodName);
            diagnostics.add(diagnostic);
            return null;
        }
        boolean matchParameters = ((JavaMemberResult)result).isMatchParameters();
        if (!matchParameters) {
            StringBuilder expectedSignature = new StringBuilder("(");
            boolean ignoreParameter = method.isVirtual();
            for (JavaParameterInfo javaParameterInfo : method.getParameters()) {
                if (!ignoreParameter) {
                    if (expectedSignature.length() > 1) {
                        expectedSignature.append(", ");
                    }
                    expectedSignature.append(javaParameterInfo.getJavaElementSimpleType());
                }
                ignoreParameter = false;
            }
            expectedSignature.append(")");
            expectedSignature.insert(0, method.getName());
            StringBuilder actualSignature = new StringBuilder("(");
            for (ResolvedJavaTypeInfo parameterType : parameterTypes) {
                if (actualSignature.length() > 1) {
                    actualSignature.append(", ");
                }
                actualSignature.append(parameterType != null ? parameterType.getJavaElementSimpleType() : parameterType);
            }
            actualSignature.append(")");
            Range range = QutePositionUtility.createRange(methodPart);
            Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.InvalidMethodParameter, expectedSignature.toString(), method.getSimpleSourceType(), actualSignature.toString());
            diagnostics.add(diagnostic);
            return null;
        }
        if (method.isVoidMethod()) {
            return null;
        }
        if (ownerSection != null && FORM_SECTION_TAG.equals(ownerSection.getTag())) {
            QuteDiagnostics.validateRenardeFormSectionParameters(ownerSection, ((JavaMemberResult)result).getMember(), baseType.getSignature(), diagnostics);
        }
        String memberType = method.resolveJavaElementType(iterableOfType);
        return this.validateJavaTypePart(methodPart, ownerSection, project, diagnostics, resolvingJavaTypeContext, memberType, null);
    }

    private static boolean canValidateMemberInNativeMode(JavaTypeFilter filter, JavaMemberInfo member) {
        JavaMethodInfo method;
        if (member.getJavaElementKind() == JavaElementKind.METHOD && (method = (JavaMethodInfo)member).isVirtual()) {
            return false;
        }
        return filter.isInNativeMode();
    }

    private ResolvedJavaTypeInfo validateJavaTypePart(Part part, Section ownerSection, QuteProject project, List<Diagnostic> diagnostics, ResolvingJavaTypeContext resolvingJavaTypeContext, String javaTypeToResolve, Node referencedNode) {
        if (StringUtils.isEmpty(javaTypeToResolve)) {
            if (referencedNode != null && referencedNode.getKind() == NodeKind.Parameter && ((Parameter)referencedNode).isOptional()) {
                return null;
            }
            Range range = QutePositionUtility.createRange(part);
            Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.UnknownType, part.getPartName());
            diagnostics.add(diagnostic);
            return null;
        }
        if (LiteralSupport.isNull(javaTypeToResolve)) {
            return null;
        }
        if (project == null) {
            return null;
        }
        CompletableFuture<ResolvedJavaTypeInfo> resolvingJavaTypeFuture = null;
        resolvingJavaTypeFuture = part.getPartKind() == Parts.PartKind.Object ? project.resolveJavaType(part) : project.resolveJavaType(javaTypeToResolve, true);
        ResolvedJavaTypeInfo resolvedJavaType = resolvingJavaTypeFuture.getNow(QuteCompletableFutures.RESOLVING_JAVA_TYPE);
        if (QuteCompletableFutures.isResolvingJavaType(resolvedJavaType)) {
            LOGGER.log(Level.INFO, QuteErrorCode.ResolvingJavaType.getMessage(javaTypeToResolve));
            resolvingJavaTypeContext.add(resolvingJavaTypeFuture);
            return QuteCompletableFutures.RESOLVING_JAVA_TYPE;
        }
        if (resolvedJavaType == null) {
            Range range = QutePositionUtility.createRange(part);
            Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.UnknownType, javaTypeToResolve);
            diagnostics.add(diagnostic);
            return null;
        }
        return this.validateIterable(part, ownerSection, resolvedJavaType, javaTypeToResolve, diagnostics);
    }

    private ResolvedJavaTypeInfo validateIterable(Part part, Section ownerSection, ResolvedJavaTypeInfo resolvedJavaType, String javaTypeToResolve, List<Diagnostic> diagnostics) {
        if (part != null && part.isLast() && ownerSection != null && ownerSection.isIterable() && !resolvedJavaType.isIterable() && !resolvedJavaType.isInteger()) {
            String expression = part.getParent().getContent();
            Range range = QutePositionUtility.createRange(part);
            Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.IterationError, expression, javaTypeToResolve);
            diagnostics.add(diagnostic);
            return null;
        }
        return resolvedJavaType;
    }

    private void validateCaseSectionParameters(CaseSection caseSection, Section whenSection, Template template, ResolvedJavaTypeInfo whenType, QuteProject project, List<Diagnostic> diagnostics) {
        String expression = whenSection.getExpressionContent();
        List<Parameter> parameters = caseSection.getParameters();
        String whenTypeName = whenType.getSignature();
        if (parameters.isEmpty()) {
            Range range = QutePositionUtility.createRange(caseSection.getStartTagNameOpenOffset(), caseSection.getStartTagNameCloseOffset(), template);
            Diagnostic diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.MissingParameter, caseSection.getTag());
            diagnostics.add(diagnostic);
            return;
        }
        Parameter firstParameter = parameters.get(0);
        for (int i = 0; i < parameters.size(); ++i) {
            Diagnostic diagnostic;
            Range range;
            String caseJavaType;
            Diagnostic diagnostic2;
            Range range2;
            Parameter parameter = parameters.get(i);
            String parameterName = parameter.getName();
            CaseOperator caseOperator = caseSection.getCaseOperator();
            if (caseOperator == null) {
                if (i > 0) {
                    range2 = QutePositionUtility.createRange(firstParameter);
                    diagnostic2 = DiagnosticDataFactory.createDiagnostic(range2, DiagnosticSeverity.Error, QuteErrorCode.InvalidOperator, firstParameter.getName(), caseSection.getTag(), caseSection.getAllowedOperators().stream().map(Operator::getName).collect(Collectors.joining(", ", "[", "]")));
                    diagnostics.add(diagnostic2);
                    return;
                }
            } else {
                if (i == 0) continue;
                if (i > 1 && !caseOperator.isMulti()) {
                    range2 = QutePositionUtility.createRange(parameter);
                    diagnostic2 = DiagnosticDataFactory.createDiagnostic(range2, DiagnosticSeverity.Error, QuteErrorCode.UnexpectedParameter, parameterName, firstParameter.getName(), caseSection.getTag());
                    diagnostics.add(diagnostic2);
                    continue;
                }
            }
            if ((caseJavaType = LiteralSupport.getLiteralJavaType(parameter.getValue())) == null && project.findMember(whenType, parameterName) == null) {
                if (i == 0 && parameters.size() > 1) {
                    range = QutePositionUtility.createRange(parameter);
                    diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.InvalidOperator, parameterName, caseSection.getTag(), caseSection.getAllowedOperators().stream().map(Operator::getName).collect(Collectors.joining(", ", "[", "]")));
                    diagnostics.add(diagnostic);
                    return;
                }
                range = QutePositionUtility.createRange(parameter);
                diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.UnexpectedValueInCaseSection, parameterName, expression, whenTypeName);
                diagnostics.add(diagnostic);
                continue;
            }
            if (caseJavaType == null || whenTypeName.equals(caseJavaType)) continue;
            if (i == 0 && parameters.size() > 1) {
                range = QutePositionUtility.createRange(parameter);
                diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.InvalidOperator, parameterName, caseSection.getTag(), caseSection.getAllowedOperators().stream().map(Operator::getName).collect(Collectors.joining(", ", "[", "]")));
                diagnostics.add(diagnostic);
                return;
            }
            range = QutePositionUtility.createRange(parameter);
            diagnostic = DiagnosticDataFactory.createDiagnostic(range, DiagnosticSeverity.Error, QuteErrorCode.UnexpectedMemberTypeInCaseSection, caseJavaType, expression, whenTypeName);
            diagnostics.add(diagnostic);
        }
    }

    private class ResolutionContext
    extends HashMap<String, ResolvedJavaTypeInfo> {
        private static final long serialVersionUID = 1L;
        private final ResolutionContext parent;
        private ResolvedJavaTypeInfo withObject;
        private ResolvedJavaTypeInfo whenObject;

        public ResolutionContext() {
            this(null);
        }

        public ResolutionContext(ResolutionContext parent) {
            this.parent = parent;
        }

        public ResolutionContext getParent() {
            return this.parent;
        }

        public void setWithObject(ResolvedJavaTypeInfo withObject) {
            this.withObject = withObject;
        }

        public void setWhenObject(ResolvedJavaTypeInfo whenObject) {
            this.whenObject = whenObject;
        }

        public JavaMemberInfo findMemberWithObject(String property, QuteProject project) {
            JavaMemberInfo member;
            if (this.withObject != null && (member = project.findMember(this.withObject, property)) != null) {
                return member;
            }
            for (ResolutionContext parent = this.parent; parent != null; parent = parent.getParent()) {
                JavaMemberInfo member2 = parent.findMemberWithObject(property, project);
                if (member2 == null) continue;
                return member2;
            }
            return null;
        }
    }
}

