/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services;

import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionKind;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.template.sections.IncludeSection;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.utils.QutePositionUtility;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class QuteDocumentLink {
    public CompletableFuture<List<DocumentLink>> findDocumentLinks(Template template, CancelChecker cancelChecker) {
        QuteProject project = template.getProject();
        if (project != null) {
            return CompletableFuture.completedFuture(this.findDocumentLinksSync(template, cancelChecker));
        }
        return template.getProjectFuture().thenApply(p -> {
            if (p == null) {
                return Collections.emptyList();
            }
            return this.findDocumentLinksSync(template, cancelChecker);
        });
    }

    public List<DocumentLink> findDocumentLinksSync(Template template, CancelChecker cancelChecker) {
        ArrayList<DocumentLink> links = new ArrayList<DocumentLink>();
        this.findDocumentLinks(template, template, links, cancelChecker);
        return links;
    }

    private void findDocumentLinks(Node node, Template template, List<DocumentLink> links, CancelChecker cancelChecker) {
        List<Node> children = node.getChildren();
        for (Node child : children) {
            Path templateFile;
            Range range;
            IncludeSection includeSection;
            Parameter includedTemplateId;
            Section section;
            cancelChecker.checkCanceled();
            if (child.getKind() == NodeKind.Section && (section = (Section)child).getSectionKind() == SectionKind.INCLUDE && (includedTemplateId = (includeSection = (IncludeSection)section).getParameterAtIndex(0)) != null && (range = QutePositionUtility.createRange(includedTemplateId.getStart(), includedTemplateId.getEnd(), template)) != null && (templateFile = includeSection.getReferencedTemplateFile()) != null) {
                String target = templateFile.toUri().toASCIIString();
                links.add(new DocumentLink(range, target != null ? target : ""));
            }
            this.findDocumentLinks(child, template, links, cancelChecker);
        }
    }
}

