/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services;

import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.parser.expression.ObjectPart;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.NodeKind;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionKind;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.utils.QutePositionUtility;
import com.redhat.qute.utils.QuteSearchUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class QuteHighlighting {
    private static final Logger LOGGER = Logger.getLogger(QuteHighlighting.class.getName());

    QuteHighlighting() {
    }

    public List<DocumentHighlight> findDocumentHighlights(Template template, Position position, CancelChecker cancelChecker) {
        try {
            ArrayList<DocumentHighlight> highlights = new ArrayList<DocumentHighlight>();
            int offset = template.offsetAt(position);
            Node node = template.findNodeAt(offset);
            if (node == null) {
                return Collections.emptyList();
            }
            node = QutePositionUtility.findBestNode(offset, node);
            switch (node.getKind()) {
                case ParameterDeclaration: 
                case Parameter: {
                    QuteHighlighting.highlightReferenceObjectPart(node, offset, highlights, cancelChecker);
                    break;
                }
                case ExpressionPart: {
                    Parameter parameter;
                    Part part = (Part)node;
                    if (part.getPartKind() != Parts.PartKind.Object) break;
                    ObjectPart objectPart = (ObjectPart)part;
                    this.highlightDeclaredObject(objectPart, highlights, cancelChecker);
                    if (highlights.size() != 1 || !part.isOptional() || (parameter = objectPart.getOwnerParameter()) == null || parameter.getOwnerSection() == null || parameter.getOwnerSection().getSectionKind() != SectionKind.IF) break;
                    highlights.clear();
                    QuteHighlighting.highlightReferenceObjectPart(parameter, offset, highlights, cancelChecker);
                    break;
                }
                case Section: {
                    QuteHighlighting.higlightSection((Section)node, offset, position, highlights, cancelChecker);
                    break;
                }
            }
            return highlights;
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "In QuteHighlighting the client provided Position is at a BadLocation", e);
            return Collections.emptyList();
        }
    }

    private void highlightDeclaredObject(ObjectPart part, List<DocumentHighlight> highlights, CancelChecker cancelChecker) {
        QuteSearchUtils.searchDeclaredObject(part, (referencedNode, referencedRange) -> highlights.add(new DocumentHighlight(referencedRange, highlights.isEmpty() ? DocumentHighlightKind.Read : DocumentHighlightKind.Write)), true, cancelChecker);
    }

    private static void highlightReferenceObjectPart(Node node, int offset, List<DocumentHighlight> highlights, CancelChecker cancelChecker) {
        QuteSearchUtils.searchReferencedObjects(node, offset, (referencedNode, referencedRange) -> highlights.add(new DocumentHighlight(referencedRange, highlights.isEmpty() ? DocumentHighlightKind.Write : DocumentHighlightKind.Read)), true, cancelChecker);
    }

    private static void higlightSection(Section section, int offset, Position position, List<DocumentHighlight> highlights, CancelChecker cancelChecker) throws BadLocationException {
        if (section.isInStartTagName(offset) || section.isInEndTagName(offset)) {
            QuteHighlighting.highlightSectionTag(section, highlights);
            if (!section.getBlockLabels().isEmpty()) {
                for (Node node : section.getChildren()) {
                    if (node.getKind() != NodeKind.Section || !section.getBlockLabels().contains((Object)((Section)node).getSectionKind())) continue;
                    Section nestedBlock = (Section)node;
                    QuteHighlighting.highlightSectionTag(nestedBlock, highlights);
                }
            } else {
                Section parentSection = section.getParentSection();
                if (parentSection != null && parentSection.getBlockLabels().contains((Object)section.getSectionKind())) {
                    QuteHighlighting.highlightSectionTag(parentSection, highlights);
                }
            }
        } else {
            QuteHighlighting.highlightReferenceObjectPart(section, offset, highlights, cancelChecker);
        }
    }

    public static void highlightSectionTag(Section section, List<DocumentHighlight> highlights) {
        Range startTagRange = QutePositionUtility.selectStartTagName(section);
        QuteHighlighting.highlight(startTagRange, DocumentHighlightKind.Read, highlights);
        Range endTagRange = section.hasEndTag() ? QutePositionUtility.selectEndTagName(section) : null;
        QuteHighlighting.highlight(endTagRange, DocumentHighlightKind.Read, highlights);
    }

    private static void highlight(Range range, DocumentHighlightKind kind, List<DocumentHighlight> result) {
        if (range != null) {
            result.add(new DocumentHighlight(range, kind));
        }
    }
}

