/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.services;

import com.redhat.qute.commons.JavaMemberInfo;
import com.redhat.qute.commons.JavaTypeInfo;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.ls.commons.BadLocationException;
import com.redhat.qute.ls.commons.snippets.Snippet;
import com.redhat.qute.ls.commons.snippets.SnippetRegistryProvider;
import com.redhat.qute.parser.expression.MethodPart;
import com.redhat.qute.parser.expression.Part;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.template.CaseOperator;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.ParameterDeclaration;
import com.redhat.qute.parser.template.Section;
import com.redhat.qute.parser.template.SectionKind;
import com.redhat.qute.parser.template.SectionMetadata;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.template.sections.CaseSection;
import com.redhat.qute.parser.template.sections.LoopSection;
import com.redhat.qute.project.JavaMemberResult;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.datamodel.resolvers.MethodValueResolver;
import com.redhat.qute.project.tags.UserTag;
import com.redhat.qute.services.QuteCompletableFutures;
import com.redhat.qute.services.hover.HoverRequest;
import com.redhat.qute.settings.QuteNativeSettings;
import com.redhat.qute.settings.SharedSettings;
import com.redhat.qute.utils.DocumentationUtils;
import com.redhat.qute.utils.QutePositionUtility;
import com.redhat.qute.utils.UserTagUtils;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class QuteHover {
    private static final Logger LOGGER = Logger.getLogger(QuteHover.class.getName());
    private static CompletableFuture<Hover> NO_HOVER = CompletableFuture.completedFuture(null);
    private final SnippetRegistryProvider<Snippet> snippetRegistryProvider;

    public QuteHover(SnippetRegistryProvider<Snippet> snippetRegistryProvider) {
        this.snippetRegistryProvider = snippetRegistryProvider;
    }

    public CompletableFuture<Hover> doHover(Template template, Position position, SharedSettings settings, CancelChecker cancelChecker) {
        cancelChecker.checkCanceled();
        QuteNativeSettings nativeSettings = settings.getNativeSettings();
        HoverRequest hoverRequest = null;
        try {
            hoverRequest = new HoverRequest(template, position, settings);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Failed creating HoverRequest", e);
            return NO_HOVER;
        }
        Node node = hoverRequest.getNode();
        if (node == null) {
            return NO_HOVER;
        }
        switch (node.getKind()) {
            case Section: {
                Section section = (Section)node;
                return this.doHoverForSection(section, template, hoverRequest, cancelChecker);
            }
            case ParameterDeclaration: {
                ParameterDeclaration parameterDeclaration = (ParameterDeclaration)node;
                return this.doHoverForParameterDeclaration(parameterDeclaration, template, hoverRequest, cancelChecker);
            }
            case ExpressionPart: {
                Part part = (Part)node;
                return this.doHoverForExpressionPart(part, template, hoverRequest, nativeSettings, cancelChecker);
            }
            case Parameter: {
                Parameter parameter = (Parameter)node;
                return this.doHoverForParameter(parameter, template, hoverRequest);
            }
        }
        return NO_HOVER;
    }

    private CompletableFuture<Hover> doHoverForSection(Section section, Template template, HoverRequest hoverRequest, CancelChecker cancelChecker) {
        if (section.hasTag()) {
            String tagName = section.getTag();
            if (section.getSectionKind() == SectionKind.CUSTOM) {
                Range range;
                UserTag userTag;
                QuteProject project = template.getProject();
                if (project != null && (userTag = project.findUserTag(tagName)) != null && (range = QuteHover.createSectionTagRange(section, hoverRequest)) != null) {
                    boolean hasMarkdown = hoverRequest.canSupportMarkupKind("markdown");
                    MarkupContent content = DocumentationUtils.getDocumentation(userTag, hasMarkdown);
                    Hover hover = new Hover(content, range);
                    return CompletableFuture.completedFuture(hover);
                }
            } else {
                Optional<Snippet> snippetSection = this.snippetRegistryProvider.getSnippetRegistry().getSnippets().stream().filter(snippet -> tagName.equals(snippet.getLabel())).findFirst();
                if (snippetSection.isPresent()) {
                    Snippet snippet2 = snippetSection.get();
                    Range range = QuteHover.createSectionTagRange(section, hoverRequest);
                    if (range != null) {
                        boolean hasMarkdown = hoverRequest.canSupportMarkupKind("markdown");
                        MarkupContent content = DocumentationUtils.getDocumentation(snippet2, hasMarkdown);
                        Hover hover = new Hover(content, range);
                        return CompletableFuture.completedFuture(hover);
                    }
                }
            }
        }
        return NO_HOVER;
    }

    private static Range createSectionTagRange(Section section, HoverRequest hoverRequest) {
        int offset = hoverRequest.getOffset();
        Range range = null;
        if (section.isInStartTagName(offset)) {
            range = QutePositionUtility.selectStartTagName(section);
        } else if (section.isInEndTagName(offset)) {
            range = QutePositionUtility.selectEndTagName(section);
        }
        return range;
    }

    private CompletableFuture<Hover> doHoverForParameterDeclaration(ParameterDeclaration parameterDeclaration, Template template, HoverRequest hoverRequest, CancelChecker cancelChecker) {
        QuteProject project = template.getProject();
        if (project == null) {
            return NO_HOVER;
        }
        ParameterDeclaration.JavaTypeRangeOffset classNameRange = parameterDeclaration.getJavaTypeNameRange(hoverRequest.getOffset());
        if (classNameRange != null && classNameRange != null) {
            String className = template.getText(classNameRange);
            return project.resolveJavaType(className).thenApply(resolvedType -> {
                cancelChecker.checkCanceled();
                if (resolvedType != null) {
                    boolean hasMarkdown = hoverRequest.canSupportMarkupKind("markdown");
                    MarkupContent content = DocumentationUtils.getDocumentation(resolvedType, hasMarkdown);
                    Range range = QutePositionUtility.createRange(classNameRange, template);
                    return new Hover(content, range);
                }
                return null;
            });
        }
        return NO_HOVER;
    }

    private CompletableFuture<Hover> doHoverForExpressionPart(Part part, Template template, HoverRequest hoverRequest, QuteNativeSettings nativeSettings, CancelChecker cancelChecker) {
        QuteProject project = template.getProject();
        String namespace = part.getNamespace();
        if (namespace != null) {
            return this.doHoverForExpressionPartWithNamespace(namespace, part, template, project, hoverRequest, cancelChecker);
        }
        switch (part.getPartKind()) {
            case Namespace: {
                return this.doHoverForNamespacePart(part, project, hoverRequest, cancelChecker);
            }
            case Object: {
                return this.doHoverForObjectPart(part, project, hoverRequest, cancelChecker);
            }
            case Method: {
                return this.doHoverForMethodInvocation((MethodPart)part, project, hoverRequest, nativeSettings, cancelChecker);
            }
            case Property: {
                return this.doHoverForPropertyPart(part, project, hoverRequest, cancelChecker);
            }
        }
        return NO_HOVER;
    }

    public CompletableFuture<Hover> doHoverForExpressionPartWithNamespace(String namespace, Part part, Template template, QuteProject project, HoverRequest hoverRequest, CancelChecker cancelChecker) {
        if ("data".equals(namespace)) {
            ParameterDeclaration parameterDeclaration = template.findInParameterDeclarationByAlias(part.getPartName());
            if (parameterDeclaration != null) {
                return this.doHoverForJavaType(part, parameterDeclaration.getJavaType(), project, hoverRequest, cancelChecker);
            }
            if (project != null) {
                return template.getParameterDataModel(part.getPartName()).thenCompose(parameter -> {
                    cancelChecker.checkCanceled();
                    if (parameter != null) {
                        return this.doHoverForJavaType(part, parameter.getJavaType(), project, hoverRequest, cancelChecker);
                    }
                    return NO_HOVER;
                });
            }
            return NO_HOVER;
        }
        if (project != null) {
            return project.findJavaElementWithNamespace(namespace, part.getPartName()).thenApply(javaElement -> {
                if (javaElement == null) {
                    return null;
                }
                if (javaElement instanceof JavaTypeInfo) {
                    return QuteHover.doHoverForJavaType(part, (JavaTypeInfo)javaElement, hoverRequest);
                }
                JavaMemberInfo member = (JavaMemberInfo)javaElement;
                boolean hasMarkdown = hoverRequest.canSupportMarkupKind("markdown");
                MarkupContent content = DocumentationUtils.getDocumentation(member, null, hasMarkdown);
                Range range = QutePositionUtility.createRange(part);
                return new Hover(content, range);
            });
        }
        return NO_HOVER;
    }

    private CompletableFuture<Hover> doHoverForNamespacePart(Part part, QuteProject project, HoverRequest hoverRequest, CancelChecker cancelChecker) {
        String namespace = part.getPartName();
        return project.getNamespaceResolverInfo(namespace).thenCompose(namespaceInfo -> {
            cancelChecker.checkCanceled();
            if (namespaceInfo != null) {
                boolean hasMarkdown = hoverRequest.canSupportMarkupKind("markdown");
                MarkupContent content = DocumentationUtils.getDocumentation(namespace, namespaceInfo, hasMarkdown);
                Range range = QutePositionUtility.createRange(part);
                Hover hover = new Hover(content, range);
                return CompletableFuture.completedFuture(hover);
            }
            return NO_HOVER;
        });
    }

    private CompletableFuture<Hover> doHoverForObjectPart(Part part, QuteProject project, HoverRequest hoverRequest, CancelChecker cancelChecker) {
        Parameter operatorParam;
        CaseSection caseSection;
        SectionMetadata specialKey;
        if (UserTagUtils.isUserTag(hoverRequest.getTemplate()) && (specialKey = UserTagUtils.getSpecialKey(part.getPartName())) != null) {
            boolean hasMarkdown = hoverRequest.canSupportMarkupKind("markdown");
            MarkupContent content = DocumentationUtils.getDocumentation(specialKey, hasMarkdown);
            Range range = QutePositionUtility.createRange(part);
            Hover hover = new Hover(content, range);
            return CompletableFuture.completedFuture(hover);
        }
        Expression expression = part.getParent().getParent();
        if (CaseSection.isCaseSection(expression.getOwnerSection()) && (caseSection = (CaseSection)expression.getOwnerSection()).isCaseOperator(operatorParam = caseSection.getParameterAtOffset(part.getStart()))) {
            CaseOperator operator = caseSection.getCaseOperator();
            boolean hasMarkdown = hoverRequest.canSupportMarkupKind("markdown");
            MarkupContent content = DocumentationUtils.getDocumentation(operator, hasMarkdown);
            Range range = QutePositionUtility.createRange(operatorParam);
            Hover hover = new Hover(content, range);
            return CompletableFuture.completedFuture(hover);
        }
        if (project == null) {
            return NO_HOVER;
        }
        String literalJavaType = expression.getLiteralJavaType();
        if (literalJavaType != null) {
            return this.doHoverForJavaType(part, literalJavaType, project, hoverRequest, cancelChecker);
        }
        return project.resolveJavaType(part).thenApply(resolvedJavaType -> {
            cancelChecker.checkCanceled();
            if (QuteCompletableFutures.isValidJavaType(resolvedJavaType)) {
                SectionMetadata metadata = QuteHover.getMetadata(part);
                boolean hasMarkdown = hoverRequest.canSupportMarkupKind("markdown");
                MarkupContent content = DocumentationUtils.getDocumentation(resolvedJavaType, metadata != null ? metadata.getDescription() : null, hasMarkdown);
                Range range = QutePositionUtility.createRange(part);
                return new Hover(content, range);
            }
            return null;
        });
    }

    public CompletableFuture<Hover> doHoverForJavaType(Part part, String javaType, QuteProject project, HoverRequest hoverRequest, CancelChecker cancelChecker) {
        return project.resolveJavaType(javaType).thenApply(resolvedJavaType -> {
            cancelChecker.checkCanceled();
            return QuteHover.doHoverForJavaType(part, resolvedJavaType, hoverRequest);
        });
    }

    private static Hover doHoverForJavaType(Part part, JavaTypeInfo javaType, HoverRequest hoverRequest) {
        if (javaType != null) {
            boolean hasMarkdown = hoverRequest.canSupportMarkupKind("markdown");
            MarkupContent content = DocumentationUtils.getDocumentation(javaType, hasMarkdown);
            Range range = QutePositionUtility.createRange(part);
            return new Hover(content, range);
        }
        return null;
    }

    private static SectionMetadata getMetadata(Part part) {
        Section section = part.getParentSection();
        if (section == null) {
            return null;
        }
        return (SectionMetadata)section.getMetadata(part.getPartName());
    }

    private CompletableFuture<Hover> doHoverForMethodInvocation(MethodPart part, QuteProject project, HoverRequest hoverRequest, QuteNativeSettings nativeSettings, CancelChecker cancelChecker) {
        if (project == null) {
            return NO_HOVER;
        }
        Parts parts = part.getParent();
        Part previousPart = parts.getPreviousPart(part);
        return project.resolveJavaType(previousPart).thenCompose(resolvedJavaType -> {
            cancelChecker.checkCanceled();
            if (resolvedJavaType != null) {
                ResolvedJavaTypeInfo iterableOfResolvedType = resolvedJavaType.isArray() ? null : resolvedJavaType;
                return this.doHoverForMethodInvocation(part, project, (ResolvedJavaTypeInfo)resolvedJavaType, iterableOfResolvedType, hoverRequest, nativeSettings, cancelChecker);
            }
            return NO_HOVER;
        });
    }

    private CompletableFuture<Hover> doHoverForMethodInvocation(MethodPart part, QuteProject project, ResolvedJavaTypeInfo resolvedType, ResolvedJavaTypeInfo iterableOfResolvedType, HoverRequest hoverRequest, QuteNativeSettings nativeSettings, CancelChecker cancelChecker) {
        ResolvedJavaTypeInfo[] parameterTypes = new ResolvedJavaTypeInfo[part.getParameters().size()];
        CompletableFuture[] paramResolveFutures = new CompletableFuture[part.getParameters().size()];
        for (int i = 0; i < part.getParameters().size(); ++i) {
            int index = i;
            CompletionStage paramResolveFuture = project.resolveJavaType(part.getParameters().get(i)).thenAccept(resolvedJavaType -> {
                parameterTypes[index] = resolvedJavaType;
            });
            paramResolveFutures[i] = paramResolveFuture;
        }
        return CompletableFuture.allOf(paramResolveFutures).thenCompose(unused -> {
            cancelChecker.checkCanceled();
            boolean hasMarkdown = hoverRequest.canSupportMarkupKind("markdown");
            JavaMemberResult memberResult = project.findMethod(resolvedType, null, part.getPartName(), Arrays.asList(parameterTypes), nativeSettings.isEnabled());
            if (memberResult == null || !memberResult.isMatchParameters() || memberResult.getMember() == null) {
                MethodValueResolver member = project.findValueResolver(resolvedType, part.getPartName());
                if (member == null) {
                    return NO_HOVER;
                }
                MarkupContent content = DocumentationUtils.getDocumentation(member, iterableOfResolvedType, hasMarkdown);
                Range range = QutePositionUtility.createRange(part);
                return CompletableFuture.completedFuture(new Hover(content, range));
            }
            if (memberResult.getMember().getDocumentation() == null && resolvedType != null) {
                CompletionStage javadocFetchFuture = project.getJavadoc(memberResult.getMember(), resolvedType, hasMarkdown).thenAccept(documentation -> memberResult.getMember().setDocumentation(documentation == null ? "" : documentation));
                return ((CompletableFuture)javadocFetchFuture).thenApply(alsoUnused -> {
                    MarkupContent content = DocumentationUtils.getDocumentation(memberResult.getMember(), iterableOfResolvedType, hasMarkdown);
                    Range range = QutePositionUtility.createRange(part);
                    return new Hover(content, range);
                });
            }
            MarkupContent content = DocumentationUtils.getDocumentation(memberResult.getMember(), iterableOfResolvedType, hasMarkdown);
            Range range = QutePositionUtility.createRange(part);
            return CompletableFuture.completedFuture(new Hover(content, range));
        });
    }

    private CompletableFuture<Hover> doHoverForPropertyPart(Part part, QuteProject project, HoverRequest hoverRequest, CancelChecker cancelChecker) {
        Parts parts = part.getParent();
        Part previousPart = parts.getPreviousPart(part);
        return project.resolveJavaType(previousPart).thenCompose(resolvedJavaType -> {
            cancelChecker.checkCanceled();
            if (QuteCompletableFutures.isValidJavaType(resolvedJavaType)) {
                ResolvedJavaTypeInfo iterableOfResolvedType = resolvedJavaType.isArray() ? null : resolvedJavaType;
                return this.doHoverForPropertyPart(part, project, (ResolvedJavaTypeInfo)resolvedJavaType, iterableOfResolvedType, hoverRequest);
            }
            return NO_HOVER;
        });
    }

    private CompletableFuture<Hover> doHoverForPropertyPart(Part part, QuteProject project, ResolvedJavaTypeInfo resolvedType, ResolvedJavaTypeInfo iterableOfResolvedType, HoverRequest hoverRequest) {
        if (project == null) {
            return NO_HOVER;
        }
        JavaMemberInfo member = project.findMember(resolvedType, part.getPartName());
        if (member == null) {
            return NO_HOVER;
        }
        boolean hasMarkdown = hoverRequest.canSupportMarkupKind("markdown");
        if (member.getDocumentation() == null) {
            CompletionStage fetchDocsFuture = project.getJavadoc(member, resolvedType, hasMarkdown).thenAccept(documentation -> member.setDocumentation(documentation == null ? "" : documentation));
            return ((CompletableFuture)fetchDocsFuture).thenApply(unusedNull -> {
                MarkupContent content = DocumentationUtils.getDocumentation(member, iterableOfResolvedType, hasMarkdown);
                Range range = QutePositionUtility.createRange(part);
                return new Hover(content, range);
            });
        }
        MarkupContent content = DocumentationUtils.getDocumentation(member, iterableOfResolvedType, hasMarkdown);
        Range range = QutePositionUtility.createRange(part);
        return CompletableFuture.completedFuture(new Hover(content, range));
    }

    private CompletableFuture<Hover> doHoverForParameter(Parameter parameter, Template template, HoverRequest hoverRequest) {
        QuteProject project = template.getProject();
        if (project == null) {
            return NO_HOVER;
        }
        int offset = hoverRequest.getOffset();
        if (parameter.isInName(offset)) {
            if (parameter.getOwnerSection() != null && (parameter.getOwnerSection().getSectionKind() == SectionKind.FOR || parameter.getOwnerSection().getSectionKind() == SectionKind.EACH)) {
                Parameter iterableParameter;
                LoopSection iterableSection = (LoopSection)parameter.getOwnerSection();
                if (iterableSection.isInAlias(offset) && (iterableParameter = iterableSection.getIterableParameter()) != null) {
                    boolean hasMarkdown = hoverRequest.canSupportMarkupKind("markdown");
                    Part iterablePart = iterableParameter.getJavaTypeExpression().getLastPart();
                    return project.resolveJavaType(iterablePart).thenCompose(resolvedJavaType -> {
                        if (resolvedJavaType != null && resolvedJavaType.isIterable()) {
                            return project.resolveJavaType(resolvedJavaType.getIterableOf()).thenApply(resolvedIterableOf -> {
                                MarkupContent content = DocumentationUtils.getDocumentation(resolvedIterableOf, hasMarkdown);
                                Range range = QutePositionUtility.createRange(parameter);
                                return new Hover(content, range);
                            });
                        }
                        return NO_HOVER;
                    });
                }
            } else {
                Expression expression = parameter.getJavaTypeExpression();
                if (expression != null) {
                    String literalJavaType = expression.getLiteralJavaType();
                    if (literalJavaType != null) {
                        return project.resolveJavaType(literalJavaType).thenApply(resolvedJavaType -> {
                            if (resolvedJavaType != null) {
                                boolean hasMarkdown = hoverRequest.canSupportMarkupKind("markdown");
                                MarkupContent content = DocumentationUtils.getDocumentation(resolvedJavaType, hasMarkdown);
                                Range range = QutePositionUtility.createRange(parameter);
                                return new Hover(content, range);
                            }
                            return null;
                        });
                    }
                    return project.resolveJavaType(parameter).thenApply(resolvedJavaType -> {
                        if (resolvedJavaType != null) {
                            boolean hasMarkdown = hoverRequest.canSupportMarkupKind("markdown");
                            MarkupContent content = DocumentationUtils.getDocumentation(resolvedJavaType, hasMarkdown);
                            Range range = QutePositionUtility.createRange(parameter);
                            return new Hover(content, range);
                        }
                        return null;
                    });
                }
            }
        }
        return NO_HOVER;
    }
}

